package com.els.base.certification.management.service.impl;

import com.els.base.certification.management.dao.ProcessManagementMapper;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.entity.ProcessManagementExample;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultProcessManagementService")
public class ProcessManagementServiceImpl implements ProcessManagementService {
    @Resource
    protected ProcessManagementMapper processManagementMapper;
    
    @Resource
	protected GenerateCodeService generateCodeService;
   
    @Resource
    protected ProcessService processService;

    @CacheEvict(value={"processManagement"}, allEntries=true)
    @Override
    public void addObj(ProcessManagement t) {
        this.processManagementMapper.insertSelective(t);
    }
    
    @CacheEvict(value={"processManagement"}, allEntries=true)
    @Override
	public void insert(User user, Company purCompany, ProcessManagement processManagement) {
		Assert.isNotBlank(processManagement.getProcessName(), "流程名称不能为空");
		Assert.isNotBlank(processManagement.getAccessProcess(), "准入流程不能为空");
		Assert.isNotBlank(processManagement.getSupClassificationName(), "供应商分类名不能为空");
		// 根据选择的准入流程来判断资质、现场考察模版不能为空
		if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(processManagement.getAccessProcess())) {
			// 只资质审核，资质审核模版不能为空
			Assert.isNotBlank(processManagement.getQualificationAuditTemplateId(), "只资质审核时，资质审核模版不能为空");
		} else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(processManagement.getAccessProcess())) {
			// 只现场考察，现场考察模版不能为空
			Assert.isNotBlank(processManagement.getSiteInspectionTemplateId(), "只现场考察时，现场考察模版不能为空");
		} else if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(processManagement.getAccessProcess())) {
			// 资质审核->现场考察，资质、现场考察模版都不能为空
			Assert.isNotBlank(processManagement.getQualificationAuditTemplateId(), "资质审核模版不能为空");
			Assert.isNotBlank(processManagement.getSiteInspectionTemplateId(), "现场考察模版不能为空");
		}
		// 设置采购商信息
		processManagement.setPurCompanyName(purCompany.getCompanyFullName());
		processManagement.setPurCompanySrmCode(purCompany.getCompanyCode());
		processManagement.setPurUserId(user.getId());
		// 创建人
		processManagement.setSinglePerson(user.getNickName());
		// 流程编号
		processManagement.setProcessNumber(generateCodeService.getNextCode("ADMITTANCE_PROCESS_NO"));
		// 是否可用
		processManagement.setIsEnable(Constant.YES_INT);
		// 创建、修改时间
		processManagement.setCreateTime(new Date());
		processManagement.setUpdateTime(new Date());
		
		// 保存
		this.processManagementMapper.insertSelective(processManagement);
		
	}

    @CacheEvict(value={"processManagement"}, allEntries=true)
    @Override
    public void deleteObjByIds(String id) {
    	Assert.isNotBlank(id, "数据ID不能为空");
    	// 删除之前判断在供应商准入中有没有使用此流程，使用了就不能删除
    	ProcessExample processExample = new ProcessExample();
    	processExample.createCriteria().andProcessIdEqualTo(id)
    		.andIsEnableEqualTo(Constant.YES_INT);
    	if (this.processService.countByExample(processExample) > 0) {
    		throw new CommonException("所选流程已在供应商准入中使用，删除失败");
    	}
    	ProcessManagement t = new ProcessManagement();
    	t.setId(id);
    	t.setIsEnable(Constant.NO_INT);
    	this.processManagementMapper.updateByPrimaryKeySelective(t);
    }

    @CacheEvict(value={"processManagement"}, allEntries=true)
    @Override
    public void modifyObj(ProcessManagement t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        Assert.isNotBlank(t.getProcessName(), "流程名称不能为空");
		Assert.isNotBlank(t.getAccessProcess(), "准入流程不能为空");
		Assert.isNotBlank(t.getSupClassificationName(), "供应商分类名不能为空");
		// 判断流程是否在使用，如果在使用不能修改
		ProcessExample processExample = new ProcessExample();
		processExample.createCriteria()
			.andProcessIdEqualTo(t.getId())
			.andIsEnableEqualTo(Constant.YES_INT);
		if (this.processService.countByExample(processExample) > 0) {
			throw new CommonException("此流程已在供应商准入中使用，不能再修改");
		}
		// 根据选择的准入流程来判断资质、现场考察模版不能为空
		if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(t.getAccessProcess())) {
			// 只资质审核，资质审核模版不能为空
			Assert.isNotBlank(t.getQualificationAuditTemplateId(), "只资质审核时，资质模版ID不能为空");
		} else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(t.getAccessProcess())) {
			// 只现场考察，现场考察模版不能为空
			Assert.isNotBlank(t.getSiteInspectionTemplateId(), "只现场考察时，现场考察模版ID不能为空");
		} else if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(t.getAccessProcess())) {
			// 资质审核->现场考察，资质、现场考察模版都不能为空
			Assert.isNotBlank(t.getQualificationAuditTemplateId(), "资质模版ID不能为空");
			Assert.isNotBlank(t.getSiteInspectionTemplateId(), "现场考察模版ID不能为空");
		}
		t.setUpdateTime(new Date());
        this.processManagementMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="processManagement", keyGenerator="redisKeyGenerator")
    @Override
    public ProcessManagement queryObjById(String id) {
        return this.processManagementMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="processManagement", keyGenerator="redisKeyGenerator")
    @Override
    public List<ProcessManagement> queryAllObjByExample(ProcessManagementExample example) {
        return this.processManagementMapper.selectByExample(example);
    }

    @Cacheable(value="processManagement", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ProcessManagement> queryObjByPage(ProcessManagementExample example) {
        PageView<ProcessManagement> pageView = example.getPageView();
        pageView.setQueryResult(this.processManagementMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @CacheEvict(value={"processManagement"}, allEntries=true)
	@Override
	public void deleteObjById(String id) {
    	this.processManagementMapper.deleteByPrimaryKey(id);
	}
    
    @CacheEvict(value={"processManagement"}, allEntries=true)
	@Override
	public int countByExample(ProcessManagementExample example) {
		return this.processManagementMapper.countByExample(example);
	}

}