package com.els.base.certification.management.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.entity.ProcessManagementExample;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商准入-准入流程管理")
@Controller
@RequestMapping("processManagement")
public class ProcessManagementController {
    @Resource
    protected ProcessManagementService processManagementService;

    @ApiOperation(httpMethod="POST", value="创建供应商准入-准入流程管理")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ProcessManagement processManagement) {
        Assert.isNotNull(processManagement, "保存的数据不能为空");
    	this.processManagementService.insert(SpringSecurityUtils.getLoginUser(),CompanyUtils.currentCompany(),processManagement);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商准入-准入流程管理")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ProcessManagement processManagement) {
        Assert.isNotBlank(processManagement.getId(), "id 为空，保存失败");
        this.processManagementService.modifyObj(processManagement);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商准入-准入流程管理")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "ID为空,删除失败");
        this.processManagementService.deleteObjByIds(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-准入流程管理")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ProcessManagement", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ProcessManagement>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ProcessManagementExample example = new ProcessManagementExample();
        example.setPageView(new PageView<ProcessManagement>(pageNo, pageSize));
        example.setOrderByClause("UPDATE_TIME DESC");
        
        ProcessManagementExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<ProcessManagement> pageData = this.processManagementService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}