//package com.els.base.certification.newcode.service.impl;
//
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//import javax.annotation.Resource;
//
//import org.activiti.engine.runtime.ProcessInstance;
//import org.apache.commons.collections.CollectionUtils;
//import org.apache.commons.lang.StringUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.cache.annotation.CacheEvict;
//import org.springframework.cache.annotation.Cacheable;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//
//import com.els.base.certification.contacts.entity.Contacts;
//import com.els.base.certification.contacts.entity.ContactsExample;
//import com.els.base.certification.contacts.service.ContactsService;
//import com.els.base.certification.newcode.dao.CompanySupplierApplyMapper;
//import com.els.base.certification.newcode.entity.CompanySupplierApply;
//import com.els.base.certification.newcode.entity.CompanySupplierApplyExample;
//import com.els.base.certification.newcode.service.CompanySupplierApplyService;
//import com.els.base.certification.newcode.service.SupplierDataSendToSapService;
//import com.els.base.certification.newcode.service.SupplierSapRelationService;
//import com.els.base.certification.newcode.utils.CompanyNewCodeApplyEnum;
//import com.els.base.certification.newcode.utils.CompanyNewCodeApplyUtils;
//import com.els.base.codegenerator.service.GenerateCodeService;
//import com.els.base.company.entity.Company;
//import com.els.base.company.service.CompanyService;
//import com.els.base.core.entity.PageView;
//import com.els.base.core.exception.CommonException;
//import com.els.base.core.utils.Constant;
//import com.els.base.file.entity.FileData;
//import com.els.base.utils.uuid.UUIDGenerator;
//import com.els.base.workflow.common.entity.ProcessStartVO;
//import com.els.base.workflow.common.event.TaskOperateEvent;
//import com.els.base.workflow.common.service.ITaskListener;
//import com.els.base.workflow.common.service.WorkFlowService;
//
//
//@Service("defaultCompanySupplierApplyService")
//public class CompanySupplierApplyServiceImpl implements CompanySupplierApplyService,ITaskListener {
//    private static final Logger logger = LoggerFactory.getLogger(CompanySupplierApplyServiceImpl.class);
//	
//	private static final String SAP_SUCCESS_SIGN = "SUCCESS";
//	
//	@Resource
//    private CompanySupplierApplyMapper companySupplierApplyMapper;
//	
//	@Resource
//    private ContactsService contactsService;
//    
//    @Resource
//    private CompanyService companyService;
//    
//    @Resource
//    private SupplierSapRelationService supplierSapRelationService;
//    
//    @Resource
//    private WorkFlowService workFlowService;
//    
//    @Resource
//    private SupplierDataSendToSapService supplierDataSendToSapService;
//    
//    @Resource
//    private GenerateCodeService generateCodeService;
//    
//    private static final String SUPPLIER_APPLY_BILL_NO = "SUPPLIER_APPLY_BILL_NO";
//
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//    @Override
//    public void addObj(CompanySupplierApply t) {
//        this.companySupplierApplyMapper.insertSelective(t);
//    }
//
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//    @Override
//    public void deleteObjById(String id) {
//        this.companySupplierApplyMapper.deleteByPrimaryKey(id);
//    }
//
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//    @Override
//    public void modifyObj(CompanySupplierApply t) {
//        if (StringUtils.isBlank(t.getId())) {
//            throw new NullPointerException("id 为空，无法更新");
//        }
//        this.companySupplierApplyMapper.updateByPrimaryKeySelective(t);
//    }
//
//    @Cacheable(value="companySupplierApply", keyGenerator="redisKeyGenerator")
//    @Override
//    public CompanySupplierApply queryObjById(String id) {
//        return this.companySupplierApplyMapper.selectByPrimaryKey(id);
//    }
//
//    @Cacheable(value="companySupplierApply", keyGenerator="redisKeyGenerator")
//    @Override
//    public List<CompanySupplierApply> queryAllObjByExample(CompanySupplierApplyExample example) {
//        return this.companySupplierApplyMapper.selectByExample(example);
//    }
//
//    @Cacheable(value="companySupplierApply", keyGenerator="redisKeyGenerator")
//    @Override
//    public PageView<CompanySupplierApply> queryObjByPage(CompanySupplierApplyExample example) {
//        PageView<CompanySupplierApply> pageView = example.getPageView();
//        pageView.setQueryResult(this.companySupplierApplyMapper.selectByExampleByPage(example));
//        return pageView;
//    }
//    
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//	@Override
//	public void deleteByIds(List<String> ids) {
//    	if(CollectionUtils.isEmpty(ids)){
//			throw new CommonException("操作失败，数据不能为空!");
//		}
//    	List<Integer> statusList = new ArrayList<>();
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_FAIL.getStatus());
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
//    	
//		CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//		example.createCriteria()
//		   .andIdIn(ids)
//	       .andApproveStatusIn(statusList);
//		
//		if(this.companySupplierApplyMapper.countByExample(example) > 0){
//			throw new CommonException("您选择的数据中包括正在审批或审批成功或审批失败的单据,无法删除数据!");
//		}
//		
//		CompanySupplierApply item = new CompanySupplierApply();
//		item.setIsEnable(Constant.NO_INT);
//		item.setUpdateTime(new Date());
//		
//		example.clear();
//		example.createCriteria()
//		       .andIdIn(ids);
//		
//		this.companySupplierApplyMapper.updateByExampleSelective(item, example);
//    }
//    
//    //这里不用缓存,因为前面的接口改了company的SAP编码,如果用了缓存,拿出来的company数据就不会有SAP编码
//	@Override
//	public CompanySupplierApply generateBillInfo(Company company) {
//		if(null == company){
//			throw new CommonException("传递的参数为空!");
//		}
//		if(StringUtils.isEmpty(company.getId())){
//			throw new CommonException("传递的供应商id为空!");
//		}
//		
//		//查询该供应商是否存在单据
//		this.isExistBill(company.getId());
//		
//		Company com = companyService.queryObjById(company.getId());
//		if(null == com){
//			throw new CommonException("查询不到供应商数据!");
//		}
//		CompanySupplierApply data = new CompanySupplierApply();
//		
//		data.setId(UUIDGenerator.generateUUID());
//		//供应商信息
//		Company purCompany = companyService.queryPurchaseCompanies(company.getId());
//		data.setPurCompanyId(purCompany.getId());
//		data.setPurCompanySrmCode(purCompany.getCompanyCode());
//		data.setPurCompanyName(purCompany.getCompanyFullName());
//		data.setPurCompanyShortName(purCompany.getCompanyName());
//		//供应商信息
//		data.setSupCompanyId(com.getId());
//		data.setSupCompanySapCode(com.getCompanySapCode());
//		data.setSupCompanySrmCode(com.getCompanyCode());
//		data.setSupCompanyName(com.getCompanyFullName());
//		data.setSupCompanyShortName(com.getCompanyName());
//		data.setSupCompanyEnglishName(com.getEnglishCompanyName());
//		data.setSupCompanyEnglishShortName(com.getCompanyEnglishAbbreviation());
//		data.setSupCompanyAddress(com.getAddress());
//		data.setSupCompanyEnglishAddress(com.getEnglishAddress());
//		//单据号
//		String applyBillNo = generateCodeService.getNextCode(SUPPLIER_APPLY_BILL_NO);
//		data.setApplyBillNo(applyBillNo);
//		//企业类型
//		company.setCompanyType(com.getCompanyType());
//		//营业执照号
//		data.setBusinessLicenseNumber(com.getBusinessLicenseNumber());
//		//产品服务类型
//		data.setProductServiceType(com.getSecondCompanyType());
//		//公司代码 
//		data.setCountryCode("CN");
//		data.setGroupCode(com.getGroupCode());
//		data.setPurchaseOrganization(com.getPurchasingGroup());
//		data.setIndustryCode(com.getIndustryCode());
//		data.setFirstClassification(com.getFirstCompanyType());
////		//分类1
////		if(StringUtils.isEmpty(com.getFirstCompanyType())){
////			//如果为空的话,默认是定制件
////			data.setFirstClassification("3");
////			data.setFouthClassification("3");
////		}else{
////			//如果是1跟2,
////			if("1".equals(com.getFirstCompanyType()) || "2".equals(com.getFirstCompanyType())){
////				data.setFirstClassification("1");
////				data.setFouthClassification(com.getFirstCompanyType());
////			}else{
////				data.setFirstClassification("3");
////				data.setFouthClassification("3");
////			}
////		}
//		//分类3
//		data.setThirdClassification(com.getClassificationThree());
//		data.setSecondClassification(com.getBusinessType());
//		data.setSapIndustryCode(com.getIndustrialType());
//		//交易方式 
//		data.setTradeStyle(com.getExternalManufacturer());
//		
//		//基本信息
//		data.setMobilephone(com.getMobilephone());
//		data.setTelephone(com.getTelephone());
//		data.setFax(com.getFax());
//		data.setEmail(com.getEmail());
//		data.setWebsite(com.getWebsite());
//		//工业类型
//		data.setSapIndustryCode(com.getIndustrialType());
//		//税率
//		
//		//币别
//		data.setOrderCurren("CNY");
//		//结算方式
//		data.setBalanceStyle(com.getPayConditionsCode());
//		
//		//采购周期
//		
//		//检索项
//		data.setSearchItem(com.getCompanyName());
//		
//		//其他信息
//		
//		//供应商账户组（一般是FGE1）
//		data.setSupplierAccountGroup("FGE1");
//		
//		data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_UN_APPROVE.getStatus());
//		data.setIsEnable(Constant.YES_INT);
//		data.setCreateBillTime(new Date());
//		data.setCreateTime(new Date());
//		
//		//查询联系人信息
//		List<Contacts> list = this.findContactsByCompanyId(com.getId());
//		if(CollectionUtils.isNotEmpty(list)){
//			data.setContacts(list.get(0).getName());
//		}
//		
//    	return data;
//	}
//	
//	private List<Contacts> findContactsByCompanyId(String companyId){
//		if(StringUtils.isEmpty(companyId)){
//			return null;
//		}
//		ContactsExample example = new ContactsExample();
//		example.createCriteria()
//			   .andSupCompanyIdEqualTo(companyId);
//		List<Contacts> list = this.contactsService.queryAllObjByExample(example);
//		return list;
//	}
//    
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//	@Override
//	public void addRemark(CompanySupplierApply data) {
//		if(StringUtils.isEmpty(data.getId())){
//			throw new CommonException("传递的参数id为空!");
//		}
//		if(StringUtils.isEmpty(data.getRemark())){
//			throw new CommonException("备注不能为空,没有请填'无'!");
//		}
//		this.companySupplierApplyMapper.updateByPrimaryKeySelective(data);
//	}
//    
//    @Transactional
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//    @Override
//	public void modifyData(CompanySupplierApply data) {
//    	//数据非空检查
//    	logger.debug("【新供应商编码申请】效验数据!");
//    	this.checkSupplierData(data);
//    	//反写sap
//    	logger.debug("【新供应商编码申请】反写SAP!");
//    	String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
//    	//保存数据库
//    	if(SAP_SUCCESS_SIGN.equalsIgnoreCase(result)){
//    		logger.debug("【新供应商编码申请】更新单据!");
//    		this.modifyObj(data);
//    	}else{
//    		throw new CommonException("反写SAP接口异常："+result);
//    	}
//    	//更新供应商主数据
//    	logger.debug("【新供应商编码申请】更新供应商主数据!");
//    	this.updateSupplierData(data);
//    	
//    	//维护到编码管理系统中
//    	this.supplierSapRelationService.saveSupplierSapRelation(data);
//	}
//    
//    @Transactional
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//	@Override
//	public void create(CompanySupplierApply data) {
//    	//判断是否存在该供应商的单据
//    	logger.debug("【新供应商编码申请】判断是否有存在数据!");
//    	this.isExistBill(data.getSupCompanyId());
//    	//数据非空检查
//    	logger.debug("【新供应商编码申请】效验数据!");
//    	this.checkSupplierData(data);
//    	//反写sap
//    	logger.debug("【新供应商编码申请】反写SAP!");
//    	String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
//    	//保存数据库
//    	if(SAP_SUCCESS_SIGN.equalsIgnoreCase(result)){
//    		logger.debug("【新供应商编码申请】保存单据!");
//    		this.addObj(data);
//    	}else{
//    		throw new CommonException("反写SAP接口异常："+result);
//    	}
//    	//更新供应商主数据
//    	logger.debug("【新供应商编码申请】更新供应商主数据!");
//    	this.updateSupplierData(data);
//    	//维护到编码管理系统中
//    	this.supplierSapRelationService.saveSupplierSapRelation(data);
//    	
//	}
//    
//    private void isExistBill(String supCompanyId){
//    	List<Integer> statusList = new ArrayList<>();
//    	statusList.add(CompanyNewCodeApplyEnum.STATUS_UN_APPROVE.getStatus());
//    	statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
//    	statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
//    	
//    	CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//    	example.createCriteria()
//    		   .andSupCompanyIdEqualTo(supCompanyId)
//    		   .andIsEnableEqualTo(Constant.YES_INT)
//    		   .andApproveStatusIn(statusList);
//    	
//    	if(this.companySupplierApplyMapper.countByExample(example) > 0){
//    		throw new CommonException("系统中存在单据正在为当前供应商申请编码,请勿重复申请!");
//    	}
//    }
//    
//    private void updateSupplierData(CompanySupplierApply data){
//    	Company company = new Company();
//    	company.setId(data.getSupCompanyId());
//    	//企业类型
//    	company.setCompanyType(data.getCompanyType());
//    	//营业执照号
//    	company.setBusinessLicenseNumber(data.getBusinessLicenseNumber());
//    	//行业代码,行业描述
//    	company.setIndustryCode(data.getIndustryCode());
//    	company.setIndustryDesc(data.getIndustryDesc());
//    	//网址
//    	company.setWebsite(data.getWebsite());
//    	//币别
//    	company.setOrderCurren(data.getOrderCurren());
//    	//交易方式（外部制造商）
//    	company.setExternalManufacturer(data.getTradeStyle());
//    	//结算方式
//    	company.setPayConditionsCode(data.getBalanceStyle());
//    	//国家代码
//    	company.setCountry(data.getCountryCode());
//    	//采购组织
//    	company.setPurchasingGroup(data.getPurchaseOrganization());
//    	//组代码
//    	company.setGroupCode(data.getGroupCode());
//    	//分类2(业务类型)
//    	company.setBusinessType(data.getSecondClassification());
//    	//分类4(定制件代理商,定制件的制造商,标准件代理商,标准件制造商)
//    	company.setFirstCompanyType(data.getFirstClassification());
//    	//工业类型
//    	company.setIndustrialType(data.getSapIndustryCode());
//    	//分类3
//    	company.setClassificationThree(data.getThirdClassification());
//    	
//    	//产品服务类型n
//    	company.setSecondCompanyType(data.getProductServiceType());
//    	//代表名称 
//    	company.setDelegateType(data.getRepresentName());
//    	//地区
//    	company.setCity(data.getAreaName());
//    	
//    	this.companyService.modifyObj(company);
//    }
//    
//    private void checkSupplierData(CompanySupplierApply data){
//    	if(StringUtils.isEmpty(data.getSupCompanySapCode())){
//    		throw new CommonException("供应商SAP编码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getCompanyCode())){
//    		throw new CommonException("公司代码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getPurchaseOrganization())){
//    		throw new CommonException("采购组织为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSupplierAccountGroup())){
//    		throw new CommonException("供应商账户组为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSupCompanyName())){
//    		throw new CommonException("供应商中文名称为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSearchItem())){
//    		throw new CommonException("检索项为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSupCompanyAddress())){
//    		throw new CommonException("供应商地址为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getCountryCode())){
//    		throw new CommonException("国家代码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getArea())){
//    		throw new CommonException("地区为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getTelephone())){
//    		throw new CommonException("电话为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getFax())){
//    		throw new CommonException("传真为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getEmail())){
//    		throw new CommonException("邮件为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getGroupCode())){
//    		throw new CommonException("组代码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getRepresentName())){
//    		throw new CommonException("代表名称为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSecondClassification())){
//    		throw new CommonException("分类2为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getSapIndustryCode())){
//    		throw new CommonException("工业类型代码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getIndustryCode())){
//    		throw new CommonException("行业代码为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getTradeStyle())){
//    		throw new CommonException("交易方式为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getBalanceStyle())){
//    		throw new CommonException("结算方式为空,无法保存数据!");
//    	}
//    	if(StringUtils.isEmpty(data.getOrderCurren())){
//    		throw new CommonException("货币为空,无法保存数据!");
//    	}
//    }
//    
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//	@Override
//	public void sendToApprove(List<String> ids) {
//    	if(CollectionUtils.isEmpty(ids)){
//			throw new CommonException("操作失败，数据不能为空!");
//		}
//    	
//    	List<Integer> statusList = new ArrayList<>();
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_FAIL.getStatus());
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
//		statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
//	
//		CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//		example.createCriteria()
//		   .andIdIn(ids)
//	       .andApproveStatusIn(statusList);
//		
//		if(this.companySupplierApplyMapper.countByExample(example) > 0){
//			throw new CommonException("您选择的数据中包括正在审批或审批成功或审批失败的单据,无法发送审批单据!");
//		}
//		
//		example.clear();
//		example.createCriteria()
//			   .andIdIn(ids);
//		
//		CompanySupplierApply data = new CompanySupplierApply();
//		data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
//		data.setUpdateTime(new Date());
//		data.setApproveTime(new Date());
//		
//		this.companySupplierApplyMapper.updateByExampleSelective(data, example);
//    
//		//加入审批流
//		example.clear();
//		example.createCriteria()
//			   .andIdIn(ids);
//		List<CompanySupplierApply> list = this.queryAllObjByExample(example);
//		this.addToWorkFlow(list);
//    }
//    
//    //加入到审批流程里
//    private void addToWorkFlow(List<CompanySupplierApply> list){
//    	if(CollectionUtils.isNotEmpty(list)){
//    		for (CompanySupplierApply it : list) {
//    			ProcessStartVO vo = ProcessStartVO.newInstance("xgysbmdrb", it.getApplyBillNo(), it.getId(),"newSupplierInport?id="+it.getId());
//				vo.setListenerClass(this.getClass());
//				ProcessInstance startProcess = this.workFlowService.startProcess(vo);
//				if(null != startProcess){
//					//成功加入审批流
//					CompanySupplierApply a = new CompanySupplierApply();
//					a.setUpdateTime(new Date());
//					a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
//					a.setApproveTime(new Date());
//					
//					CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//					example.createCriteria()
//						   .andIdEqualTo(it.getId());
//					
//					this.companySupplierApplyMapper.updateByExampleSelective(a, example);
//				}
//			}
//    	}
//    }
//    
//    /**
//     * 审批完成后的回调函数:记得清缓存
//     */
//    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
//    @Override
//	public void listen(TaskOperateEvent event) {
//    	if(null == event){
//    		logger.debug("审批流返回监听事件为空!");
//    		return ;
//    	}
//    	if(StringUtils.isEmpty(event.getBusinessId())){
//    		logger.debug("审批流返回的业务id为空!");
//    		return ;
//    	}
//    	
//    	CompanySupplierApply data = this.queryObjById(event.getBusinessId());
//    	if(null == data){
//    		logger.debug("审批流返回的业务id查询的单据为空!");
//    		return ;
//    	}
//    	
//    	
//    	CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//    	example.createCriteria()
//			   .andIdEqualTo(event.getBusinessId());
//    	
//    	
//    	CompanySupplierApply a = new CompanySupplierApply();
//    	a.setUpdateTime(new Date());
//    	a.setApproveUserName(event.getAssignee());
//    	
//    	if(StringUtils.isNotEmpty(data.getApproveSuggestion())){
//    		//如果审批意见是空的
//    		a.setApproveSuggestion(data.getApproveSuggestion() + "\n");
//    	}else{
//    		a.setApproveSuggestion("");
//    	}
//    
//    	//设置审批意见
//		if(StringUtils.isEmpty(event.getApproveDesc())){
//			a.setApproveSuggestion(a.getApproveSuggestion()+event.getAssignee()+":"+"无");
//		}else{
//			a.setApproveSuggestion(a.getApproveSuggestion()+event.getAssignee()+":"+event.getApproveDesc());
//		}
//		
//    	if(event.isFinished() && event.isPass()){
//    		//审批流完成而且审批通过
//    		a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
//    	}else if(event.isFinished() && !event.isPass()){
//    		//审批流完成但审批被驳回
//    		a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVE_FAIL.getStatus());
//    	}
//    	this.companySupplierApplyMapper.updateByExampleSelective(a, example);
//    }
//
//	@Override
//	public FileData print(String projectId, String companyId,List<CompanySupplierApply> data) {
//		if(null == data){
//			throw new CommonException("传递的数据为空!");
//		}
//		//批量打印的单据id
//		List<String> ids = null;
//		for (CompanySupplierApply item : data) {
//			if(StringUtils.isEmpty(item.getId())){
//				throw new CommonException("传递的参数列表中存在id为空!");
//			}
//			if(null == ids)
//				ids = new ArrayList<>();
//			//放到数组中
//			ids.add(item.getId());
//		}
//		//查询数据 
//		CompanySupplierApplyExample example = new CompanySupplierApplyExample();
//		example.createCriteria()
//			   .andIdIn(ids);
//		
//		List<CompanySupplierApply> billList = this.queryAllObjByExample(example);
//		if(CollectionUtils.isEmpty(billList)){
//			throw new CommonException("查询的数据为空,无法打印单据!");
//		}
//		
//		//创造打印数据
//		Map<String, Object> params = new HashMap<String, Object>();
//		params.put("billList", billList);
//		
//		//创建文件信息
//		FileData fileData = null;
//		
//		try {
//			fileData = CompanyNewCodeApplyUtils.generatePdf(projectId,companyId,params, "A4");
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		
//		return fileData;
//	}
//
//    
////  @CacheEvict(value={"companySupplierApply"}, allEntries=true)
////	@Override
////	public void approveSuccess(List<String> ids) {
////		if(CollectionUtils.isEmpty(ids)){
////			return ;
////		}
////		CompanySupplierApplyExample example = new CompanySupplierApplyExample();
////		example.createCriteria()
////			.andIdIn(ids);
////		
////		CompanySupplierApply a = new CompanySupplierApply();
////		a.setUpdateTime(new Date());
////		a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
////	
////		this.companySupplierApplyMapper.updateByExampleSelective(a, example);
////    }
//
//}