package com.els.base.certification.notice.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商准入-审核通知单")
public class CompanyAuditNotice implements Serializable {
    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商地址")
    private String supCompanyAddress;

    @ApiModelProperty("供应商联系人")
    private String supCompanyContacts;

    @ApiModelProperty("供应商物料编码")
    private String supMaterialCode;

    @ApiModelProperty("供应商物料描述")
    private String supMaterialDesc;

    @ApiModelProperty("现场考察通知单单号")
    private String auditNoticeNo;

    @ApiModelProperty("现场考察时间")
    private Date auditTime;

    @ApiModelProperty("审核状态(0=未审核，1=待审核，2已审核)")
    private Integer auditStatus;

    @ApiModelProperty("制单人")
    private String createBillName;

    @ApiModelProperty("供应商类型")
    private String companyType;

    @ApiModelProperty("用于存储审核部门信息")
    private String auditInfo;

    @ApiModelProperty("用于存储审核部门下的文件信息")
    private String auditInfoFile;

    @ApiModelProperty("单据类型")
    private String billType;

    @ApiModelProperty("单据状态：未确认=0，已确认=1")
    private Integer confirmStatus;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("发送状态（0=未发送，1=已发送）")
    private Integer sendStatus;
    
    @ApiModelProperty("考察项目说明")
    private String inspectionProjectExplain;

    @ApiModelProperty("采购商用户ID")
    private String purUserId;

    @ApiModelProperty("供应商用户ID")
    private String supUserId;
    
    @ApiModelProperty("供应商回复信息")
    private String supReplyInformation;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyAddress() {
        return supCompanyAddress;
    }

    public void setSupCompanyAddress(String supCompanyAddress) {
        this.supCompanyAddress = supCompanyAddress == null ? null : supCompanyAddress.trim();
    }

    public String getSupCompanyContacts() {
        return supCompanyContacts;
    }

    public void setSupCompanyContacts(String supCompanyContacts) {
        this.supCompanyContacts = supCompanyContacts == null ? null : supCompanyContacts.trim();
    }

    public String getSupMaterialCode() {
        return supMaterialCode;
    }

    public void setSupMaterialCode(String supMaterialCode) {
        this.supMaterialCode = supMaterialCode == null ? null : supMaterialCode.trim();
    }

    public String getSupMaterialDesc() {
        return supMaterialDesc;
    }

    public void setSupMaterialDesc(String supMaterialDesc) {
        this.supMaterialDesc = supMaterialDesc == null ? null : supMaterialDesc.trim();
    }

    public String getAuditNoticeNo() {
        return auditNoticeNo;
    }

    public void setAuditNoticeNo(String auditNoticeNo) {
        this.auditNoticeNo = auditNoticeNo == null ? null : auditNoticeNo.trim();
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getCreateBillName() {
        return createBillName;
    }

    public void setCreateBillName(String createBillName) {
        this.createBillName = createBillName == null ? null : createBillName.trim();
    }

    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType == null ? null : companyType.trim();
    }

    public String getAuditInfo() {
        return auditInfo;
    }

    public void setAuditInfo(String auditInfo) {
        this.auditInfo = auditInfo == null ? null : auditInfo.trim();
    }

    public String getAuditInfoFile() {
        return auditInfoFile;
    }

    public void setAuditInfoFile(String auditInfoFile) {
        this.auditInfoFile = auditInfoFile == null ? null : auditInfoFile.trim();
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType == null ? null : billType.trim();
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }
    
    public String getInspectionProjectExplain() {
        return inspectionProjectExplain;
    }

    public void setInspectionProjectExplain(String inspectionProjectExplain) {
        this.inspectionProjectExplain = inspectionProjectExplain == null ? null : inspectionProjectExplain.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }
    
    public String getSupReplyInformation() {
        return supReplyInformation;
    }

    public void setSupReplyInformation(String supReplyInformation) {
        this.supReplyInformation = supReplyInformation == null ? null : supReplyInformation.trim();
    }
}