package com.els.base.certification.outsourced.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="供应商基础资料-外包二级供应商信息")
public class Outsourced implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String companyId;

    @ApiModelProperty("供应商SRM编码")
    private String companySrmCode;

    @ApiModelProperty("外包工序")
    private String outsourcingProcess;

    @ApiModelProperty("外包供应商")
    private String outsourcingSuppliers;

    @ApiModelProperty("外包供应商地址")
    private String outsourcingSuppliersAddress;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("外包商营业执照")
    private String businessLicense;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("外包商质量体系")
    private String qualitySystem;

    @ApiModelProperty("是否可用（1可用，0不可用）")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanySrmCode() {
        return companySrmCode;
    }

    public void setCompanySrmCode(String companySrmCode) {
        this.companySrmCode = companySrmCode == null ? null : companySrmCode.trim();
    }

    public String getOutsourcingProcess() {
        return outsourcingProcess;
    }

    public void setOutsourcingProcess(String outsourcingProcess) {
        this.outsourcingProcess = outsourcingProcess == null ? null : outsourcingProcess.trim();
    }

    public String getOutsourcingSuppliers() {
        return outsourcingSuppliers;
    }

    public void setOutsourcingSuppliers(String outsourcingSuppliers) {
        this.outsourcingSuppliers = outsourcingSuppliers == null ? null : outsourcingSuppliers.trim();
    }

    public String getOutsourcingSuppliersAddress() {
        return outsourcingSuppliersAddress;
    }

    public void setOutsourcingSuppliersAddress(String outsourcingSuppliersAddress) {
        this.outsourcingSuppliersAddress = outsourcingSuppliersAddress == null ? null : outsourcingSuppliersAddress.trim();
    }

    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense == null ? null : businessLicense.trim();
    }

    public String getQualitySystem() {
        return qualitySystem;
    }

    public void setQualitySystem(String qualitySystem) {
        this.qualitySystem = qualitySystem == null ? null : qualitySystem.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}