package com.els.base.certification.patents.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="专利，专有技术，许可")
public class CompanyPatents  extends AbstractCompany implements Serializable {

    //非自动生成

    //忽略校验的字段
    @Override
    protected List<String> exculdeFieldNames() {
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("remark");
        filedNameList.add("startTime");
        filedNameList.add("patentCode");
        filedNameList.add("projectId");
        filedNameList.add("supCompanyId");
        filedNameList.add("updateTime");
        filedNameList.add("createTime");
        filedNameList.add("isEnable");
        filedNameList.add("finishFlag");
        return filedNameList;
    }
    //非自动生成

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("专利代码")
    private String patentCode;

    @ApiModelProperty("专利名称")
    private String patentName;

    @ApiModelProperty("专利授予机构")
    private String patentOrganization;

    @ApiModelProperty("专利使用的地方")
    private String patentDesc;

    @ApiModelProperty("专利开始时间")
    private Date startTime;

    @ApiModelProperty("专利有效截止时间")
    private Date endTime;

    @ApiModelProperty("专利价值")
    private String patentValue;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("专利文件")
    private String patentFile;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getPatentCode() {
        return patentCode;
    }

    public void setPatentCode(String patentCode) {
        this.patentCode = patentCode == null ? null : patentCode.trim();
    }

    public String getPatentName() {
        return patentName;
    }

    public void setPatentName(String patentName) {
        this.patentName = patentName == null ? null : patentName.trim();
    }

    public String getPatentOrganization() {
        return patentOrganization;
    }

    public void setPatentOrganization(String patentOrganization) {
        this.patentOrganization = patentOrganization == null ? null : patentOrganization.trim();
    }

    public String getPatentDesc() {
        return patentDesc;
    }

    public void setPatentDesc(String patentDesc) {
        this.patentDesc = patentDesc == null ? null : patentDesc.trim();
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPatentValue() {
        return patentValue;
    }

    public void setPatentValue(String patentValue) {
        this.patentValue = patentValue == null ? null : patentValue.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getPatentFile() {
        return patentFile;
    }

    public void setPatentFile(String patentFile) {
        this.patentFile = patentFile == null ? null : patentFile.trim();
    }

   /* public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}