package com.els.base.certification.patents.service;

import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyPatentsService extends BaseService<CompanyPatents, CompanyPatentsExample, String> {

    /**
     * 批量软删除
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 批量插入数据
     * @param projectId
     * @param company
     * @param companyPatentsList
     */
    Integer batchInsert(String projectId, Company company, List<CompanyPatents> companyPatentsList);

    /**
     * 检查是否已经填完资料
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}