package com.els.base.certification.process.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ProcessExample extends AbstractExample<Process> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<Process> pageView = new PageView<Process>(1, 10);

    private static final long serialVersionUID = 1L;

    public ProcessExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<Process> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<Process> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeIsNull() {
            addCriterion("COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeIsNotNull() {
            addCriterion("COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeEqualTo(String value) {
            addCriterion("COMPANY_SRM_CODE =", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeNotEqualTo(String value) {
            addCriterion("COMPANY_SRM_CODE <>", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeGreaterThan(String value) {
            addCriterion("COMPANY_SRM_CODE >", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_SRM_CODE >=", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeLessThan(String value) {
            addCriterion("COMPANY_SRM_CODE <", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_SRM_CODE <=", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeLike(String value) {
            addCriterion("COMPANY_SRM_CODE like", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeNotLike(String value) {
            addCriterion("COMPANY_SRM_CODE not like", value, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeIn(List<String> values) {
            addCriterion("COMPANY_SRM_CODE in", values, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeNotIn(List<String> values) {
            addCriterion("COMPANY_SRM_CODE not in", values, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_SRM_CODE between", value1, value2, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_SRM_CODE not between", value1, value2, "companySrmCode");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIsNull() {
            addCriterion("COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIsNotNull() {
            addCriterion("COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyIdEqualTo(String value) {
            addCriterion("COMPANY_ID =", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotEqualTo(String value) {
            addCriterion("COMPANY_ID <>", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdGreaterThan(String value) {
            addCriterion("COMPANY_ID >", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_ID >=", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLessThan(String value) {
            addCriterion("COMPANY_ID <", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_ID <=", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdLike(String value) {
            addCriterion("COMPANY_ID like", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotLike(String value) {
            addCriterion("COMPANY_ID not like", value, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdIn(List<String> values) {
            addCriterion("COMPANY_ID in", values, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotIn(List<String> values) {
            addCriterion("COMPANY_ID not in", values, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdBetween(String value1, String value2) {
            addCriterion("COMPANY_ID between", value1, value2, "companyId");
            return (Criteria) this;
        }

        public Criteria andCompanyIdNotBetween(String value1, String value2) {
            addCriterion("COMPANY_ID not between", value1, value2, "companyId");
            return (Criteria) this;
        }

        public Criteria andProcessNameIsNull() {
            addCriterion("PROCESS_NAME is null");
            return (Criteria) this;
        }

        public Criteria andProcessNameIsNotNull() {
            addCriterion("PROCESS_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andProcessNameEqualTo(String value) {
            addCriterion("PROCESS_NAME =", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameNotEqualTo(String value) {
            addCriterion("PROCESS_NAME <>", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameGreaterThan(String value) {
            addCriterion("PROCESS_NAME >", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameGreaterThanOrEqualTo(String value) {
            addCriterion("PROCESS_NAME >=", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameLessThan(String value) {
            addCriterion("PROCESS_NAME <", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameLessThanOrEqualTo(String value) {
            addCriterion("PROCESS_NAME <=", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameLike(String value) {
            addCriterion("PROCESS_NAME like", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameNotLike(String value) {
            addCriterion("PROCESS_NAME not like", value, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameIn(List<String> values) {
            addCriterion("PROCESS_NAME in", values, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameNotIn(List<String> values) {
            addCriterion("PROCESS_NAME not in", values, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameBetween(String value1, String value2) {
            addCriterion("PROCESS_NAME between", value1, value2, "processName");
            return (Criteria) this;
        }

        public Criteria andProcessNameNotBetween(String value1, String value2) {
            addCriterion("PROCESS_NAME not between", value1, value2, "processName");
            return (Criteria) this;
        }

        public Criteria andAccessProcessIsNull() {
            addCriterion("ACCESS_PROCESS is null");
            return (Criteria) this;
        }

        public Criteria andAccessProcessIsNotNull() {
            addCriterion("ACCESS_PROCESS is not null");
            return (Criteria) this;
        }

        public Criteria andAccessProcessEqualTo(String value) {
            addCriterion("ACCESS_PROCESS =", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessNotEqualTo(String value) {
            addCriterion("ACCESS_PROCESS <>", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessGreaterThan(String value) {
            addCriterion("ACCESS_PROCESS >", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessGreaterThanOrEqualTo(String value) {
            addCriterion("ACCESS_PROCESS >=", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessLessThan(String value) {
            addCriterion("ACCESS_PROCESS <", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessLessThanOrEqualTo(String value) {
            addCriterion("ACCESS_PROCESS <=", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessLike(String value) {
            addCriterion("ACCESS_PROCESS like", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessNotLike(String value) {
            addCriterion("ACCESS_PROCESS not like", value, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessIn(List<String> values) {
            addCriterion("ACCESS_PROCESS in", values, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessNotIn(List<String> values) {
            addCriterion("ACCESS_PROCESS not in", values, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessBetween(String value1, String value2) {
            addCriterion("ACCESS_PROCESS between", value1, value2, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andAccessProcessNotBetween(String value1, String value2) {
            addCriterion("ACCESS_PROCESS not between", value1, value2, "accessProcess");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditIsNull() {
            addCriterion("QUALIFICATION_AUDIT is null");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditIsNotNull() {
            addCriterion("QUALIFICATION_AUDIT is not null");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT =", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditNotEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT <>", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditGreaterThan(String value) {
            addCriterion("QUALIFICATION_AUDIT >", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditGreaterThanOrEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT >=", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditLessThan(String value) {
            addCriterion("QUALIFICATION_AUDIT <", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditLessThanOrEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT <=", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditLike(String value) {
            addCriterion("QUALIFICATION_AUDIT like", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditNotLike(String value) {
            addCriterion("QUALIFICATION_AUDIT not like", value, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditIn(List<String> values) {
            addCriterion("QUALIFICATION_AUDIT in", values, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditNotIn(List<String> values) {
            addCriterion("QUALIFICATION_AUDIT not in", values, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditBetween(String value1, String value2) {
            addCriterion("QUALIFICATION_AUDIT between", value1, value2, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditNotBetween(String value1, String value2) {
            addCriterion("QUALIFICATION_AUDIT not between", value1, value2, "qualificationAudit");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateIsNull() {
            addCriterion("SCENE_INVESTIGATE is null");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateIsNotNull() {
            addCriterion("SCENE_INVESTIGATE is not null");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateEqualTo(String value) {
            addCriterion("SCENE_INVESTIGATE =", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateNotEqualTo(String value) {
            addCriterion("SCENE_INVESTIGATE <>", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateGreaterThan(String value) {
            addCriterion("SCENE_INVESTIGATE >", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateGreaterThanOrEqualTo(String value) {
            addCriterion("SCENE_INVESTIGATE >=", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateLessThan(String value) {
            addCriterion("SCENE_INVESTIGATE <", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateLessThanOrEqualTo(String value) {
            addCriterion("SCENE_INVESTIGATE <=", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateLike(String value) {
            addCriterion("SCENE_INVESTIGATE like", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateNotLike(String value) {
            addCriterion("SCENE_INVESTIGATE not like", value, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateIn(List<String> values) {
            addCriterion("SCENE_INVESTIGATE in", values, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateNotIn(List<String> values) {
            addCriterion("SCENE_INVESTIGATE not in", values, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateBetween(String value1, String value2) {
            addCriterion("SCENE_INVESTIGATE between", value1, value2, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andSceneInvestigateNotBetween(String value1, String value2) {
            addCriterion("SCENE_INVESTIGATE not between", value1, value2, "sceneInvestigate");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterionForJDBCDate("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterionForJDBCDate("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterionForJDBCDate("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterionForJDBCDate("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterionForJDBCDate("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterionForJDBCDate("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterionForJDBCDate("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterionForJDBCDate("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdIsNull() {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID is null");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdIsNotNull() {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID is not null");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID =", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdNotEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID <>", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdGreaterThan(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID >", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdGreaterThanOrEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID >=", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdLessThan(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID <", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdLessThanOrEqualTo(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID <=", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdLike(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID like", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdNotLike(String value) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID not like", value, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdIn(List<String> values) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID in", values, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdNotIn(List<String> values) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID not in", values, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdBetween(String value1, String value2) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID between", value1, value2, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andQualificationAuditTemplateIdNotBetween(String value1, String value2) {
            addCriterion("QUALIFICATION_AUDIT_TEMPLATE_ID not between", value1, value2, "qualificationAuditTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdIsNull() {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID is null");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdIsNotNull() {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdEqualTo(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID =", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdNotEqualTo(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID <>", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdGreaterThan(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID >", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdGreaterThanOrEqualTo(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID >=", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdLessThan(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID <", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdLessThanOrEqualTo(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID <=", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdLike(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID like", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdNotLike(String value) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID not like", value, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdIn(List<String> values) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID in", values, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdNotIn(List<String> values) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID not in", values, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdBetween(String value1, String value2) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID between", value1, value2, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andSiteInspectionTemplateIdNotBetween(String value1, String value2) {
            addCriterion("SITE_INSPECTION_TEMPLATE_ID not between", value1, value2, "siteInspectionTemplateId");
            return (Criteria) this;
        }

        public Criteria andIsSendIsNull() {
            addCriterion("IS_SEND is null");
            return (Criteria) this;
        }

        public Criteria andIsSendIsNotNull() {
            addCriterion("IS_SEND is not null");
            return (Criteria) this;
        }

        public Criteria andIsSendEqualTo(Integer value) {
            addCriterion("IS_SEND =", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendNotEqualTo(Integer value) {
            addCriterion("IS_SEND <>", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendGreaterThan(Integer value) {
            addCriterion("IS_SEND >", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_SEND >=", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendLessThan(Integer value) {
            addCriterion("IS_SEND <", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendLessThanOrEqualTo(Integer value) {
            addCriterion("IS_SEND <=", value, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendIn(List<Integer> values) {
            addCriterion("IS_SEND in", values, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendNotIn(List<Integer> values) {
            addCriterion("IS_SEND not in", values, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendBetween(Integer value1, Integer value2) {
            addCriterion("IS_SEND between", value1, value2, "isSend");
            return (Criteria) this;
        }

        public Criteria andIsSendNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_SEND not between", value1, value2, "isSend");
            return (Criteria) this;
        }
        
        public Criteria andSupplierLevelCodeIsNull() {
            addCriterion("SUPPLIER_LEVEL_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeIsNotNull() {
            addCriterion("SUPPLIER_LEVEL_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeEqualTo(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE =", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeNotEqualTo(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE <>", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeGreaterThan(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE >", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE >=", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeLessThan(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE <", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeLessThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE <=", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeLike(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE like", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeNotLike(String value) {
            addCriterion("SUPPLIER_LEVEL_CODE not like", value, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeIn(List<String> values) {
            addCriterion("SUPPLIER_LEVEL_CODE in", values, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeNotIn(List<String> values) {
            addCriterion("SUPPLIER_LEVEL_CODE not in", values, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeBetween(String value1, String value2) {
            addCriterion("SUPPLIER_LEVEL_CODE between", value1, value2, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupplierLevelCodeNotBetween(String value1, String value2) {
            addCriterion("SUPPLIER_LEVEL_CODE not between", value1, value2, "supplierLevelCode");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameIsNull() {
            addCriterion("SUP_CLASSIFICATION_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameIsNotNull() {
            addCriterion("SUP_CLASSIFICATION_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameEqualTo(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME =", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameNotEqualTo(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME <>", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameGreaterThan(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME >", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME >=", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameLessThan(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME <", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME <=", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameLike(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME like", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameNotLike(String value) {
            addCriterion("SUP_CLASSIFICATION_NAME not like", value, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameIn(List<String> values) {
            addCriterion("SUP_CLASSIFICATION_NAME in", values, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameNotIn(List<String> values) {
            addCriterion("SUP_CLASSIFICATION_NAME not in", values, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameBetween(String value1, String value2) {
            addCriterion("SUP_CLASSIFICATION_NAME between", value1, value2, "supClassificationName");
            return (Criteria) this;
        }

        public Criteria andSupClassificationNameNotBetween(String value1, String value2) {
            addCriterion("SUP_CLASSIFICATION_NAME not between", value1, value2, "supClassificationName");
            return (Criteria) this;
        }
        
        public Criteria andProcessIdIsNull() {
            addCriterion("PROCESS_ID is null");
            return (Criteria) this;
        }

        public Criteria andProcessIdIsNotNull() {
            addCriterion("PROCESS_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProcessIdEqualTo(String value) {
            addCriterion("PROCESS_ID =", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdNotEqualTo(String value) {
            addCriterion("PROCESS_ID <>", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdGreaterThan(String value) {
            addCriterion("PROCESS_ID >", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROCESS_ID >=", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdLessThan(String value) {
            addCriterion("PROCESS_ID <", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdLessThanOrEqualTo(String value) {
            addCriterion("PROCESS_ID <=", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdLike(String value) {
            addCriterion("PROCESS_ID like", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdNotLike(String value) {
            addCriterion("PROCESS_ID not like", value, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdIn(List<String> values) {
            addCriterion("PROCESS_ID in", values, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdNotIn(List<String> values) {
            addCriterion("PROCESS_ID not in", values, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdBetween(String value1, String value2) {
            addCriterion("PROCESS_ID between", value1, value2, "processId");
            return (Criteria) this;
        }

        public Criteria andProcessIdNotBetween(String value1, String value2) {
            addCriterion("PROCESS_ID not between", value1, value2, "processId");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}