package com.els.base.certification.process.service;

import java.util.List;
import java.util.Map;

import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.utils.excel.TitleAndModelKey;

public interface ProcessService extends BaseService<Process, ProcessExample, String> {
	public Process queryObjByCompanyId (String companyId);
	
	/**
	 * 查询供应商与流程信息接口
	 * @param purCompanyId
	 * @param roleEnum
	 * @param queryMap
	 * @return
	 */
	public PageView<Company> queryAllCompnayByPage(String purCompanyId, String roleEnum, Map<String, Object> queryMap);
	
	/**
	 * 资质审核单、现场考察通知单删除单据时，把准入流程中的资质审核、现场考察状态还原为null
	 * @param process
	 */
	public void updateById(Process process);
	
	/**
	 * 
	 * @param example
	 * @return
	 */
	public int countByExample(ProcessExample example);
	
	/**
	 * 合格供应商清单Excel导出创建头部信息
	 * @return
	 */
	public List<TitleAndModelKey> createExcelHeaderForPur();
}