package com.els.base.certification.process.util;

import org.apache.commons.lang.StringUtils;

public enum AccessProcessEnum {
	/**不需审核**/
	NOT_REVIEW("1","不需审核"),
	/**只资质审核**/
	QUALIFICATION_REVIEW("2","只资质审核"),
	/**只现场考核**/
	SCENE_ASSESSMENT("3","只现场考核"),
	/**资质审核->现场考核**/
	QUALIFICATION_AND_SCENE_REVIEW("4","资质审核->现场考核");
	
	
	
	private AccessProcessEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}
	
	private String code;
	
	private String name;

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}
	
	public static String getNameForCode(String code) {
		String name = "";
		if (StringUtils.isBlank(code)) {
			return name;
		}
		switch(code) {
		case "1":
			name = AccessProcessEnum.NOT_REVIEW.getName();
			break;
		case "2":
			name = AccessProcessEnum.QUALIFICATION_REVIEW.getName();
			break;
		case "3":
			name = AccessProcessEnum.SCENE_ASSESSMENT.getName();
			break;
		case "4":
			name = AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getName();
			break;
		}
		return name;
	}
	
}
