package com.els.base.certification.process.vo;

import java.util.Date;

import com.els.base.certification.process.entity.Process;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.company.entity.Company;
import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModelProperty;

public class CompanyProcessVO extends Company {
	
	private static final long serialVersionUID = 1L;
	
	private QualificationsSM qualifications;
	
	private Process process;

	public QualificationsSM getQualifications() {
		return qualifications;
	}

	public void setQualifications(QualificationsSM qualifications) {
		this.qualifications = qualifications;
	}

	public Process getProcess() {
		return process;
	}

	public void setProcess(Process process) {
		this.process = process;
	}
	
	//企业认证信息
	@JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
	@ApiModelProperty(name = "ISO9001体系证书")
    private  String ISO9001Name;
    
    @ApiModelProperty(name = "ISO9001体系证书上传文件名")
    private  String ISO9001FileName;

    @ApiModelProperty(name = "ISO9001体系证书有效期")
    private Date ISO9001EndTime;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty(name = "IATF16949体系证书")
    private  String IATF16949Name;
    
    @ApiModelProperty(name = "IATF16949体系证书上传文件名")
    private  String IATF16949FileName;

    @ApiModelProperty(name = "IATF16949体系证书有效期")
    private Date IATF16949EndTime;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty(name = "ISO14000体系证书")
    private  String ISO14000Name;
    
    @ApiModelProperty(name = "ISO14000体系证书上传文件名")
    private  String ISO14000FileName;

    @ApiModelProperty(name = "ISO14000证书有效期")
    private Date ISO14000EndTime;
    
    //大类1-大类5 注册的时候填写的 IC类之类数据
    @ApiModelProperty("公司主营二类型1")
    private String secondCompanyType1;
    
    @ApiModelProperty("公司主营二类型1说明")
    private String secondCompanyTypeDesc1;

    @ApiModelProperty("公司主营二类型2")
    private String secondCompanyType2;
    
    @ApiModelProperty("公司主营二类型2说明")
    private String secondCompanyTypeDesc2;

    @ApiModelProperty("公司主营二类型3")
    private String secondCompanyType3;
    
    @ApiModelProperty("公司主营二类型3说明")
    private String secondCompanyTypeDesc3;

    @ApiModelProperty("公司主营二类型4")
    private String secondCompanyType4;
    
    @ApiModelProperty("公司主营二类型4说明")
    private String secondCompanyTypeDesc4;

    @ApiModelProperty("公司主营二类型5")
    private String secondCompanyType5;
    
    @ApiModelProperty("公司主营二类型5说明")
    private String secondCompanyTypeDesc5;

	public String getISO9001Name() {
		return ISO9001Name;
	}

	public void setISO9001Name(String iSO9001Name) {
		ISO9001Name = iSO9001Name;
	}

	public String getISO9001FileName() {
		return ISO9001FileName;
	}

	public void setISO9001FileName(String iSO9001FileName) {
		ISO9001FileName = iSO9001FileName;
	}

	public Date getISO9001EndTime() {
		return ISO9001EndTime;
	}

	public void setISO9001EndTime(Date iSO9001EndTime) {
		ISO9001EndTime = iSO9001EndTime;
	}

	public String getIATF16949Name() {
		return IATF16949Name;
	}

	public void setIATF16949Name(String iATF16949Name) {
		IATF16949Name = iATF16949Name;
	}

	public String getIATF16949FileName() {
		return IATF16949FileName;
	}

	public void setIATF16949FileName(String iATF16949FileName) {
		IATF16949FileName = iATF16949FileName;
	}

	public Date getIATF16949EndTime() {
		return IATF16949EndTime;
	}

	public void setIATF16949EndTime(Date iATF16949EndTime) {
		IATF16949EndTime = iATF16949EndTime;
	}

	public String getISO14000Name() {
		return ISO14000Name;
	}

	public void setISO14000Name(String iSO14000Name) {
		ISO14000Name = iSO14000Name;
	}

	public String getISO14000FileName() {
		return ISO14000FileName;
	}

	public void setISO14000FileName(String iSO14000FileName) {
		ISO14000FileName = iSO14000FileName;
	}

	public Date getISO14000EndTime() {
		return ISO14000EndTime;
	}

	public void setISO14000EndTime(Date iSO14000EndTime) {
		ISO14000EndTime = iSO14000EndTime;
	}

	public String getSecondCompanyType1() {
		return secondCompanyType1;
	}

	public void setSecondCompanyType1(String secondCompanyType1) {
		this.secondCompanyType1 = secondCompanyType1;
	}

	public String getSecondCompanyTypeDesc1() {
		return secondCompanyTypeDesc1;
	}

	public void setSecondCompanyTypeDesc1(String secondCompanyTypeDesc1) {
		this.secondCompanyTypeDesc1 = secondCompanyTypeDesc1;
	}

	public String getSecondCompanyType2() {
		return secondCompanyType2;
	}

	public void setSecondCompanyType2(String secondCompanyType2) {
		this.secondCompanyType2 = secondCompanyType2;
	}

	public String getSecondCompanyTypeDesc2() {
		return secondCompanyTypeDesc2;
	}

	public void setSecondCompanyTypeDesc2(String secondCompanyTypeDesc2) {
		this.secondCompanyTypeDesc2 = secondCompanyTypeDesc2;
	}

	public String getSecondCompanyType3() {
		return secondCompanyType3;
	}

	public void setSecondCompanyType3(String secondCompanyType3) {
		this.secondCompanyType3 = secondCompanyType3;
	}

	public String getSecondCompanyTypeDesc3() {
		return secondCompanyTypeDesc3;
	}

	public void setSecondCompanyTypeDesc3(String secondCompanyTypeDesc3) {
		this.secondCompanyTypeDesc3 = secondCompanyTypeDesc3;
	}

	public String getSecondCompanyType4() {
		return secondCompanyType4;
	}

	public void setSecondCompanyType4(String secondCompanyType4) {
		this.secondCompanyType4 = secondCompanyType4;
	}

	public String getSecondCompanyTypeDesc4() {
		return secondCompanyTypeDesc4;
	}

	public void setSecondCompanyTypeDesc4(String secondCompanyTypeDesc4) {
		this.secondCompanyTypeDesc4 = secondCompanyTypeDesc4;
	}

	public String getSecondCompanyType5() {
		return secondCompanyType5;
	}

	public void setSecondCompanyType5(String secondCompanyType5) {
		this.secondCompanyType5 = secondCompanyType5;
	}

	public String getSecondCompanyTypeDesc5() {
		return secondCompanyTypeDesc5;
	}

	public void setSecondCompanyTypeDesc5(String secondCompanyTypeDesc5) {
		this.secondCompanyTypeDesc5 = secondCompanyTypeDesc5;
	}

}
