package com.els.base.certification.process.web.controller;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.certification.process.util.ExcelFileData;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.process.vo.CompanyQualificationVO;
import com.els.base.certification.process.vo.ReportFormVO;
import com.els.base.certification.process.vo.SupplierCompanyVO;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyTypeEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.TitleAndModelKey;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WriteException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商准入-准入流程")
@Controller
@RequestMapping("process")
public class ProcessController {
    @Resource
    protected ProcessService processService;
    
    @Resource
    protected CompanyService companyService;
    
    @Resource
    private DicGroupItemService dicGroupItemService;
    
    @Resource 
    private CompanyAuthService companyAuthService;
    
    @Resource
    private QualificationsSMService qualificationsSMService;
    
    @Resource
    private QualificationsSMFlieService qualificationsSMFlieService;
    
    @Resource
    private ProcessManagementService processManagementService;

    @ApiOperation(httpMethod="POST", value="创建供应商准入-准入流程")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Process process) {
    	Assert.isNotNull(process, "保存数据不能为空");
    	Assert.isNotBlank(process.getCompanyId(), "供应商ID不能为空");
    	Assert.isNotBlank(process.getAccessProcess(), "准入流程不能为空");
    	Assert.isNotBlank(process.getProcessName(), "准入流程名称不能为空");
        this.processService.addObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商准入-准入流程")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Process process) {
        Assert.isNotBlank(process.getId(), "id 为空，保存失败");
        this.processService.modifyObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商准入-准入流程")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.processService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-准入流程")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Process", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Process>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ProcessExample example = new ProcessExample();
        example.setPageView(new PageView<Process>(pageNo, pageSize));
        
//        ProcessExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<Process> pageData = this.processService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="创建资质审核、现场考察单时查询供应商与准入流程信息")
    @ApiImplicitParams({ 
    	@ApiImplicitParam(name = "accessProcess",required = true,value = "审核流程：不需审核，只资质审核，只现场考核，资质审核->现场考核 (1,2,3,4)", paramType = "query", dataType = "String"),
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Process", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findCompanyByPage( 
    	@RequestParam String accessProcess,
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
    	Assert.isNotBlank(accessProcess, "传入的准入流程不能为空");
    	
    	CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		CompanyExample.Criteria criteria = companyExample.createCriteria();
		criteria.andIsEnableEqualTo(Constant.YES_INT);
		if (wapper != null) {
			CriteriaUtils.addExample(companyExample, wapper);
		}
		// 获取采购商ID
		String roleEnum = "stranger";
		String purCompanyId = CompanyUtils.currentCompanyId();
		PageView<Company> companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
    	List<Company> companyList = companyPageView.getQueryResult();
    	PageView<CompanyProcessVO> companyVoPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
		if (CollectionUtils.isEmpty(companyList)) {
			return ResponseResult.success(companyVoPage);
		}
		int rowCount = 0;
		List<CompanyProcessVO> voList = new ArrayList<>();
    	for (Company company : companyList) {
    		Process process = this.processService.queryObjByCompanyId(company.getId());
    		if (null == process) {
    			continue;
    		}
    		CompanyProcessVO vo = new CompanyProcessVO();
    		if ("2".equals(accessProcess)) {
    			if ((AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess()) ||
    					AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess())) &&
    					(StringUtils.isBlank(process.getQualificationAudit()) || 
    					ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit()))) {
    				// 查询模版附件
    				ProcessManagement manage = this.processManagementService.queryObjById(process.getProcessId());
    				QualificationsSM qualificationSM = this.qualificationsSMService.queryObjById(manage.getQualificationAuditTemplateId());
    				QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
    				fileExample.createCriteria().andTemplatIdEqualTo(manage.getQualificationAuditTemplateId())
    					.andIsEnableEqualTo(Constant.YES_INT);
    				List<QualificationsSMFlie> fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
    				qualificationSM.setQualificationsSMFlielist(fileList);
    				BeanUtils.copyProperties(company, vo);
    				// 设置大类1-大类5
    				this.setSecondCompanyType(company, vo);
    				// 设置供应商证书信息
    				this.setSupplierCertification(vo);
    				vo.setProcess(process);
    				vo.setQualifications(qualificationSM);
    				voList.add(vo);
    				rowCount++;
    			}
    		} else if ("3".equals(accessProcess)) {
    			if ((AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess()) ||
    					(AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess()) && 
    					ReviewResultEnum.ADOPT.getCode().equals(process.getQualificationAudit()))) && 
    					(StringUtils.isBlank(process.getSceneInvestigate()) || 
    					ReviewResultEnum.TERMINATION.getCode().equals(process.getSceneInvestigate()))) {
    				// 查询模版附件
    				ProcessManagement manage = this.processManagementService.queryObjById(process.getProcessId());
    				QualificationsSM qualificationSM = this.qualificationsSMService.queryObjById(manage.getSiteInspectionTemplateId());
    				QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
    				fileExample.createCriteria().andTemplatIdEqualTo(manage.getSiteInspectionTemplateId())
    					.andIsEnableEqualTo(Constant.YES_INT);
    				List<QualificationsSMFlie> fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
    				qualificationSM.setQualificationsSMFlielist(fileList);
    				BeanUtils.copyProperties(company, vo);
    				// 设置大类1-大类5
    				this.setSecondCompanyType(company, vo);
    				// 设置供应商证书信息
    				this.setSupplierCertification(vo);
    				vo.setProcess(process);
    				vo.setQualifications(qualificationSM);
    				voList.add(vo);
    				rowCount++;
    			}
    		}
    	}
    	companyVoPage.setQueryResult(voList);
    	companyVoPage.setRowCount(rowCount);
    	return ResponseResult.success(companyVoPage);	
 
    	/*// 根据准入流程查询准入流程信息
    	List<String> list = new ArrayList<>();
		list.add(accessProcess);
		list.add(AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode());
		ProcessExample processExample = new ProcessExample();		
		processExample.createCriteria().andAccessProcessIn(list)
			.andIsEnableEqualTo(Constant.YES_INT);
		List<Process> processList = this.processService.queryAllObjByExample(processExample);
		Assert.isNotEmpty(processList, "没有供应商需要通过资质审核");
		// 循环根据条件set到VO中
		List<CompanyQualificationVO> voList = new ArrayList<>();
		for (Process process : processList) {
			CompanyQualificationVO vo = new CompanyQualificationVO();
			if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(accessProcess)) {
				// 在创建资质审核单时，资质审核状态为空或终止开发才显示数据来创建单据
				if (StringUtils.isBlank(process.getQualificationAudit()) || 
						ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) {
					// 设置供应商、准入流程、模版信息
					this.setCompanyAndProcessInfo(process,vo,accessProcess);
					
					voList.add(vo);
				}
			} else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(accessProcess)) {
				
				 *  在创建现场考察单时，如果是只现场考察，准入流程的现场考察状态为空或终止开发显示数据来创建单据，
				 *  	如果是资质审核->现场考察，准入流程的资质审核状态为通过且现场考察状态为空或终止开发才显示数据创建单据
				 
				if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.equals(process.getAccessProcess()) &&
						ReviewResultEnum.ADOPT.getCode().equals(process.getQualificationAudit()) &&
						(StringUtils.isBlank(process.getSceneInvestigate()) || 
						ReviewResultEnum.TERMINATION.getCode().equals(process.getSceneInvestigate()))) {
					// 设置供应商、准入流程、模版信息
					this.setCompanyAndProcessInfo(process, vo,accessProcess);
					voList.add(vo);			
				} else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess()) && 
						StringUtils.isBlank(process.getSceneInvestigate()) || 
						ReviewResultEnum.TERMINATION.getCode().equals(process.getSceneInvestigate())) {
					// 设置供应商、准入流程、模版信息
					this.setCompanyAndProcessInfo(process, vo,accessProcess);
					voList.add(vo);			
				}
			}
		}
		PageView<CompanyQualificationVO> companyProcessPage = new PageView<CompanyQualificationVO>(pageNo, pageSize);
		companyProcessPage.setQueryResult(voList);
		return ResponseResult.success(companyProcessPage);*/
    }

	private void setCompanyAndProcessInfo(Process process, CompanyQualificationVO vo,String accessProcess) {
		// 查询供应商信息
		Company company = this.companyService.queryObjById(process.getCompanyId());
		// 查询模版信息跟附件信息
		QualificationsSM qualificationsSM = null;
		if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(accessProcess)) {
			// 如果是资质审核，根据资质模版ID查询信息
			qualificationsSM = this.qualificationsSMService.queryObjById(process.getQualificationAuditTemplateId());
		}
		if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(accessProcess)) {
			qualificationsSM = this.qualificationsSMService.queryObjById(process.getSiteInspectionTemplateId());
		}
		QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
		fileExample.createCriteria().andTemplatIdEqualTo(qualificationsSM.getId())
			.andIsEnableEqualTo(Constant.YES_INT);
		List<QualificationsSMFlie> fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
		qualificationsSM.setQualificationsSMFlielist(fileList);
		BeanUtils.copyProperties(company, vo);
		vo.setProcess(process);
		vo.setQualifications(qualificationsSM);
		
	}
	
	@ApiOperation(httpMethod="POST", value="准入报表-准入流程")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Process", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/formFindByPage")
    @ResponseBody
    public ResponseResult<PageView<ReportFormVO>> formFindByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
		// 查询供应商信息
		CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo,pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
		if (wapper != null) {
			CriteriaUtils.addExample(companyExample, wapper);
		}
		PageView<Company> companyPage = this.companyService.queryObjByPage(companyExample);
		List<Company> companyList = companyPage.getQueryResult();
		List<ReportFormVO> list = this.getReportForm(companyList);
		
		PageView<ReportFormVO> formPage = new PageView<ReportFormVO>(pageNo,pageSize);
		formPage.setQueryResult(list);
		return ResponseResult.success(formPage);
	}
	
	/**
	 * 设置报表信息
	 * @param companyList
	 * @return
	 */
    private List<ReportFormVO> getReportForm(List<Company> companyList) {
		List<ReportFormVO> list = new ArrayList<ReportFormVO>();
		for (Company company : companyList) {
			ReportFormVO vo = new ReportFormVO();
			// 根据供应商ID查询准入流程信息
			Process process = this.processService.queryObjByCompanyId(company.getId());
			if (null == process) {
				continue;
			}
			// 设置供应商信息
			vo.setSupCompanyName(company.getCompanyFullName());
			vo.setSupCompanySrmCode(company.getCompanyCode());
			vo.setStartTime(company.getCreateTime());
			// 供应商分类编码
			vo.setSupplierLevelCode(process.getSupplierLevelCode());
			// 供应商分类名称
			vo.setSupClassificationName(process.getSupClassificationName());
			
			// 设置准入流程信息
			vo.setAccessProcess(process.getAccessProcess());
			if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess())) {
				vo.setStatus(process.getQualificationAudit());
				if (!ReviewResultEnum.AUDIT.getCode().equals(process.getQualificationAudit())) {
					vo.setEndTime(process.getUpdateTime());
				}
			}
			if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess())) {
				vo.setStatus(process.getSceneInvestigate());
				if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
					vo.setEndTime(process.getUpdateTime());
				}
			}
			if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess())) {
				vo.setStatus(ReviewResultEnum.AUDIT.getCode());
				if (ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) {
					vo.setStatus(process.getQualificationAudit());
					vo.setEndTime(process.getUpdateTime());
				} 
				if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
					vo.setStatus(process.getSceneInvestigate());
					vo.setEndTime(process.getUpdateTime());
				}
			}
			list.add(vo);
		}
		return list;
	}

	@ApiOperation(httpMethod="POST", value="查询供应商与准入流程信息")
    @ApiImplicitParams({ 
    	@ApiImplicitParam(name = "roleEnum", required = false, value = "陌生供应商，合格供应商（stranger/qualified）", paramType = "query", dataType = "String", defaultValue = "stranger"),
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Process", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findAllCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPage( 
    	@RequestParam(defaultValue = "stranger") String roleEnum,
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
		// 1.加入供应商查询条件
		CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		CompanyExample.Criteria criteria = companyExample.createCriteria();
		criteria.andIsEnableEqualTo(Constant.YES_INT);
		if (wapper != null) {
			CriteriaUtils.addExample(companyExample, wapper);
		}
		// 获取采购商ID
		String purCompanyId = CompanyUtils.currentCompanyId();
		PageView<Company> companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
//		PageView<Company> companyPageView = this.companyService.queryObjByPage(companyExample);
		// 设置供应商其他基本信息和准入流程信息
		List<Company> companyList = companyPageView.getQueryResult();
		PageView<CompanyProcessVO> companyProcessPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
		companyProcessPage.setRowCount(companyPageView.getRowCount());
		if (CollectionUtils.isEmpty(companyList)) {
			return ResponseResult.success(companyProcessPage);
		}
		List<CompanyProcessVO> list = getSuppliers(companyList);
		companyProcessPage.setQueryResult(list);
		return ResponseResult.success(companyProcessPage);
    }

	private List<CompanyProcessVO> getSuppliers(List<Company> companyList) {
		List<CompanyProcessVO> list = new ArrayList<>();
		companyList.forEach(company ->{
			CompanyProcessVO vo = new CompanyProcessVO();
			BeanUtils.copyProperties(company, vo);
			// 设置大类1-大类5
			this.setSecondCompanyType(company, vo);
			// 设置供应商证书信息
			this.setSupplierCertification(vo);
			// 设置准入流程信息
			ProcessExample processExample = new ProcessExample();
			processExample.createCriteria().andCompanyIdEqualTo(company.getId());
			List<Process> processList = processService.queryAllObjByExample(processExample);
			// 这里new对象,是因为从MDM推送的供应商没有走准入，准入流程为空，合格供应商清单导出Excel时会系统异常
			Process process = new Process();
			if(CollectionUtils.isNotEmpty(processList)){
				process = processList.get(0);
			}
			vo.setProcess(process);
			
			list.add(vo);
		});
		return list;
	}
	
	/**
	 * 设置供应商证书信息
	 * @param vo
	 */
	private void setSupplierCertification(CompanyProcessVO vo) {
		// 1.设置IATF16949证书信息
		CompanyAuthExample companyAuthExample = new CompanyAuthExample();
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
		List<CompanyAuth> companyAuthList = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList)) {
			CompanyAuth companyAuth1 = companyAuthList.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth1.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth1.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setIATF16949FileName(str);
			vo.setIATF16949Name(companyAuth1.getCertificateFile());
			vo.setIATF16949EndTime(companyAuth1.getEndTime());
		}

		// 2.设置IOS9001证书信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
		List<CompanyAuth> companyAuthList2 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList2)) {
			CompanyAuth companyAuth2 = companyAuthList2.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth2.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth2.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setISO9001FileName(str);
			vo.setISO9001Name(companyAuth2.getCertificateFile());
			vo.setISO9001EndTime(companyAuth2.getEndTime());
		}

		// 3.设置IOS14000证书基本信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId())
			.andIsEnableEqualTo(Constant.YES_INT)
			.andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
		List<CompanyAuth> companyAuthList3 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList3)) {
			CompanyAuth companyAuth3 = companyAuthList3.get(0);
			String str = "";
			if (StringUtils.isNotEmpty(companyAuth3.getCertificateFile())) {
				JSONArray json = JSONArray.fromObject(companyAuth3.getCertificateFile());
				if (json.size() > 0) {
					JSONObject job = json.getJSONObject(0);
					str = (String) job.get("name");
				}
			}
			vo.setISO14000FileName(str);
			vo.setISO14000Name(companyAuth3.getCertificateFile());
			vo.setISO14000EndTime(companyAuth3.getEndTime());
		}

	}

	/**
	 * 设置大类1-5
	 * @param company
	 * @param vo
	 */
	private void setSecondCompanyType(Company company, CompanyProcessVO vo) {
		String secondCompanyType = company.getSecondCompanyType();
		if (StringUtils.isNotBlank(secondCompanyType)) {
			String[] secondCompanyTypeStr = secondCompanyType.split(",");
			if (ArrayUtils.isNotEmpty(secondCompanyTypeStr)) {

				// 只要前5个
				if (secondCompanyTypeStr.length > 5) {
					vo.setSecondCompanyType1(secondCompanyTypeStr[0]);
					DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[0]);
					if (dicItem1 != null) {
						vo.setSecondCompanyTypeDesc1(dicItem1.getName());
					} else {
						vo.setSecondCompanyTypeDesc1("");
					}

					vo.setSecondCompanyType2(secondCompanyTypeStr[1]);
					DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[1]);
					if (dicItem2 != null) {
						vo.setSecondCompanyTypeDesc2(dicItem2.getName());
					} else {
						vo.setSecondCompanyTypeDesc2("");
					}

					vo.setSecondCompanyType3(secondCompanyTypeStr[2]);
					DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[2]);
					if (dicItem3 != null) {
						vo.setSecondCompanyTypeDesc3(dicItem3.getName());
					} else {
						vo.setSecondCompanyTypeDesc3("");
					}

					vo.setSecondCompanyType4(secondCompanyTypeStr[3]);
					DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[3]);
					if (dicItem4 != null) {
						vo.setSecondCompanyTypeDesc4(dicItem4.getName());
					} else {
						vo.setSecondCompanyTypeDesc4("");
					}
					;

					vo.setSecondCompanyType5(secondCompanyTypeStr[4]);
					DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
							secondCompanyTypeStr[4]);
					if (dicItem5 != null) {
						vo.setSecondCompanyTypeDesc5(dicItem5.getName());
					} else {
						vo.setSecondCompanyTypeDesc5("");
					}
				} else {
					for (int i = 1; i <= secondCompanyTypeStr.length; i++) {

						if (i == 1) {
							vo.setSecondCompanyType1(secondCompanyTypeStr[0]);
							DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[0]);
							if (dicItem1 != null) {
								vo.setSecondCompanyTypeDesc1(dicItem1.getName());
							} else {
								vo.setSecondCompanyTypeDesc1("");
							}
						} else if (i == 2) {
							vo.setSecondCompanyType2(secondCompanyTypeStr[1]);
							DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[1]);
							if (dicItem2 != null) {
								vo.setSecondCompanyTypeDesc2(dicItem2.getName());
							} else {
								vo.setSecondCompanyTypeDesc2("");
							}
						} else if (i == 3) {
							vo.setSecondCompanyType3(secondCompanyTypeStr[2]);
							DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[2]);
							if (dicItem3 != null) {
								vo.setSecondCompanyTypeDesc3(dicItem3.getName());
							} else {
								vo.setSecondCompanyTypeDesc3("");
							}
						} else if (i == 4) {
							vo.setSecondCompanyType4(secondCompanyTypeStr[3]);
							DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[3]);
							if (dicItem4 != null) {
								vo.setSecondCompanyTypeDesc4(dicItem4.getName());
							} else {
								vo.setSecondCompanyTypeDesc4("");
							}
						} else if (i == 5) {
							vo.setSecondCompanyType5(secondCompanyTypeStr[4]);
							DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei",
									secondCompanyTypeStr[4]);
							if (dicItem5 != null) {
								vo.setSecondCompanyTypeDesc5(dicItem5.getName());
							} else {
								vo.setSecondCompanyTypeDesc5("");
							}
						} else {

						}

					}
				}

			}
		}

	}
    
	@ApiOperation(httpMethod="POST", value="查询供应商与准入流程信息")
    @ApiImplicitParams({ 
    	@ApiImplicitParam(name = "roleEnum", required = false, value = "陌生供应商，合格供应商（stranger/qualified）", paramType = "query", dataType = "String", defaultValue = "stranger"),
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "map", required = false, value = "查询条件,属性名请参考 Process", paramType = "body", dataType = "Map" )  
	}) 
    @RequestMapping("service/findAllCompanyByPages")
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPages( 
    	@RequestParam(defaultValue = "stranger") String roleEnum,
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) Map<String,Object> queryMap) {
		queryMap.put("pageNo", pageNo);
		queryMap.put("pageSize", pageSize);
		String purCompanyId = CompanyUtils.currentCompanyId();
		
		PageView<Company> companyPageView = this.processService.queryAllCompnayByPage(purCompanyId,roleEnum,queryMap);
//		if (MapUtils.isNotEmpty(queryMap)) {
//		} else {
//			// 1.加入供应商查询条件
//			CompanyExample companyExample = new CompanyExample();
//			companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
//			companyExample.setOrderByClause("CREATE_TIME DESC");
//			CompanyExample.Criteria criteria = companyExample.createCriteria();
//			criteria.andIsEnableEqualTo(Constant.YES_INT);
//			// 获取采购商ID
//			companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
//		}
		// 设置供应商其他基本信息和准入流程信息
		List<Company> companyList = companyPageView.getQueryResult();
		PageView<CompanyProcessVO> companyProcessPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
		companyProcessPage.setRowCount(companyPageView.getRowCount());
		if (CollectionUtils.isEmpty(companyList)) {
			return ResponseResult.success(companyProcessPage);
		}
		List<CompanyProcessVO> list = getSuppliers(companyList);
		companyProcessPage.setQueryResult(list);
		return ResponseResult.success(companyProcessPage);
    }
	
	@ApiOperation(httpMethod="POST", value="查询供应商与准入流程信息")
	 @RequestMapping("service/findCompanyInFo")
    @ResponseBody
    public ResponseResult<CompanyProcessVO> findCompanyInFo(
    	@RequestParam(required = true) String companyId) {
		
		Assert.isNotBlank(companyId, "供应商ID不能为空");
		Company company = this.companyService.queryObjById(companyId);
		List<Company> companyList = new ArrayList<>();
		companyList.add(company);
		List<CompanyProcessVO> list = getSuppliers(companyList);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		
		return ResponseResult.success(list.get(0));
	}
	
	@ApiOperation(httpMethod="POST" ,value="合格供应商清单,导出Excel")
	@RequestMapping("service/downloadExcelForPur")
	@ResponseBody
	public ResponseResult<FileData> downloadExcelForPur(@RequestBody(required=false) Map<String,Object> queryMap)
            throws IOException, ParseException, WriteException, Exception {
		queryMap.put("pageNo", 1);
		queryMap.put("pageSize", 999);
		// 如果传值了按照传的code值导出供应商，如果没有传就导出全部合格供应商
		String purCompanyId = CompanyUtils.currentCompanyId();
		// 如果选择了导出的供应商，就将供应商SRM编码以逗号隔开存在queryParams中
		String params = (String) queryMap.get("queryParams");
		List<Company> companyList = new ArrayList<Company>();
		// 如果queryParams的值为空，就按照查询条件查询供应商导出，如果有值，就按照其值查询供应商导出
		if (StringUtils.isBlank(params)) {
			PageView<Company> companyPageView = this.processService.queryAllCompnayByPage(purCompanyId,PartnerRoleEnum.QUALIFIED.getCode(),queryMap);
			companyList = companyPageView.getQueryResult();
		} else {
			String[] codeList = params.split(",");
			List<String> asList = Arrays.asList(codeList);
			CompanyExample companyExample = new CompanyExample();
			companyExample.createCriteria().andCompanyCodeIn(asList)
							.andIsEnableEqualTo(Constant.YES_INT);
			companyList = this.companyService.queryAllObjByExample(companyExample);
			
		}
		List<CompanyProcessVO> list = new ArrayList<>();
		List<SupplierCompanyVO> voList = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(companyList)) {
			list = getSuppliers(companyList);
			// 认证状态、准入流程、资质考察、现场考察将由code值转化为描述值
			list.forEach(processVO ->{
				SupplierCompanyVO vo = new SupplierCompanyVO();
				BeanUtils.copyProperties(processVO, vo);
				vo.setFirstCompanyTypeDesc(CompanyTypeEnum.getValueForCode(processVO.getFirstCompanyType()));
				vo.setIsSendName(AuthenticationEnum.getNameForCode(processVO.getProcess().getIsSend()));
				vo.setAccessProcessName(AccessProcessEnum.getNameForCode(processVO.getProcess().getAccessProcess()));
				vo.setQualificationAuditName(ReviewResultEnum.getNameForCode(processVO.getProcess().getQualificationAudit()));
				vo.setSceneInvestigateName(ReviewResultEnum.getNameForCode(processVO.getProcess().getSceneInvestigate()));
				if (StringUtils.isBlank(processVO.getProcess().getProcessName())) {
					vo.setProcessName("");
				} else {
					vo.setProcessName(processVO.getProcess().getProcessName());
				}
				voList.add(vo);
			});
		}
		// 创建要导出的头部信息
		List<TitleAndModelKey> titleAndModelKeys = this.processService.createExcelHeaderForPur();
		
		FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, voList, "合格供应商清单", "合格供应商清单", 0);
		
		return ResponseResult.success(fileData);
	}
}