package com.els.base.certification.productservice.service.impl;

import com.els.base.certification.productservice.dao.CompanyProductServiceMapper;
import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyProductServiceService")
public class CompanyProductServiceServiceImpl implements CompanyProductServiceService {
    @Resource
    protected CompanyProductServiceMapper companyProductServiceMapper;

    @Cacheable(value="companyProductService", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyProductServiceExample companyProductServiceExample =new CompanyProductServiceExample();
        //如果数据为空，那么返回0
        companyProductServiceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if(this.companyProductServiceMapper.countByExample(companyProductServiceExample) <= 0){
        	return 0;
        }
        
        //如果数据不为空，那么判断完成状态只要有0，那么返回未完成
        companyProductServiceExample.clear();
        companyProductServiceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int count = this.companyProductServiceMapper.countByExample(companyProductServiceExample);
        if(count>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyProductService"}, allEntries=true)
    @Override
    public void addObj(CompanyProductService t) {
        this.companyProductServiceMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyProductService"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyProductServiceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyProductService"}, allEntries=true)
    @Override
    public void modifyObj(CompanyProductService t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyProductServiceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyProductService", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyProductService queryObjById(String id) {
        return this.companyProductServiceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyProductService", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyProductService> queryAllObjByExample(CompanyProductServiceExample example) {
        return this.companyProductServiceMapper.selectByExample(example);
    }

    @Cacheable(value="companyProductService", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyProductService> queryObjByPage(CompanyProductServiceExample example) {
        PageView<CompanyProductService> pageView = example.getPageView();
        pageView.setQueryResult(this.companyProductServiceMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyProductService"}, allEntries=true)
	@Override
	public Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyProductService> productServiceList) {
		if(CollectionUtils.isEmpty(productServiceList)){
			throw new CommonException("传递的产品服务数据为空!");
		}
		
		CompanyProductServiceExample example = new CompanyProductServiceExample();
		example.createCriteria()
			   .andProjectIdEqualTo(projectId)
			   .andSupCompanyIdEqualTo(supCompany.getId())
			   .andIsEnableEqualTo(Constant.YES_INT);
		
		CompanyProductService product = new CompanyProductService();
		product.setIsEnable(Constant.NO_INT);
		
		this.companyProductServiceMapper.updateByExampleSelective(product, example);

//        List<Integer> list = new ArrayList<Integer>();

        for (CompanyProductService companyProductService : productServiceList) {
			companyProductService.setId(null);
			companyProductService.setProjectId(projectId);
			companyProductService.setPurCompanyId(purCompany.getId());
			companyProductService.setPurCompanySrmCode(purCompany.getCompanyCode());
			companyProductService.setPurCompanyName(purCompany.getCompanyName());
			companyProductService.setSupCompanyId(supCompany.getId());
			companyProductService.setSupCompanySrmCode(supCompany.getCompanyCode());
			companyProductService.setSupCompanyName(supCompany.getCompanyName());
			companyProductService.setIsEnable(Constant.YES_INT);
			companyProductService.setCreateTime(new Date());
			companyProductService.setUpdateTime(new Date());
			//默认没有填写完成的
			//companyProductService.setFinishFlag(Constant.NO_INT);
			//完成标识,一开始默认是0,0也是非空,不会影响非空判断
//			Integer finishFlag = companyProductService.getFinishFlag(supCompany.getFirstCompanyType());
//			companyProductService.setFinishFlag(finishFlag);
			this.addObj(companyProductService);

//            list.add(finishFlag);
		}

//        if(list.contains(Constant.NO_INT)){
//            return 0;
//        }else{
//            return 1;
//        }
        return 1;
    }
    
    @Transactional
    @CacheEvict(value={"companyProductService"}, allEntries=true)
	@Override
	public void deleteObjByIds(String projectId, Company company, List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
        	throw new CommonException("传递的id列表为空!");
        }
    	
    	CompanyProductServiceExample example = new CompanyProductServiceExample();
    	example.createCriteria()
    		   .andProjectIdEqualTo(projectId)
    		   .andSupCompanyIdEqualTo(company.getId())
    		   .andIdIn(ids);
    	
    	CompanyProductService product = new CompanyProductService();
    	product.setIsEnable(Constant.NO_INT);
    	
    	this.companyProductServiceMapper.updateByExampleSelective(product, example);
    }
}