package com.els.base.certification.qualification.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="供应商准入-资质审核单附件")
public class QualificationItem implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("资质审核表ID")
    private String qualificationReviewId;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购方上传的文件")
    private String purFile;

    @ApiModelProperty("采购方上传的文件名称")
    private String purFileName;

    @ApiModelProperty("采购方上传文件的时间")
    private Date purUploadTime;

    @ApiModelProperty("采购方备注")
    private String purRemarks;

    @ApiModelProperty("采购方审核文件说明")
    private String purFileExplain;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应商上传的文件")
    private String supFile;

    @ApiModelProperty("供应商上传的文件名称")
    private String supFileName;

    @ApiModelProperty("供应商上传文件时间")
    private Date supUploadTime;

    @ApiModelProperty("供应商备注")
    private String supRemarks;

    @ApiModelProperty("供应商说明")
    private String supExplain;

    @ApiModelProperty("排序号")
    private Integer sortNumber;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("公司类型(0为采购商，1为供应商)")
    private Integer companyType;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getQualificationReviewId() {
        return qualificationReviewId;
    }

    public void setQualificationReviewId(String qualificationReviewId) {
        this.qualificationReviewId = qualificationReviewId == null ? null : qualificationReviewId.trim();
    }

    public String getPurFile() {
        return purFile;
    }

    public void setPurFile(String purFile) {
        this.purFile = purFile == null ? null : purFile.trim();
    }

    public String getPurFileName() {
        return purFileName;
    }

    public void setPurFileName(String purFileName) {
        this.purFileName = purFileName == null ? null : purFileName.trim();
    }

    public Date getPurUploadTime() {
        return purUploadTime;
    }

    public void setPurUploadTime(Date purUploadTime) {
        this.purUploadTime = purUploadTime;
    }

    public String getPurRemarks() {
        return purRemarks;
    }

    public void setPurRemarks(String purRemarks) {
        this.purRemarks = purRemarks == null ? null : purRemarks.trim();
    }

    public String getPurFileExplain() {
        return purFileExplain;
    }

    public void setPurFileExplain(String purFileExplain) {
        this.purFileExplain = purFileExplain == null ? null : purFileExplain.trim();
    }

    public String getSupFile() {
        return supFile;
    }

    public void setSupFile(String supFile) {
        this.supFile = supFile == null ? null : supFile.trim();
    }

    public String getSupFileName() {
        return supFileName;
    }

    public void setSupFileName(String supFileName) {
        this.supFileName = supFileName == null ? null : supFileName.trim();
    }

    public Date getSupUploadTime() {
        return supUploadTime;
    }

    public void setSupUploadTime(Date supUploadTime) {
        this.supUploadTime = supUploadTime;
    }

    public String getSupRemarks() {
        return supRemarks;
    }

    public void setSupRemarks(String supRemarks) {
        this.supRemarks = supRemarks == null ? null : supRemarks.trim();
    }

    public String getSupExplain() {
        return supExplain;
    }

    public void setSupExplain(String supExplain) {
        this.supExplain = supExplain == null ? null : supExplain.trim();
    }

    public Integer getSortNumber() {
        return sortNumber;
    }

    public void setSortNumber(Integer sortNumber) {
        this.sortNumber = sortNumber;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCompanyType() {
        return companyType;
    }

    public void setCompanyType(Integer companyType) {
        this.companyType = companyType;
    }
}