package com.els.base.certification.qualification.util;

public enum DocumentStatusEnum {
	/**未发送**/
	UNSENT("1","未发送"),
	/**待上传**/
	WAIT_UPLOAD("2","待上传"),
	/**待审核**/
	WAIT_REVIEW("3","待审核"),
	/**通过审核**/
	THROUGH_AUDIT("4","通过审核"),
	/**驳回**/
	REJECT("5","驳回"),
	/**终止审核**/
	TERMINATE_AUDIT("6","终止审核"),
	/**已补资料**/
	SUPPLEMENTARY_INFORMATION("7","已补资料");
	
	private DocumentStatusEnum(String code, String name) {
		this.code = code;
		this.name = name;
	}

	private String code;
	
	private String name;

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}
	
}
