package com.els.base.certification.rawmaterial.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="供应商准入-主要供应商/原材料")
public class CompanyRawMaterial  extends AbstractCompany implements Serializable {
	//非自动生成
    //忽略校验的字段
    @Override
    protected List<String> exculdeFieldNames() {
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("projectId");
        filedNameList.add("purCompanyId");
        filedNameList.add("purCompanySrmCode");
        filedNameList.add("purCompanyName");
        filedNameList.add("supCompanyId");
        filedNameList.add("supCompanySrmCode");
        filedNameList.add("supCompanyName");
        filedNameList.add("isEnable");
        filedNameList.add("finishFlag");
        filedNameList.add("createTime");
        filedNameList.add("updateTime");
        return filedNameList;
    }
	
	@ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购商公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商名称")
    private String purCompanyName;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("主要原材料")
    private String rawMaterial;

    @ApiModelProperty("原产地")
    private String origin;

    @ApiModelProperty("供应商")
    private String supplier;

    @ApiModelProperty("占原材料总采购金额的比例")
    private BigDecimal purAmountProportion;

    @ApiModelProperty("年采购额")
    private BigDecimal purchaseAmount;

    @ApiModelProperty("业务开始时间")
    private Date startTime;

    @ApiModelProperty("说明")
    private String explaination;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;
    
    @ApiModelProperty("特殊过程名称")
    private String specialProcessName;

    @ApiModelProperty("地址")
    private String address;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getRawMaterial() {
        return rawMaterial;
    }

    public void setRawMaterial(String rawMaterial) {
        this.rawMaterial = rawMaterial == null ? null : rawMaterial.trim();
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin == null ? null : origin.trim();
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier == null ? null : supplier.trim();
    }

    public BigDecimal getPurAmountProportion() {
        return purAmountProportion;
    }

    public void setPurAmountProportion(BigDecimal purAmountProportion) {
        this.purAmountProportion = purAmountProportion;
    }

    public BigDecimal getPurchaseAmount() {
        return purchaseAmount;
    }

    public void setPurchaseAmount(BigDecimal purchaseAmount) {
        this.purchaseAmount = purchaseAmount;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getExplaination() {
        return explaination;
    }

    public void setExplaination(String explaination) {
        this.explaination = explaination == null ? null : explaination.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

   /* public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
    
    public String getSpecialProcessName() {
        return specialProcessName;
    }

    public void setSpecialProcessName(String specialProcessName) {
        this.specialProcessName = specialProcessName == null ? null : specialProcessName.trim();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }
}