package com.els.base.certification.rawmaterial.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompanyRawMaterialExample extends AbstractExample<CompanyRawMaterial> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<CompanyRawMaterial> pageView = new PageView<CompanyRawMaterial>(1, 10);

    private static final long serialVersionUID = 1L;

    public CompanyRawMaterialExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<CompanyRawMaterial> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<CompanyRawMaterial> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNull() {
            addCriterion("PUR_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNotNull() {
            addCriterion("PUR_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID =", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <>", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThan(String value) {
            addCriterion("PUR_COMPANY_ID >", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID >=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThan(String value) {
            addCriterion("PUR_COMPANY_ID <", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLike(String value) {
            addCriterion("PUR_COMPANY_ID like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotLike(String value) {
            addCriterion("PUR_COMPANY_ID not like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID not in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID not between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE =", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <>", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE not like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE not in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE not between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNull() {
            addCriterion("PUR_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNotNull() {
            addCriterion("PUR_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME =", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <>", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_NAME >", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME >=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThan(String value) {
            addCriterion("PUR_COMPANY_NAME <", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLike(String value) {
            addCriterion("PUR_COMPANY_NAME like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotLike(String value) {
            addCriterion("PUR_COMPANY_NAME not like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME not in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME not between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE =", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <>", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE not like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE not in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE not between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNull() {
            addCriterion("SUP_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNotNull() {
            addCriterion("SUP_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME =", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <>", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_NAME >", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME >=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThan(String value) {
            addCriterion("SUP_COMPANY_NAME <", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotLike(String value) {
            addCriterion("SUP_COMPANY_NAME not like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME not in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME not between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andRawMaterialIsNull() {
            addCriterion("RAW_MATERIAL is null");
            return (Criteria) this;
        }

        public Criteria andRawMaterialIsNotNull() {
            addCriterion("RAW_MATERIAL is not null");
            return (Criteria) this;
        }

        public Criteria andRawMaterialEqualTo(String value) {
            addCriterion("RAW_MATERIAL =", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialNotEqualTo(String value) {
            addCriterion("RAW_MATERIAL <>", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialGreaterThan(String value) {
            addCriterion("RAW_MATERIAL >", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialGreaterThanOrEqualTo(String value) {
            addCriterion("RAW_MATERIAL >=", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialLessThan(String value) {
            addCriterion("RAW_MATERIAL <", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialLessThanOrEqualTo(String value) {
            addCriterion("RAW_MATERIAL <=", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialLike(String value) {
            addCriterion("RAW_MATERIAL like", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialNotLike(String value) {
            addCriterion("RAW_MATERIAL not like", value, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialIn(List<String> values) {
            addCriterion("RAW_MATERIAL in", values, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialNotIn(List<String> values) {
            addCriterion("RAW_MATERIAL not in", values, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialBetween(String value1, String value2) {
            addCriterion("RAW_MATERIAL between", value1, value2, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andRawMaterialNotBetween(String value1, String value2) {
            addCriterion("RAW_MATERIAL not between", value1, value2, "rawMaterial");
            return (Criteria) this;
        }

        public Criteria andOriginIsNull() {
            addCriterion("ORIGIN is null");
            return (Criteria) this;
        }

        public Criteria andOriginIsNotNull() {
            addCriterion("ORIGIN is not null");
            return (Criteria) this;
        }

        public Criteria andOriginEqualTo(String value) {
            addCriterion("ORIGIN =", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginNotEqualTo(String value) {
            addCriterion("ORIGIN <>", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginGreaterThan(String value) {
            addCriterion("ORIGIN >", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginGreaterThanOrEqualTo(String value) {
            addCriterion("ORIGIN >=", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginLessThan(String value) {
            addCriterion("ORIGIN <", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginLessThanOrEqualTo(String value) {
            addCriterion("ORIGIN <=", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginLike(String value) {
            addCriterion("ORIGIN like", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginNotLike(String value) {
            addCriterion("ORIGIN not like", value, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginIn(List<String> values) {
            addCriterion("ORIGIN in", values, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginNotIn(List<String> values) {
            addCriterion("ORIGIN not in", values, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginBetween(String value1, String value2) {
            addCriterion("ORIGIN between", value1, value2, "origin");
            return (Criteria) this;
        }

        public Criteria andOriginNotBetween(String value1, String value2) {
            addCriterion("ORIGIN not between", value1, value2, "origin");
            return (Criteria) this;
        }

        public Criteria andSupplierIsNull() {
            addCriterion("SUPPLIER is null");
            return (Criteria) this;
        }

        public Criteria andSupplierIsNotNull() {
            addCriterion("SUPPLIER is not null");
            return (Criteria) this;
        }

        public Criteria andSupplierEqualTo(String value) {
            addCriterion("SUPPLIER =", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierNotEqualTo(String value) {
            addCriterion("SUPPLIER <>", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierGreaterThan(String value) {
            addCriterion("SUPPLIER >", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLIER >=", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierLessThan(String value) {
            addCriterion("SUPPLIER <", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierLessThanOrEqualTo(String value) {
            addCriterion("SUPPLIER <=", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierLike(String value) {
            addCriterion("SUPPLIER like", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierNotLike(String value) {
            addCriterion("SUPPLIER not like", value, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierIn(List<String> values) {
            addCriterion("SUPPLIER in", values, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierNotIn(List<String> values) {
            addCriterion("SUPPLIER not in", values, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierBetween(String value1, String value2) {
            addCriterion("SUPPLIER between", value1, value2, "supplier");
            return (Criteria) this;
        }

        public Criteria andSupplierNotBetween(String value1, String value2) {
            addCriterion("SUPPLIER not between", value1, value2, "supplier");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionIsNull() {
            addCriterion("PUR_AMOUNT_PROPORTION is null");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionIsNotNull() {
            addCriterion("PUR_AMOUNT_PROPORTION is not null");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionEqualTo(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION =", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionNotEqualTo(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION <>", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionGreaterThan(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION >", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION >=", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionLessThan(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION <", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PUR_AMOUNT_PROPORTION <=", value, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionIn(List<BigDecimal> values) {
            addCriterion("PUR_AMOUNT_PROPORTION in", values, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionNotIn(List<BigDecimal> values) {
            addCriterion("PUR_AMOUNT_PROPORTION not in", values, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PUR_AMOUNT_PROPORTION between", value1, value2, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurAmountProportionNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PUR_AMOUNT_PROPORTION not between", value1, value2, "purAmountProportion");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountIsNull() {
            addCriterion("PURCHASE_AMOUNT is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountIsNotNull() {
            addCriterion("PURCHASE_AMOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT =", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountNotEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT <>", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountGreaterThan(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT >", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT >=", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountLessThan(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT <", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_AMOUNT <=", value, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountIn(List<BigDecimal> values) {
            addCriterion("PURCHASE_AMOUNT in", values, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountNotIn(List<BigDecimal> values) {
            addCriterion("PURCHASE_AMOUNT not in", values, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PURCHASE_AMOUNT between", value1, value2, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andPurchaseAmountNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PURCHASE_AMOUNT not between", value1, value2, "purchaseAmount");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNull() {
            addCriterion("START_TIME is null");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNotNull() {
            addCriterion("START_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andStartTimeEqualTo(Date value) {
            addCriterion("START_TIME =", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotEqualTo(Date value) {
            addCriterion("START_TIME <>", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThan(Date value) {
            addCriterion("START_TIME >", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("START_TIME >=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThan(Date value) {
            addCriterion("START_TIME <", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThanOrEqualTo(Date value) {
            addCriterion("START_TIME <=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeIn(List<Date> values) {
            addCriterion("START_TIME in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotIn(List<Date> values) {
            addCriterion("START_TIME not in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeBetween(Date value1, Date value2) {
            addCriterion("START_TIME between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotBetween(Date value1, Date value2) {
            addCriterion("START_TIME not between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andExplainationIsNull() {
            addCriterion("EXPLAINATION is null");
            return (Criteria) this;
        }

        public Criteria andExplainationIsNotNull() {
            addCriterion("EXPLAINATION is not null");
            return (Criteria) this;
        }

        public Criteria andExplainationEqualTo(String value) {
            addCriterion("EXPLAINATION =", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotEqualTo(String value) {
            addCriterion("EXPLAINATION <>", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationGreaterThan(String value) {
            addCriterion("EXPLAINATION >", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationGreaterThanOrEqualTo(String value) {
            addCriterion("EXPLAINATION >=", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLessThan(String value) {
            addCriterion("EXPLAINATION <", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLessThanOrEqualTo(String value) {
            addCriterion("EXPLAINATION <=", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLike(String value) {
            addCriterion("EXPLAINATION like", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotLike(String value) {
            addCriterion("EXPLAINATION not like", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationIn(List<String> values) {
            addCriterion("EXPLAINATION in", values, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotIn(List<String> values) {
            addCriterion("EXPLAINATION not in", values, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationBetween(String value1, String value2) {
            addCriterion("EXPLAINATION between", value1, value2, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotBetween(String value1, String value2) {
            addCriterion("EXPLAINATION not between", value1, value2, "explaination");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNull() {
            addCriterion("FINISH_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNotNull() {
            addCriterion("FINISH_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagEqualTo(Integer value) {
            addCriterion("FINISH_FLAG =", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <>", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThan(Integer value) {
            addCriterion("FINISH_FLAG >", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG >=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThan(Integer value) {
            addCriterion("FINISH_FLAG <", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIn(List<Integer> values) {
            addCriterion("FINISH_FLAG in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotIn(List<Integer> values) {
            addCriterion("FINISH_FLAG not in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG not between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameIsNull() {
            addCriterion("SPECIAL_PROCESS_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameIsNotNull() {
            addCriterion("SPECIAL_PROCESS_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameEqualTo(String value) {
            addCriterion("SPECIAL_PROCESS_NAME =", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameNotEqualTo(String value) {
            addCriterion("SPECIAL_PROCESS_NAME <>", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameGreaterThan(String value) {
            addCriterion("SPECIAL_PROCESS_NAME >", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameGreaterThanOrEqualTo(String value) {
            addCriterion("SPECIAL_PROCESS_NAME >=", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameLessThan(String value) {
            addCriterion("SPECIAL_PROCESS_NAME <", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameLessThanOrEqualTo(String value) {
            addCriterion("SPECIAL_PROCESS_NAME <=", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameLike(String value) {
            addCriterion("SPECIAL_PROCESS_NAME like", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameNotLike(String value) {
            addCriterion("SPECIAL_PROCESS_NAME not like", value, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameIn(List<String> values) {
            addCriterion("SPECIAL_PROCESS_NAME in", values, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameNotIn(List<String> values) {
            addCriterion("SPECIAL_PROCESS_NAME not in", values, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameBetween(String value1, String value2) {
            addCriterion("SPECIAL_PROCESS_NAME between", value1, value2, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andSpecialProcessNameNotBetween(String value1, String value2) {
            addCriterion("SPECIAL_PROCESS_NAME not between", value1, value2, "specialProcessName");
            return (Criteria) this;
        }

        public Criteria andAddressIsNull() {
            addCriterion("ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andAddressIsNotNull() {
            addCriterion("ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andAddressEqualTo(String value) {
            addCriterion("ADDRESS =", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotEqualTo(String value) {
            addCriterion("ADDRESS <>", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressGreaterThan(String value) {
            addCriterion("ADDRESS >", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressGreaterThanOrEqualTo(String value) {
            addCriterion("ADDRESS >=", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLessThan(String value) {
            addCriterion("ADDRESS <", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLessThanOrEqualTo(String value) {
            addCriterion("ADDRESS <=", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLike(String value) {
            addCriterion("ADDRESS like", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotLike(String value) {
            addCriterion("ADDRESS not like", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressIn(List<String> values) {
            addCriterion("ADDRESS in", values, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotIn(List<String> values) {
            addCriterion("ADDRESS not in", values, "address");
            return (Criteria) this;
        }

        public Criteria andAddressBetween(String value1, String value2) {
            addCriterion("ADDRESS between", value1, value2, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotBetween(String value1, String value2) {
            addCriterion("ADDRESS not between", value1, value2, "address");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}