package com.els.base.certification.rawmaterial.service;

import java.util.List;

import com.els.base.certification.rawmaterial.entity.CompanyRawMaterial;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface CompanyRawMaterialService extends BaseService<CompanyRawMaterial, CompanyRawMaterialExample, String> {
	
	/**
	 * 批量添加原材料
     * @param projectId
     * @param supCompany
     * @param purCompany
     * @param rawMaterialList
     */
	Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyRawMaterial> rawMaterialList);

	/**
	 * 删除数据
	 * @param projectId
	 * @param company
	 * @param ids
	 */
	void deleteObjByIds(String projectId, Company company, List<String> ids);

	/**
	 * 是否已经完成资料填写
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
}