package com.els.base.certification.rawmaterial.web.controller;

import java.util.List;
import javax.annotation.Resource;

import com.els.base.certification.common.CompanyFinishFlag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterial;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="供应商准入-主要供应商/原材料")
@Controller
@RequestMapping("companyRawMaterial")
public class CompanyRawMaterialController {
    @Resource
    private CompanyRawMaterialService companyRawMaterialService;
    
    @Resource
	private CompanyService companyService;

//    @ApiOperation(httpMethod="POST", value="创建供应商准入-主要供应商/原材料")
//    @RequestMapping("service/create")
//    @ResponseBody
//    public ResponseResult<String> create(@RequestBody CompanyRawMaterial companyRawMaterial) {
//        this.companyRawMaterialService.addObj(companyRawMaterial);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="编辑供应商准入-主要供应商/原材料")
//    @RequestMapping("service/edit")
//    @ResponseBody
//    public ResponseResult<String> edit(@RequestBody CompanyRawMaterial companyRawMaterial) {
//        if (StringUtils.isBlank(companyRawMaterial.getId())) {
//            throw new CommonException("id 为空，保存失败");
//        }
//        this.companyRawMaterialService.modifyObj(companyRawMaterial);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="删除供应商准入-主要供应商/原材料")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
//        if (StringUtils.isBlank(id)) {
//            throw new CommonException("删除失败,id不能为空");
//        }
//        this.companyRawMaterialService.deleteObjById(id);
//        return ResponseResult.success();
//    }
//    
    @ApiOperation(httpMethod="POST", value="创建供应商准入-主要供应商/原材料")
    @RequestMapping("service/batchInsert")
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> batchInsert(@RequestBody List<CompanyRawMaterial> rawMaterialList) {
    	if(CollectionUtils.isEmpty(rawMaterialList)){
    		throw new CommonException("操作失败，数据不能为空!");
    	}
    	Company purCompany = this.getDefaultCompany();
    	Integer rawMaterialStatus= this.companyRawMaterialService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),
        		purCompany,  rawMaterialList);
        CompanyFinishFlag companyFinishFlag =new CompanyFinishFlag();
        companyFinishFlag.setMainSupOrMaterials(rawMaterialStatus);
    	return ResponseResult.success(companyFinishFlag);
    }
    
  @ApiOperation(httpMethod="POST", value="删除供应商准入-主要供应商/原材料")
  @RequestMapping("service/deleteByIds")
  @ResponseBody
  public ResponseResult<String> deleteByIds(@RequestParam(required=true) List<String> ids) {
	  if(CollectionUtils.isEmpty(ids)){
      	throw new CommonException("传递的id列表为空!");
      }
	  this.companyRawMaterialService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),  ids);
	  return ResponseResult.success();
  }
    

    @ApiOperation(httpMethod="POST", value="查询供应商准入-主要供应商/原材料")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
	 @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
	 @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
	 @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyRawMaterial", paramType = "body", dataType = "QueryParamWapper" )  
}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyRawMaterial>> findByPage(
            @RequestParam(required=false) String supCompanySrmCode,
             @RequestParam(defaultValue="0") int pageNo,
             @RequestParam(defaultValue="10") int pageSize,
             @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyRawMaterialExample example = new CompanyRawMaterialExample();
        example.setPageView(new PageView<CompanyRawMaterial>(pageNo, pageSize));
        
        CompanyRawMaterialExample.Criteria criteria = example.createCriteria();
       /* criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
			    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
			    .andIsEnableEqualTo(Constant.YES_INT);*/

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }


        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyRawMaterial> pageData = this.companyRawMaterialService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查询全部")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyPatents", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<CompanyRawMaterial>> findAll(
                     @RequestParam(required=false) String supCompanySrmCode,
    				@RequestBody(required=false) QueryParamWapper wapper) {
    	CompanyRawMaterialExample example = new CompanyRawMaterialExample();
        
        CompanyRawMaterialExample.Criteria criteria = example.createCriteria();
        /*criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
			    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
			    .andIsEnableEqualTo(Constant.YES_INT);*/

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        List<CompanyRawMaterial> list = this.companyRawMaterialService.queryAllObjByExample(example);
        return ResponseResult.success(list);
    }
    
    /**
	 * 获取华阳的编码
	 * @return
	 */
	private Company getDefaultCompany(){
		CompanyExample companyExample = new CompanyExample();
		CompanyExample.Criteria companyCriteria = companyExample.createCriteria();
		companyCriteria.andCompanyCodeEqualTo("50000000");
		List<Company> tempCompanyList = companyService.queryAllObjByExample(companyExample);
		if (CollectionUtils.isEmpty(tempCompanyList)) {
			throw new CommonException("找不到华阳的企业信息");
		}
		return tempCompanyList.get(0);
	}
}