package com.els.base.certification.recommend.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.els.base.certification.contacts.entity.Contacts;

@ApiModel(value="供应商准入-合格供应商导入推荐表")
public class CompanyRecommendForm implements Serializable {
    //########手动添加请勿覆盖##########
	@ApiModelProperty("供应商基础资料联系人信息")
	List<Contacts> contactsList;
	
	public List<Contacts> getContactsList() {
		return contactsList;
	}

	public void setContactsList(List<Contacts> contactsList) {
		this.contactsList = contactsList;
	}

	//##################
	@ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("采购公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购商公司全称")
    private String purCompanyFullName;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商SAP编码")
    private String purCompanySapCode;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商地址")
    private String supCompanyAddress;

    @ApiModelProperty("供应商生产地址")
    private String supCompanyProductionAddress;

    @ApiModelProperty("供应商主要联系人")
    private String supCompanyContacts;

    @ApiModelProperty("供应商类型")
    private String supCompanyType;

    @ApiModelProperty("供应商简介")
    private String supCompanyIntroduction;

    @ApiModelProperty("供应商物料编码")
    private String supMaterialCode;

    @ApiModelProperty("供应商物料描述")
    private String supMaterialDesc;

    @ApiModelProperty("推荐理由编码")
    private String recommendedReasonCode;

    @ApiModelProperty("推荐理由编码")
    private String recommendedReasonDesc;

    @ApiModelProperty("需求来源")
    private String demandSources;

    @ApiModelProperty("合格供应商导入推荐表单号")
    private String recommendNo;

    @ApiModelProperty("制单人")
    private String createBillName;

    @ApiModelProperty("单据状态")
    private Integer confirmStatus;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("发送状态（0=未发送，1=已发送）")
    private Integer sendStatus;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("审核时间")
    private Date approveTime;

    @ApiModelProperty("审核结果(审批流返回的结果)")
    private String approveResult;

    @ApiModelProperty("审核人")
    private String approveUserName;

    @ApiModelProperty("审核状态(0=未审核，1=待审核，2已审核)")
    private Integer approveStatus;

    @ApiModelProperty("审核结果及后续行动或审核豁免申请陈述(用户填写的)")
    private String approveReport;

    @ApiModelProperty("当前审批人")
    private String currentApprover;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyFullName() {
        return purCompanyFullName;
    }

    public void setPurCompanyFullName(String purCompanyFullName) {
        this.purCompanyFullName = purCompanyFullName == null ? null : purCompanyFullName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyAddress() {
        return supCompanyAddress;
    }

    public void setSupCompanyAddress(String supCompanyAddress) {
        this.supCompanyAddress = supCompanyAddress == null ? null : supCompanyAddress.trim();
    }

    public String getSupCompanyProductionAddress() {
        return supCompanyProductionAddress;
    }

    public void setSupCompanyProductionAddress(String supCompanyProductionAddress) {
        this.supCompanyProductionAddress = supCompanyProductionAddress == null ? null : supCompanyProductionAddress.trim();
    }

    public String getSupCompanyContacts() {
        return supCompanyContacts;
    }

    public void setSupCompanyContacts(String supCompanyContacts) {
        this.supCompanyContacts = supCompanyContacts == null ? null : supCompanyContacts.trim();
    }

    public String getSupCompanyType() {
        return supCompanyType;
    }

    public void setSupCompanyType(String supCompanyType) {
        this.supCompanyType = supCompanyType == null ? null : supCompanyType.trim();
    }

    public String getSupCompanyIntroduction() {
        return supCompanyIntroduction;
    }

    public void setSupCompanyIntroduction(String supCompanyIntroduction) {
        this.supCompanyIntroduction = supCompanyIntroduction == null ? null : supCompanyIntroduction.trim();
    }

    public String getSupMaterialCode() {
        return supMaterialCode;
    }

    public void setSupMaterialCode(String supMaterialCode) {
        this.supMaterialCode = supMaterialCode == null ? null : supMaterialCode.trim();
    }

    public String getSupMaterialDesc() {
        return supMaterialDesc;
    }

    public void setSupMaterialDesc(String supMaterialDesc) {
        this.supMaterialDesc = supMaterialDesc == null ? null : supMaterialDesc.trim();
    }

    public String getRecommendedReasonCode() {
        return recommendedReasonCode;
    }

    public void setRecommendedReasonCode(String recommendedReasonCode) {
        this.recommendedReasonCode = recommendedReasonCode == null ? null : recommendedReasonCode.trim();
    }

    public String getRecommendedReasonDesc() {
        return recommendedReasonDesc;
    }

    public void setRecommendedReasonDesc(String recommendedReasonDesc) {
        this.recommendedReasonDesc = recommendedReasonDesc == null ? null : recommendedReasonDesc.trim();
    }

    public String getDemandSources() {
        return demandSources;
    }

    public void setDemandSources(String demandSources) {
        this.demandSources = demandSources == null ? null : demandSources.trim();
    }

    public String getRecommendNo() {
        return recommendNo;
    }

    public void setRecommendNo(String recommendNo) {
        this.recommendNo = recommendNo == null ? null : recommendNo.trim();
    }

    public String getCreateBillName() {
        return createBillName;
    }

    public void setCreateBillName(String createBillName) {
        this.createBillName = createBillName == null ? null : createBillName.trim();
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSendStatus() {
        return sendStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult == null ? null : approveResult.trim();
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName == null ? null : approveUserName.trim();
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public String getApproveReport() {
        return approveReport;
    }

    public void setApproveReport(String approveReport) {
        this.approveReport = approveReport == null ? null : approveReport.trim();
    }

    public String getCurrentApprover() {
        return currentApprover;
    }

    public void setCurrentApprover(String currentApprover) {
        this.currentApprover = currentApprover == null ? null : currentApprover.trim();
    }
}