package com.els.base.certification.recommend.service;

import com.els.base.auth.entity.User;
import com.els.base.certification.recommend.entity.CompanyRecommendForm;
import com.els.base.certification.recommend.entity.CompanyRecommendFormExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;

import java.util.List;

public interface CompanyRecommendFormService extends BaseService<CompanyRecommendForm, CompanyRecommendFormExample, String> {

    /**
     * 创建供应商准入-合格供应商导入推荐表
     * @param projectId
     * @param company
     * @param loginUser
     * @param companyRecommendForm
     */
    void insert(String projectId, Company company, User loginUser, CompanyRecommendForm companyRecommendForm);

    /**
     * 供应商准入-批量删除合格供应商导入推荐表
     * @param project
     * @param company
     * @param companyRecommendFormList
     */
    void deleteObjByIds(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList);

    /**
     * 供应商准入--批量作废合格供应商导入推荐表
     * @param project
     * @param company
     * @param companyRecommendFormList
     */
    void abolish(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList);

    /**
     * 供应商准入--发送审核
     * @param project
     * @param company
     * @param loginUser
     * @param companyRecommendFormList
     */
    void sendApprove(Project project, Company company, User loginUser, List<CompanyRecommendForm> companyRecommendFormList);

    /**
     * 供应商准入-审核通过
     * @param project
     * @param company
     * @param loginUser
     * @param ids
     */
    void approve(Project project, Company company, User loginUser, List<CompanyRecommendForm> ids);

    /**
     * 供应商准入-审核驳回
     * @param project
     * @param company
     * @param companyRecommendFormList
     */
    void reject(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList);

    /**
     * 供应商准入-合格供应商导入推荐表-打印
     * @param project
     * @param company
     * @param companyRecommendFormList
     * @return
     */
    FileData print(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList);
}