package com.els.base.certification.recommend.service.impl;

import com.els.base.auth.entity.*;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.common.DocumentStatusEnum;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.recommend.dao.CompanyRecommendFormMapper;
import com.els.base.certification.recommend.entity.CompanyRecommendForm;
import com.els.base.certification.recommend.entity.CompanyRecommendFormExample;
import com.els.base.certification.recommend.service.CompanyRecommendFormService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.*;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.utils.FileDataUtils;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;

@Service("defaultCompanyRecommendFormService")
public class CompanyRecommendFormServiceImpl implements CompanyRecommendFormService,ITaskListener {

    @Resource
    private CompanyRecommendFormMapper companyRecommendFormMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private RoleService roleService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private ContactsService contactsService;
    

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public FileData print(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {

        //1.校验数据,并返回ID数据
        List<String> ids= this.checkRecommendFormData(companyRecommendFormList);

        //2.拿到需要打印的数据
        List<CompanyRecommendForm> printDataList=this.findByCompanyRecommendFormIds(ids);

        //3.打印PDF，获取PDF数据，并传回来
        FileData fileData = null;
        try {
            fileData = this.printCompanyRecommendForm(project,company,printDataList);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("打印失败！");
        } catch (InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("打印失败！");
        }
        return fileData;
    }

    /**
     * 供应商准入-合格供应商导入推荐表-打印数据
     *
     * @param project
     * @param company
     *@param printDataList  @return
     */
    private FileData printCompanyRecommendForm(Project project, Company company, List<CompanyRecommendForm> printDataList)
            throws IOException, InterruptedException {

        Assert.isNotEmpty(printDataList,"打印数据不能为空，操作失败！");

        Map<String,Object> params=new HashMap<String,Object>();
        params.put("printDataList", printDataList);

        //1.根据模版生成html
        String html = BeetlTemplateUtils.renderFromFile("company_recommend_form.html", params);

        //2.生成文件名
        String fileName = "合格供应商导入表_A4_" + DateFormatUtils.format(new Date(), "yyyy-MM-dd-HH-mm");

        //3.生成pdf文件
        FileData fileData = FileDataUtils.createTempEmptyPDF(project.getId(), company.getId(), fileName);

        //4.根据html 生成pdf，并写入pdf文件里面
        HtmlToPdfUtils.generatePdf(html, fileData.toFile(), HtmlToPdfUtils.PAGE_SIZE_A4, false, fileName);
        return fileData;

    }

    /**
     * 供应商准入-合格供应商导入推荐表-查询打印数据
     * @param ids
     * @return
     */
    private List<CompanyRecommendForm> findByCompanyRecommendFormIds(List<String> ids) {
        Assert.isNotEmpty(ids,"Id不能为空，操作失败！");
        CompanyRecommendFormExample companyRecommendFormExample=new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn(ids);
        List<CompanyRecommendForm> printDataList=this.companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        //获取供应商ID查询供应商基础资料联系人信息
        for(CompanyRecommendForm f : printDataList){
        	ContactsExample contactsExample=new ContactsExample();
        	contactsExample.createCriteria().andSupCompanyIdEqualTo(f.getSupCompanyId());
        	List<Contacts> contactsList=this.contactsService.queryAllObjByExample(contactsExample);
        	f.setContactsList(contactsList);
        }
        return printDataList;
    }

    /**
     * 供应商准入-合格供应商导入推荐表-校验打印数据
     * @param companyRecommendFormList
     * @return
     */
    private List<String> checkRecommendFormData(List<CompanyRecommendForm> companyRecommendFormList) {
        List<String> ids =new ArrayList<>();
        Assert.isNotEmpty(companyRecommendFormList,"打印数据列表不能为空，操作失败！");
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            Assert.isNotBlank(companyRecommendForm.getId(),"Id不能为空，操作失败！");
            ids.add(companyRecommendForm.getId());
        }
        return ids;

    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void listen(TaskOperateEvent event) {

        if(event==null){
           return;
        }

        //获取业务ID
        String businessId = event.getBusinessId();
        if(StringUtils.isBlank(businessId)){
            return;
        }
        CompanyRecommendForm companyRecommendForm = companyRecommendFormMapper.selectByPrimaryKey(businessId);
        String assignee = event.getAssignee();
        String fullMessage = event.getApproveDesc();

        //1、审批流完成而且通过
        if (event.isFinished() && event.isPass()) {
            //做修改业务操作
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank(companyRecommendForm.getApproveUserName(),"")+"\n"+assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);

            //审核通过修改供应商角色
            this.switchQualifiedRole(companyRecommendForm.getSupCompanyId());

        //2、审批流完成但被驳回
        }else if(event.isFinished() && !event.isPass()){
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank(companyRecommendForm.getApproveUserName(),"")+"\n"+assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);

        }else{
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank(companyRecommendForm.getApproveUserName(),"")+"\n"+assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);
        }

    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void approve(Project project, Company company, User loginUser, List<CompanyRecommendForm> companyRecommendFormList) {

        //1.校验数据
        this.checkRecommendFormData(project, companyRecommendFormList);

        //2.提交审核，开启审批流
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            ProcessStartVO vo=ProcessStartVO.newInstance("hggysdrtjb", companyRecommendForm.getRecommendNo(), companyRecommendForm.getId(),"qualifiedSupIntroduct?id="+companyRecommendForm.getId());
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess=this.workFlowService.startProcess(vo);
            if(startProcess!=null){
                //成功加入审批流
                CompanyRecommendForm companyRecommendForm1 = new CompanyRecommendForm();
                companyRecommendForm1.setId(companyRecommendForm.getId());
                companyRecommendForm1.setApproveStatus(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()));
                companyRecommendForm1.setApproveTime(new Date());
                this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm1);
            }
        }

    }

    /**
     * 通过审核
     * @param loginUser
     * @param companyRecommendFormList
     */
   /* private void updateRecommendForm(User loginUser, List<CompanyRecommendForm> companyRecommendFormList) {
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
            companyRecommendForm.setApproveUserName(loginUser.getNickName());
            companyRecommendForm.setApproveTime(new Date());

            //更新审核状态
            this.companyRecommendFormMapper.updateByPrimaryKey(companyRecommendForm);

            //更新角色
            this.switchQualifiedRole(companyRecommendForm.getSupCompanyId());
        }

    }*/


    /**
     * 校验数据
     * @param project
     * @param companyRecommendFormList
     */
    private void checkRecommendFormData(Project project, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        List<String> ids=new ArrayList<>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if(StringUtils.isBlank(companyRecommendForm.getId())){
                throw new CommonException("数据ID不能为空", "base_canot_be_null", "操作失败，数据ID");
            }

            if(StringUtils.isBlank(companyRecommendForm.getSupCompanyId())){
                throw new CommonException("供应商ID不能为空", "base_canot_be_null", "操作失败，供应商ID");
            }

            ids.add(companyRecommendForm.getId());
        }

        //未审核的不允许进行审核，已审核的也不允许再审核，已驳回的不允许再次通过
        List<Integer> list=new ArrayList<>();
        //list.add(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));

        CompanyRecommendFormExample companyRecommendFormExample =new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusIn(list)
                .andProjectIdEqualTo(project.getId());

        int count=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count>0){
            throw new CommonException("单据中包含已驳回或者已经审核通过的数据，请检查!");
        }
    }

    /**
     * 转换角色
     */
    private void switchQualifiedRole(String companyId) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyService.updatePartnerRole(companyPartner, example);

        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria()
                .andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());

        List<Role> list = roleService.queryAllObjByExample(roleExample);
        if (CollectionUtils.isNotEmpty(list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
            List<CompanyUserRef> companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(companyUserRef.get(0).getUserId());
            List<UserRole> userRole = this.userRoleService.queryAllObjByExample(userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj(ur);
                }
            }
        }
    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void reject(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {

        //校验数据
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        List<String> ids =new ArrayList<>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if(StringUtils.isBlank(companyRecommendForm.getId())){
                throw new CommonException("数据ID不能为空", "base_canot_be_null", "操作失败，数据ID");
            }
            ids.add(companyRecommendForm.getId());
        }

        //未审核的不允许驳回，已审核的也不允许再拒绝，已驳回的不允许再次驳回
        List<Integer> list=new ArrayList<>();
        list.add(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));

        CompanyRecommendFormExample companyRecommendFormExample =new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusIn(list)
                .andProjectIdEqualTo(project.getId());

        int count=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count>0){
            throw new CommonException("单据中包含未提交审核、已驳回或者已经审核通过的数据，请检查!");
        }

        //更新为正在审核状态的数据为驳回
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusEqualTo(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()))
                .andProjectIdEqualTo(project.getId());

        CompanyRecommendForm companyRecommendForm =new CompanyRecommendForm();
        companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm,companyRecommendFormExample);

    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void sendApprove(Project project, Company company, User loginUser, List<CompanyRecommendForm> companyRecommendFormList) {

        //校验数据
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        List<String> ids =new ArrayList<>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if(StringUtils.isBlank(companyRecommendForm.getId())){
                throw new CommonException("数据ID不能为空", "base_canot_be_null", "操作失败，数据ID");
            }
            ids.add(companyRecommendForm.getId());
        }

        //已经作废的不允许再提交审核
        CompanyRecommendFormExample companyRecommendFormExample =new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_ABOLISH.getStatus())
                .andProjectIdEqualTo(project.getId());

        int count=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count>0){
            throw new CommonException("单据中包含已作废数据，不能再操作!");
        }

        //正在审核的或者已经审核的，不允许再提交审核
        List<Integer> theseElements=new ArrayList<>();
        theseElements.add(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode())) ;
        theseElements.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        theseElements.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));

        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusIn(theseElements)
                .andProjectIdEqualTo(project.getId());

        int count2=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count2>0){
            throw new CommonException("单据中包含正在审核或者已审核,已驳回的数据，不能再操作!");
        }

        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids);
        List<CompanyRecommendForm> companyRecommendForms = companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        Assert.isNotEmpty(companyRecommendForms,"审核数据不存在");
        //现在默认改为正在审批状态
        this.approve(project, company,loginUser ,companyRecommendForms);

    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void abolish(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {

        //校验数据
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        List<String> ids =new ArrayList<>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if(StringUtils.isBlank(companyRecommendForm.getId())){
                throw new CommonException("数据ID不能为空", "base_canot_be_null", "操作失败，数据ID");
            }
            ids.add(companyRecommendForm.getId());
        }

        CompanyRecommendFormExample companyRecommendFormExample =new CompanyRecommendFormExample();

        List<Integer> list =new ArrayList<>();
        list.add(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));

        //未审核的，已审核通过的不允许作废
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusIn(list)
                .andProjectIdEqualTo(project.getId());
        int count2=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count2>0){
            throw new CommonException("单据中包含未审核或者已审核或者已驳回的数据，操作失败!");
        }

        //已作废的也不允许再次操作
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_ABOLISH.getStatus())
                .andProjectIdEqualTo(project.getId());
        int count=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count>0){
            throw new CommonException("单据中包含已作废数据，操作失败!");
        }

        //作废数据
        CompanyRecommendForm companyRecommendForm =new CompanyRecommendForm();
        companyRecommendForm.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andProjectIdEqualTo(project.getId());
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm,companyRecommendFormExample);

        //关闭审批流
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids);
        List<CompanyRecommendForm> companyRecommendForms = this.companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        for (CompanyRecommendForm recommendForm : companyRecommendForms) {
           this.workFlowService.stopProcess("hggysdrtjb",recommendForm.getRecommendNo());
        }


    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {
        //校验数据
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        List<String> ids=new ArrayList<>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if(StringUtils.isBlank(companyRecommendForm.getId())){
                throw new CommonException("数据ID不能为空", "base_canot_be_null", "操作失败，数据ID");
            }
            ids.add(companyRecommendForm.getId());
        }

        List<Integer> list =new ArrayList<>();
        list.add(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));

        CompanyRecommendFormExample companyRecommendFormExample =new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andApproveStatusIn(list)
                .andProjectIdEqualTo(project.getId());

        int count=this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if(count>0){
            throw new CommonException("只能删除未审核状态的单据，请检查，谢谢!");
        }

        CompanyRecommendForm companyRecommendForm =new CompanyRecommendForm();
        companyRecommendForm.setIsEnable(Constant.NO_INT);

        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andProjectIdEqualTo(project.getId());
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm,companyRecommendFormExample);
    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    @Override
    public void insert(String projectId, Company company, User user, CompanyRecommendForm companyRecommendForm) {

        //校验数据
        if (companyRecommendForm==null) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        //设置供应商条件
        setSupCompanyInfo(ProjectUtils.getProject(),companyRecommendForm);

        //设置采购基本信息
        setPurCompanyInfo(company, companyRecommendForm);

        //设置单据信息
        setCompanyRecommendForm(ProjectUtils.getProject(),user, companyRecommendForm);

        if(StringUtils.isEmpty(companyRecommendForm.getId())){
            this.companyRecommendFormMapper.insertSelective(companyRecommendForm);
        }else{
            this.companyRecommendFormMapper.updateByPrimaryKey(companyRecommendForm);
        }

    }

    /**
     * 设置供应商推荐表
     * @param project
     * @param user
     * @param companyRecommendForm
     */
    private void setCompanyRecommendForm(Project project, User user, CompanyRecommendForm companyRecommendForm) {
        companyRecommendForm.setProjectId(project.getId());
        companyRecommendForm.setCreateBillName(user.getNickName());
        companyRecommendForm.setCreateTime(new Date());
        String auditNoticeNo=generateCodeService.getNextCode("RECOMMEND_NO");
        companyRecommendForm.setRecommendNo(auditNoticeNo);

        //可用状态
        companyRecommendForm.setIsEnable(Constant.YES_INT);
        //发送状态
        //companyRecommendForm.setSendStatus(Constant.NO_INT);
        //确认状态:默认为已确认
        companyRecommendForm.setConfirmStatus(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        //审批状态
        companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
    }

    /**
     * 设置采购商信息
     * @param company
     * @param companyRecommendForm
     */
    private void setPurCompanyInfo(Company company, CompanyRecommendForm companyRecommendForm) {
        companyRecommendForm.setPurCompanyId(company.getId());
        companyRecommendForm.setPurCompanyName(company.getCompanyName());
        companyRecommendForm.setPurCompanyFullName(company.getCompanyFullName());
        companyRecommendForm.setPurCompanySrmCode(company.getCompanyCode());
        companyRecommendForm.setPurCompanySapCode(company.getCompanySapCode());
    }

    /**
     * 设置供应商基本信息
     * @param project
     * @param companyRecommendForm
     */
    private void setSupCompanyInfo(Project project, CompanyRecommendForm companyRecommendForm) {
        if(StringUtils.isEmpty(companyRecommendForm.getSupCompanySrmCode())){
            throw new CommonException("供应商编码不能为空", "base_canot_be_null", "供应商SRM编码");
        }
        CompanyExample companyExample =new CompanyExample();
        companyExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andCompanyCodeEqualTo(companyRecommendForm.getSupCompanySrmCode());

        PageView<Company> companyPageView = companyService.querySupplerCompanies(project.getCompanyId(), companyExample, PartnerRoleEnum.POTENIAL.getCode());
        List<Company> queryResult = companyPageView.getQueryResult();
        if(CollectionUtils.isEmpty(queryResult)){
            throw new CommonException("潜在供应商不存在", "do_not_exists", "潜在供应商");
        }
        Company superCompany = queryResult.get(0);
        companyRecommendForm.setSupCompanyId(superCompany.getId());
        companyRecommendForm.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyRecommendForm.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyRecommendForm.setSupCompanyName(superCompany.getCompanyName());
        companyRecommendForm.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyRecommendForm.setSupCompanyAddress(superCompany.getAddress());
        companyRecommendForm.setSupCompanyProductionAddress(superCompany.getProductionAddress());

    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Override
    public void addObj(CompanyRecommendForm t) {
        this.companyRecommendFormMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyRecommendFormMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Override
    public void modifyObj(CompanyRecommendForm t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyRecommendFormMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyRecommendForm", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyRecommendForm queryObjById(String id) {
    	
        return this.companyRecommendFormMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyRecommendForm", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyRecommendForm> queryAllObjByExample(CompanyRecommendFormExample example) {
        return this.companyRecommendFormMapper.selectByExample(example);
    }

    @Cacheable(value="companyRecommendForm", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyRecommendForm> queryObjByPage(CompanyRecommendFormExample example) {
        PageView<CompanyRecommendForm> pageView = example.getPageView();
        List<CompanyRecommendForm> formList=this.companyRecommendFormMapper.selectByExampleByPage(example);
        for(CompanyRecommendForm f : formList){
        	ContactsExample contactsExample=new ContactsExample();
        	contactsExample.createCriteria().andSupCompanyIdEqualTo(f.getSupCompanyId());
        	List<Contacts> c=this.contactsService.queryAllObjByExample(contactsExample);
        	f.setContactsList(c);
        }
        pageView.setQueryResult(formList);
        return pageView;
    }
}