package com.els.base.certification.recommend.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.recommend.entity.CompanyRecommendForm;
import com.els.base.certification.recommend.entity.CompanyRecommendFormExample;
import com.els.base.certification.recommend.service.CompanyRecommendFormService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

@Api(value="供应商准入-合格供应商导入推荐表")
@Controller
@RequestMapping("companyRecommendForm")
public class CompanyRecommendFormController {

    @Resource
    private CompanyRecommendFormService companyRecommendFormService;


    @ApiOperation(httpMethod="POST", value="供应商准入-合格供应商导入推荐表-打印")
    @RequestMapping("service/print")
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        Assert.isNotEmpty(companyRecommendFormList,"数据列表不能为空,操作失败！");
        FileData fileData= this.companyRecommendFormService.print(ProjectUtils.getProject(),CompanyUtils.currentCompany(),companyRecommendFormList);
        return ResponseResult.success(fileData);
    }


    @ApiOperation(httpMethod="POST", value="根据id查询合格供应商导入推荐表详情")
    @RequestMapping("service/findDetailById")
    @ResponseBody
    public ResponseResult<CompanyRecommendForm> findDetailById(@RequestParam(required = true) String id){
        Assert.isNotBlank(id,"ID不能为空");
        CompanyRecommendForm companyRecommendForm= this.companyRecommendFormService.queryObjById(id);
        return ResponseResult.success(companyRecommendForm);
    }

    @ApiOperation(httpMethod="POST", value="供应商准入--审核驳回")
    @RequestMapping("service/reject")
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyRecommendFormService.reject(ProjectUtils.getProject(),CompanyUtils.currentCompany(),companyRecommendFormList);
        return ResponseResult.success();
    }

   /* @ApiOperation(httpMethod="POST", value="供应商准入--审核通过")
    @RequestMapping("service/approve")
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyRecommendFormService.approve(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),companyRecommendFormList);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="供应商准入--发送审核")
    @RequestMapping("service/sendApprove")
    @ResponseBody
    public ResponseResult<String> sendApprove(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("操作失败,id不能为空");
        }
        this.companyRecommendFormService.sendApprove(ProjectUtils.getProject(),CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="供应商准入--批量作废合格供应商导入推荐表")
    @RequestMapping("service/abolish")
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("作废失败,id不能为空");
        }
        this.companyRecommendFormService.abolish(ProjectUtils.getProject(),CompanyUtils.currentCompany(),companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="创建供应商准入-合格供应商导入推荐表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyRecommendForm companyRecommendForm) {
        if (companyRecommendForm==null) {
            throw new CommonException("合格供应商导入推荐表为空，保存失败");
        }
        this.companyRecommendFormService.insert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(),companyRecommendForm);
        return ResponseResult.success();
    }

   /* @ApiOperation(httpMethod="POST", value="编辑供应商准入-合格供应商导入推荐表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyRecommendForm companyRecommendForm) {
        if (StringUtils.isBlank(companyRecommendForm.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.companyRecommendFormService.modifyObj(companyRecommendForm);
        return ResponseResult.success();
    }*/

    @ApiOperation(httpMethod="POST", value="供应商准入-批量删除合格供应商导入推荐表")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyRecommendFormService.deleteObjByIds(ProjectUtils.getProject(),CompanyUtils.currentCompany(),companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-合格供应商导入推荐表")
    @ApiImplicitParams({ 
         @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
         @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
         @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyRecommendForm", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyRecommendForm>> findByPage( 
         @RequestParam(defaultValue="0") int pageNo,
         @RequestParam(defaultValue="10") int pageSize,
         @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyRecommendFormExample example = new CompanyRecommendFormExample();
        example.setPageView(new PageView<CompanyRecommendForm>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyRecommendFormExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyRecommendForm> pageData = this.companyRecommendFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}