package com.els.base.certification.relation.service;

import com.els.base.certification.relation.entity.CompanySupplyRelation;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanySupplyRelationService extends BaseService<CompanySupplyRelation, CompanySupplyRelationExample, String> {

    /**
     * 软删除
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 批量添加
     * @param projectId
     * @param company
     * @param companySupplyRelationList
     */
    Integer batchInsert(String projectId, Company company, List<CompanySupplyRelation> companySupplyRelationList);

    /**
     * 判断资料是否已经填写完成
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}