package com.els.base.certification.relation.service.impl;

import com.els.base.certification.relation.dao.CompanySupplyRelationMapper;
import com.els.base.certification.relation.entity.CompanySupplyRelation;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanySupplyRelationService")
public class CompanySupplyRelationServiceImpl implements CompanySupplyRelationService {

    @Resource
    private CompanySupplyRelationMapper companySupplyRelationMapper;


    @Cacheable(value="companySupplyRelation", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {

        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanySupplyRelationExample companySupplyRelationExample =new CompanySupplyRelationExample();

        //如果数据为空，那么返回0
        companySupplyRelationExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companySupplyRelationMapper.countByExample(companySupplyRelationExample);
        if(count<=0){
            return 0;
        }

        companySupplyRelationExample.clear();
        companySupplyRelationExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companySupplyRelationMapper.countByExample(companySupplyRelationExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Transactional
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanySupplyRelation> companySupplyRelationList) {
        if (CollectionUtils.isEmpty(companySupplyRelationList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        //软删除原来的数据
        CompanySupplyRelationExample companySupplyRelationExample =new CompanySupplyRelationExample();
        companySupplyRelationExample
                .createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);

        CompanySupplyRelation companySupplyRelation =new CompanySupplyRelation();
        companySupplyRelation.setIsEnable(Constant.NO_INT);

        this.companySupplyRelationMapper.updateByExampleSelective(companySupplyRelation,companySupplyRelationExample);

        List<Integer> list = new ArrayList<Integer>();
        //插入新的数据
        for (CompanySupplyRelation supplyRelation : companySupplyRelationList) {
            supplyRelation.setId(null);
            supplyRelation.setProjectId(projectId);
            supplyRelation.setSupCompanyId(company.getId());
            supplyRelation.setIsEnable(Constant.YES_INT);
            supplyRelation.setCreateTime(new Date());
            supplyRelation.setUpdateTime(new Date());

            Integer finishFlag = supplyRelation.getFinishFlag();
            supplyRelation.setFinishFlag(finishFlag);
            this.companySupplyRelationMapper.insertSelective(supplyRelation);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanySupplyRelationExample companySupplyRelationExample=new CompanySupplyRelationExample();
        companySupplyRelationExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andIdIn(ids);
        CompanySupplyRelation companySupplyRelation=new CompanySupplyRelation();
        companySupplyRelation.setIsEnable(Constant.NO_INT);

        this.companySupplyRelationMapper.updateByExampleSelective(companySupplyRelation,companySupplyRelationExample);
    }

    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Override
    public void addObj(CompanySupplyRelation t) {
        this.companySupplyRelationMapper.insertSelective(t);
    }

    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companySupplyRelationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Override
    public void modifyObj(CompanySupplyRelation t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companySupplyRelationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companySupplyRelation", keyGenerator="redisKeyGenerator")
    @Override
    public CompanySupplyRelation queryObjById(String id) {
        return this.companySupplyRelationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companySupplyRelation", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanySupplyRelation> queryAllObjByExample(CompanySupplyRelationExample example) {
        return this.companySupplyRelationMapper.selectByExample(example);
    }

    @Cacheable(value="companySupplyRelation", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanySupplyRelation> queryObjByPage(CompanySupplyRelationExample example) {
        PageView<CompanySupplyRelation> pageView = example.getPageView();
        pageView.setQueryResult(this.companySupplyRelationMapper.selectByExampleByPage(example));
        return pageView;
    }
}