package com.els.base.certification.remind.web.controller;

import com.els.base.certification.process.util.ExcelFileData;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WriteException;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商准入-到期提醒供应商信息")
@Controller
@RequestMapping("remindInfo")
public class RemindInfoController {
    @Resource
    protected RemindInfoService remindInfoService;

    @ApiOperation(httpMethod="POST", value="创建供应商准入-到期提醒供应商信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody RemindInfo remindInfo) {
        this.remindInfoService.addObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商准入-到期提醒供应商信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody RemindInfo remindInfo) {
        Assert.isNotBlank(remindInfo.getId(), "id 为空，保存失败");
        this.remindInfoService.modifyObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商准入-到期提醒供应商信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.remindInfoService.deleteObjById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商批量确认单据供应商准入-到期提醒供应商信息")
    @RequestMapping("service/batchByIds")
    @ResponseBody
    public ResponseResult<String> batchByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, "确认失败,id不能为空");
        this.remindInfoService.batchObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="采购商查询供应商准入-到期提醒供应商信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 RemindInfo", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/purFindByPage")
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> purFindByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView(new PageView<RemindInfo>(pageNo, pageSize));
        example.setOrderByClause("SUP_COMPANY_SRM_CODE DESC ");
        
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
//        criteria.andEndTimeGreaterThanOrEqualTo(new Date());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<RemindInfo> pageData = this.remindInfoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="供应商查询供应商准入-到期提醒供应商信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 RemindInfo", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/supFindByPage")
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> supFindByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView(new PageView<RemindInfo>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME ASC");
        
        RemindInfoExample.Criteria criteria = example.createCriteria();
//        criteria.andEndTimeGreaterThanOrEqualTo(new Date())
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
        		.andIsEnableEqualTo(Constant.YES_INT);
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<RemindInfo> pageData = this.remindInfoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="供应商准入-到期提醒供应商信息导出Excel")
    @RequestMapping("service/downloadExcelForPur")
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForPur(@RequestBody Map<String,Object> queryMap) 
    		throws JsonParseException, JsonMappingException, IOException, WriteException, ParseException {
		// 查询条件
    	String queryParams = (String) queryMap.get("queryParams");
    	// 单据ID
    	String ids = (String) queryMap.get("ids");
    	RemindInfoExample example = new RemindInfoExample();
    	example.setOrderByClause("SUP_COMPANY_SRM_CODE DESC ");
		RemindInfoExample.Criteria criteria = example.createCriteria();
		criteria.andIsEnableEqualTo(Constant.YES_INT);
		if (StringUtils.isNotEmpty(queryParams)) {
            QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                    QueryParamWapper.class);
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
		if (StringUtils.isNotBlank(ids)) {
			criteria.andIdIn(Arrays.asList(ids.split(",")));
		}
		List<RemindInfo> list = this.remindInfoService.queryAllObjByExample(example);
    	// 导出头部信息
		List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderForPur();
		FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, list, "供应商资质到期提醒信息", "供应商资质到期提醒信息", 0);
    	return ResponseResult.success(fileData);
    	
    }

	private List<TitleAndModelKey> createExcelHeaderForPur() {
		DateConverter dateConverter =new DateConverter();
		dateConverter.setDateFormat("yyyy-MM-dd");
		List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
		titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商SRM编码", "supCompanySrmCode"));
		titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
		titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("证书名称/类型", "certificateName"));
		TitleAndModelKey endTime =ExcelUtils.createTitleAndModelKey("到期日期", "endTime");
		endTime.setToObjConverter(dateConverter);
		endTime.setToStrConverter(dateConverter);
    	titleAndModelKeys.add(endTime);
		return titleAndModelKeys;
	}
}