package com.els.base.certification.result.service;

import com.els.base.core.entity.user.User;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyResultNoticeService extends BaseService<CompanyResultNotice, CompanyResultNoticeExample, String> {

    /**
     * 创建供应商准入-审核结果通知单
     * @param projectId
     * @param company
     * @param loginUser
     * @param companyResultNotice
     */
    void insert(Company purCompany, User loginUser, CompanyResultNotice companyResultNotice);

    /**
     * 供应商准入-批量删除审核结果通知单
     * @param project
     * @param company
     * @param ids
     */
    void deleteObjByIds(List<String> ids);

    /**
     * 供应商准入--批量发送审核结果通知单给供应商
     * @param project
     * @param company
     * @param ids
     */
    void send(Project project, Company company,User loginUser, List<String> ids);

    /**
     * 供应商准入--批量作废审核结果通知单给供应商
     * @param project
     * @param company
     * @param ids
     */
//    void abolish(Project project, Company company, List<String> ids);
    
    /**
     * 供应商准入-批量通过审核现场考察结果通知单
     * @param ids
     */
	void adopt(List<String> ids);
	
	/**
	 * 供应商准入-批量整改现场考察结果通知单
	 * @param ids
	 */
	void rectification(List<String> ids);
	
	/**
	 * 供应商准入-批量终止审核现场考察结果通知单
	 * @param ids
	 */
	void termination(List<String> ids);
	
	/**
	 * 供应商确认单据
	 * @param ids
	 */
	void supConfirmBill(CompanyResultNotice data);
	
	/**
	 * 发送供应商审批
	 * @param ids
	 */
	void sendToApprove(List<CompanyProcessVO> list);
	
	/**
	 * 采购商批量撤回单据到上次的单据状态
	 * @param ids
	 */
	void revokeObjByIds(List<String> ids);
}