package com.els.base.certification.result.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.qualification.util.QualificationImTemplet;
import com.els.base.certification.result.dao.CompanyResultNoticeMapper;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.certification.result.util.ResultNoticeEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyResultNoticeService")
public class CompanyResultNoticeServiceImpl implements CompanyResultNoticeService,ITaskListener {
	
	private static final String IM_CODE = "COMPANY_FIELD_INVESTIGATION_RESULT";

    @Resource
    private CompanyResultNoticeMapper companyResultNoticeMapper;
    
    @Resource
    private CompanyService companyService;
    
    @Resource
    private GenerateCodeService generateCodeService;
    
    @Resource
    private CompanyUserRefService companyUserRefService;
    
    @Resource
    private ProcessService processService;
    
    @Resource
    private ThreadPoolTaskExecutor defaultPoolTask;
    
    @Resource
    private WorkFlowService workFlowService;
    
    @Resource
    private RoleService roleService;
    
    @Resource
    private UserRoleService userRoleService;

    /*@CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    @Override
    public void abolish(Project project, Company company, List<String> ids) {
        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();

        //校验是否包含未发送数据
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andSendStatusEqualTo(Constant.NO_INT)
                .andProjectIdEqualTo(project.getId());
        int count2=this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if(count2>0){
            throw new CommonException("单据中包含未发送数据，操作失败!");
        }

        //校验是否存在已作废数据，因为不存在确认，所以就不进行确认状态的判断
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_ABOLISH.getStatus())
                .andProjectIdEqualTo(project.getId());
        int count=this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if(count>0){
            throw new CommonException("单据中包含已作废数据，操作失败!");
        }

        CompanyResultNotice companyResultNotice =new CompanyResultNotice();
        companyResultNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andProjectIdEqualTo(project.getId());
        this.companyResultNoticeMapper.updateByExampleSelective(companyResultNotice,companyResultNoticeExample);
    }*/

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    @Override
    public void send(Project project, Company company,User loginUser, List<String> ids) {
        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        //校验数据是否已经发送过了
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andSendStatusEqualTo(Constant.YES_INT)
                .andProjectIdEqualTo(project.getId());
        int count=this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if(count>0){
            throw new CommonException("单据中包含已发送数据，不能再操作!");
        }

        //更新为发送状态并发送消息
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andPurCompanyIdEqualTo(project.getCompanyId())
                .andSendStatusEqualTo(Constant.NO_INT)
                .andProjectIdEqualTo(project.getId());

        List<CompanyResultNotice> companyResultNotices = companyResultNoticeMapper.selectByExample(companyResultNoticeExample);
        if(CollectionUtils.isEmpty(companyResultNotices)){
            return;
        }
        for (CompanyResultNotice companyResultNotice : companyResultNotices) {

            //更新状态
            companyResultNotice.setSendStatus(Constant.YES_INT);
            this.companyResultNoticeMapper.updateByPrimaryKeySelective(companyResultNotice);

            //发送消息
//            this.sendMessagesToSup(project,loginUser,companyResultNotice);
        }

    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(List<String> ids) {

        //校验数据
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        //校验是否是未审核的单据
        List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("所选单据不全是未审核单据，不能执行删除操作!");
        }


        CompanyResultNotice companyResultNotice =new CompanyResultNotice();
        companyResultNotice.setIsEnable(Constant.NO_INT);

        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT);
        this.companyResultNoticeMapper.updateByExampleSelective(companyResultNotice,companyResultNoticeExample);
    }
    
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
	@Override
	public void adopt(List<String> ids) {
		// 校验数据
    	Assert.isNotEmpty(ids, "传入的单据ID不能为空");
    	// 所选单据是否是未审核的单据
    	List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("所选单据包含通过审核或终止审核单据，不能执行此操作!");
        }
    	// 修改单据状态为通过审核
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
        		.andIdIn(ids)
        		.andIsEnableEqualTo(Constant.YES_INT);
        List<CompanyResultNotice> noticeList = this.queryAllObjByExample(companyResultNoticeExample);
        Assert.isNotEmpty(noticeList, "根据传入的ID查询的数据为空");
        noticeList.forEach(notice ->{
        	// 判断单据为整改状态时，有没有确认，么有确认不能通过审核
        	if (ResultNoticeEnum.RECTIFICATION.getCode().equals(notice.getConfirmStatus()) && 
        			Constant.NO_INT == notice.getSendStatus()) {
        		throw new CommonException("供应商："+notice.getSupCompanySrmCode()+"的单据在整改状态下未确认，不能通过审核");
        	}
        	// 修改状态
        	notice.setBeforeConfirmStatus(notice.getConfirmStatus());
        	notice.setConfirmStatus(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        	notice.setSendStatus(Constant.NO_INT);
        	this.companyResultNoticeMapper.updateByPrimaryKeySelective(notice);
        	// 现场考察结果为通过审核，需要修改准入流程中现场考察的状态为通过
        	Process process = this.processService.queryObjByCompanyId(notice.getSupCompanyId());
        	Assert.isNotNull(process, "根据供应商ID查询的准入流程信息为空");
        	process.setSceneInvestigate(ReviewResultEnum.ADOPT.getCode());
        	process.setUpdateTime(new Date());
        	this.processService.modifyObj(process);
        });
        // 给供应商发送消息
        this.defaultPoolTask.execute(new Runnable(){
			@Override
			public void run() {
				noticeList.forEach(notice ->{
					QualificationImTemplet templet = constructImInfo(1,"发送了通过审核",notice);
					sendMessagesToSup(templet,notice);
				});
			}
        });
	}
    
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
	public void rectification(List<String> ids) {
    	// 校验数据
    	Assert.isNotEmpty(ids, "传入的单据ID不能为空");
    	// 所选单据是否是未审核的单据
    	List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("所选单据包含通过审核或终止审核的单据，不能再执行整改操作!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
        	.andIdIn(ids)
        	.andIsEnableEqualTo(Constant.YES_INT);
        List<CompanyResultNotice> noticeList = this.companyResultNoticeMapper.selectByExample(companyResultNoticeExample);
        noticeList.forEach(result ->{
        	if (ResultNoticeEnum.RECTIFICATION.getCode().equals(result.getConfirmStatus()) && 
        			Constant.NO_INT == result.getSendStatus()) {
        		throw new CommonException("整改状态下的供应商编码为:"+ result.getSupCompanySrmCode()+"的供应商单据未确认，不能进行整改操作");
        	}
        	// 修改状态
        	result.setBeforeConfirmStatus(result.getConfirmStatus());
        	result.setConfirmStatus(ResultNoticeEnum.RECTIFICATION.getCode());
        	result.setSendStatus(Constant.NO_INT);
        	this.companyResultNoticeMapper.updateByPrimaryKeySelective(result);
        });
		// 发送消息给供应商
        this.defaultPoolTask.execute(new Runnable(){
			@Override
			public void run() {
				noticeList.forEach(notice ->{
					QualificationImTemplet templet = constructImInfo(1,"发送了需要整改",notice);
					sendMessagesToSup(templet,notice);
				});
			}
        });
	}
    
    
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
	public void revokeObjByIds(List<String> ids) {
		// 未审核单据不需要撤回操作
    	CompanyResultNoticeExample example = new CompanyResultNoticeExample();
    	example.createCriteria().andIdIn(ids)
    			.andIsEnableEqualTo(Constant.YES_INT)
    			.andConfirmStatusEqualTo(ResultNoticeEnum.NOT_AUDITED.getCode());
    	if (this.companyResultNoticeMapper.countByExample(example) > 0) {
    		throw new CommonException("所选单据包含未审核单据，操作失败");
    	}
    	// 查询单据信息
    	example.clear();
    	example.createCriteria().andIdIn(ids)
    			.andIsEnableEqualTo(Constant.YES_INT);
    	List<CompanyResultNotice> list = this.companyResultNoticeMapper.selectByExample(example);
    	list.stream().forEach(result ->{
    		// 如果前一次单据状态为空，就不能执行撤回操作
    		if (StringUtils.isBlank(result.getBeforeConfirmStatus())) {
    			throw new CommonException("单据号："+ result.getAuditResultNoticeNo() +"的单据已执行过撤回操作，不能重复操作");
    		}
    		/**
    		 * 1.供应商已发送审批认证的，不能再执行撤回操作
    		 * 2.单据状态为终止审核，并且此供应商又重新创建另一条单据，不能执行撤回操作
    		 */
    		Process process = this.processService.queryObjByCompanyId(result.getSupCompanyId());
    		if (process.getIsSend() != AuthenticationEnum.UNCERTIFIED.getCode()) {
    			throw new CommonException("供应商:"+ result.getSupCompanySrmCode() +"已发送审批认证，不能再执行撤回操作");
    		}
    		if (ResultNoticeEnum.TERMINATE_AUDIT.getCode().equals(result.getConfirmStatus())) {
    			example.clear();
    			example.createCriteria()
    					.andConfirmStatusNotEqualTo(ResultNoticeEnum.TERMINATE_AUDIT.getCode())
    					.andIsEnableEqualTo(Constant.YES_INT)
    					.andSupCompanySrmCodeEqualTo(result.getSupCompanySrmCode());
    			if (this.companyResultNoticeMapper.countByExample(example) > 0) {
    				throw new CommonException("供应商："+ result.getSupCompanySrmCode() +"已重新创建了单据，不能再执行撤回操作");
    			}
    		}
    		// 如果单据状态为通过审核、终止审核，还需撤回准入流程中现场考察的状态
    		if (ResultNoticeEnum.THROUGH_AUDIT.getCode().equals(result.getConfirmStatus()) ||
    				ResultNoticeEnum.TERMINATE_AUDIT.getCode().equals(result.getConfirmStatus())) {
    			process.setSceneInvestigate(ReviewResultEnum.AUDIT.getCode());
    			process.setUpdateTime(new Date());
    			this.processService.modifyObj(process);
    		}
    		// 将单据状态撤回为上次的状态
    		result.setConfirmStatus(result.getBeforeConfirmStatus());
    		result.setSendStatus(Constant.NO_INT);
    		result.setBeforeConfirmStatus("");
    		this.companyResultNoticeMapper.updateByPrimaryKeySelective(result);
    	});
		
	}
    
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
	public void termination(List<String> ids) {
    	// 校验数据
    	Assert.isNotEmpty(ids, "传入的单据ID不能为空");
    	// 所选单据是否是未审核的单据
    	List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
                .andIdIn(ids)
                .andIsEnableEqualTo(Constant.YES_INT)
                .andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("所选单据包含通过审核或终止审核的单据，不能执行此操作!");
        }
        // 将单据状态改为终止审核
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria()
        .andIdIn(ids)
        .andIsEnableEqualTo(Constant.YES_INT);
        List<CompanyResultNotice> noticeList = this.queryAllObjByExample(companyResultNoticeExample);
        Assert.isNotEmpty(noticeList, "根据传入的单据ID查询出单据数据为空");
        noticeList.forEach(notice ->{
        	// 整改状态下单据是否确认
        	if (ResultNoticeEnum.RECTIFICATION.getCode().equals(notice.getConfirmStatus()) && 
        			Constant.NO_INT == notice.getSendStatus()) {
        		throw new CommonException("供应商："+notice.getSupCompanySrmCode()+"的单据在整改状态下未确认，不能执行终止审核操作");
        	}
        	// 修改单据状态
        	notice.setBeforeConfirmStatus(notice.getConfirmStatus());
        	notice.setConfirmStatus(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        	notice.setSendStatus(Constant.NO_INT);
        	this.companyResultNoticeMapper.updateByPrimaryKeySelective(notice);
        	// 修改准入流程中的现场考察状态为终止
        	Process process = this.processService.queryObjByCompanyId(notice.getSupCompanyId());
        	Assert.isNotNull(process, "根据供应商ID查询的准入流程信息为空");
        	process.setSceneInvestigate(ReviewResultEnum.TERMINATION.getCode());
        	process.setUpdateTime(new Date());
        	this.processService.modifyObj(process);
        });
        // 发送消息给供应商
        this.defaultPoolTask.execute(new Runnable(){
			@Override
			public void run() {
				noticeList.forEach(notice ->{
					QualificationImTemplet templet = constructImInfo(1,"发送了终止审核",notice);
					sendMessagesToSup(templet,notice);
				});
			}
        });
	}
    
    /***
     * 发送消息模版设置
     * @param role
     * @param operate
     * @param companyResultNotice
     * @return
     */
    private QualificationImTemplet constructImInfo(int role, String operate, CompanyResultNotice companyResultNotice) {
    	Assert.isNotNull(companyResultNotice, "发送的数据为空");
		QualificationImTemplet qualificationImTemplet = new QualificationImTemplet();
		// 设置角色信息，1为采购商，其他为供应商
		if (1 == role) {
			qualificationImTemplet.setRole("采购商");
			if (StringUtils.isNotBlank(companyResultNotice.getPurCompanyName())) {
				qualificationImTemplet.setCompanyName(companyResultNotice.getPurCompanyName());
			} else {
				qualificationImTemplet.setCompanyName("");
			}
		} else {
			qualificationImTemplet.setRole("供应商");
			if (StringUtils.isNotBlank(companyResultNotice.getSupCompanyName())) {
				qualificationImTemplet.setCompanyName(companyResultNotice.getSupCompanyName());
			} else {
				qualificationImTemplet.setCompanyName("");
			}
		}
		// 设置操作
		Assert.isNotBlank(operate, "操作字段为空，不能发送消息");
		qualificationImTemplet.setOperate(operate);
		// 设置其他信息
		qualificationImTemplet.setOtherInfo("的现场考察结果通知单，单据号为：");
		// 设置单据号
		qualificationImTemplet.setBillList(companyResultNotice.getAuditResultNoticeNo());
		return qualificationImTemplet;
	}
    
    /**
     * 发送消息给供应商
     * @param project
     * @param loginUser
     * @param companyResultNotice
     */
    private void sendMessagesToSup(QualificationImTemplet templet, CompanyResultNotice companyResultNotice) {
        //发送通知
        Message<QualificationImTemplet> message = Message.init(templet)  // 传入数据
                .setBusinessTypeCode(IM_CODE)  // 业务编码 
                .setCompanyCode(companyResultNotice.getPurCompanySrmCode())   // 发送的企业srm编码
                .setMsgLevel(MessageLevelEnum.HIGH)     // 消息等级
                .setSenderId(companyResultNotice.getPurUserId()) // 发送人的userid
                .addReceiverId(companyResultNotice.getSupUserId()); // 添加单个收件人 userid
        //.addReceiverIdList(new ArrayList<String>()); // 添加多个收件人 userid
        MessageSendUtils.sendMessage(message);
    }
    
    /**
     * 发消息给采购商
     * @param templet
     * @param result
     */
    private void sendMessagesToPur(QualificationImTemplet templet, CompanyResultNotice companyResultNotice) {
    	 Message<QualificationImTemplet> message = Message.init(templet)  // 传入数据
                 .setBusinessTypeCode(IM_CODE)  // 业务编码 
                 .setCompanyCode(companyResultNotice.getSupCompanySrmCode())   // 发送的企业srm编码
                 .setMsgLevel(MessageLevelEnum.HIGH)     // 消息等级
                 .setSenderId(companyResultNotice.getSupUserId()) // 发送人的userid
                 .addReceiverId(companyResultNotice.getPurUserId()); // 添加单个收件人 userid
         //.addReceiverIdList(new ArrayList<String>()); // 添加多个收件人 userid
         MessageSendUtils.sendMessage(message);
		
	}
    
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
	public void supConfirmBill(CompanyResultNotice data) {
    	// 判断单据是否有已确认的单据
		CompanyResultNoticeExample example = new CompanyResultNoticeExample();
		example.createCriteria().andIdEqualTo(data.getId()).andSendStatusEqualTo(Constant.YES_INT);
		if (this.companyResultNoticeMapper.countByExample(example) > 0) {
			throw new CommonException("所选单据是已确认单据，操作失败");
		}
		// 修改单据状态为已确认
		CompanyResultNotice resultNotice = this.queryObjById(data.getId());
		if (null == resultNotice) {
			return;
		}
		resultNotice.setSupReplyInformation(data.getSupReplyInformation());
		resultNotice.setSendStatus(Constant.YES_INT);
		this.companyResultNoticeMapper.updateByPrimaryKeySelective(resultNotice);
		// 给采购商发送消息
		this.defaultPoolTask.execute( new Runnable(){
			@Override
			public void run() {
					QualificationImTemplet templet = constructImInfo(2,"已确认",resultNotice);
					sendMessagesToPur(templet,resultNotice);
			}});
	}


	@CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    @Override
    public void insert(Company purCompany, User user, CompanyResultNotice companyResultNotice) {

        //校验数据
        if (companyResultNotice==null) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        if (StringUtils.isNotBlank(companyResultNotice.getProblemFile()) 
        		&& companyResultNotice.getProblemFile().length() > 3900) {
        	throw new CommonException("上传的附件个数超长，请减少附件个数后再保存");
        }
        if (StringUtils.isNotBlank(companyResultNotice.getRectificationPlanFile()) 
        		&& companyResultNotice.getRectificationPlanFile().length() > 3900) {
        	throw new CommonException("上传的附件个数超长，请减少附件个数后再保存");
        }


        if (StringUtils.isEmpty(companyResultNotice.getId())) {
        	// 已有未审核、通过审核、整改的供应商，不能再创建
            this.judgeRepetition(companyResultNotice);
            //设置采购基本信息
            this.setPurCompanyInfo(purCompany, companyResultNotice);
            
            //设置供应商条件
            this.setSupCompanyInfo(companyResultNotice);
            
            //设置单据信息
            this.setCompanyResultNotice(user, companyResultNotice);
            // 生成单据号
            String  auditResultNoticeNo= generateCodeService.getNextCode("AUDIT_RESULT_NOTICE_NO");
            companyResultNotice.setAuditResultNoticeNo(auditResultNoticeNo);
            this.companyResultNoticeMapper.insertSelective(companyResultNotice);
        } else {
        	// 判断是否重新选择了供应商编码，如果重新选择了供应商编码，需要判断此供应商是否已存在
        	CompanyResultNotice notice = this.queryObjById(companyResultNotice.getId());
        	if (!notice.getSupCompanySrmCode().equals(companyResultNotice.getSupCompanySrmCode())) {
        		this.judgeRepetition(companyResultNotice);
        	}
        	companyResultNotice.setUpdateTime(new Date());
        	this.companyResultNoticeMapper.updateByPrimaryKeySelective(companyResultNotice);
        }

    }
	
	/**
	 * 判断供应商是否有重复创建单据
	 * @param companyResultNotice
	 */
	private void judgeRepetition(CompanyResultNotice companyResultNotice){
		List<String> list = new ArrayList<>();
        list.add(ResultNoticeEnum.NOT_AUDITED.getCode());
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample =new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria()
        		.andSupCompanySrmCodeEqualTo(companyResultNotice.getSupCompanySrmCode())
        		.andIsEnableEqualTo(Constant.YES_INT)
        		.andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
        	throw new CommonException("此供应商已有未审核、通过审核或整改的单据，不能再添加供应商编码："+ companyResultNotice.getSupCompanySrmCode());
        }
	}

    /**
     * 设置单据信息
     * @param project
     * @param user
     * @param companyResultNotice
     */
    private void setCompanyResultNotice(User user, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setCreateBillName(user.getNickName());
        companyResultNotice.setCreateTime(new Date());
        // 采购商用户ID
        companyResultNotice.setPurUserId(user.getId());
        // 可用状态
        companyResultNotice.setIsEnable(Constant.YES_INT);
        // 单据状态
        companyResultNotice.setConfirmStatus(ResultNoticeEnum.NOT_AUDITED.getCode());
        // 确认状态(0未确认，1已确认)
        companyResultNotice.setSendStatus(Constant.NO_INT);

//        /**
//        整改计划算法：
//         1、II类的默认建单时间累加14天，整改最后完成期限默认累加三个月；
//         2、III类的整改计划提交期限默认累加7天；整改完成期限默认累加1个月；
//         */
//        if(StringUtils.isEmpty(companyResultNotice.getCompanyType())){
//            throw new CommonException("供应商类型不能为空", "base_canot_be_null", "供应商类型");
//        }

       /* if(companyResultNotice.getCompanyType().equals(CompanyTypeEnum.II.getCode())){
            Date date =DateUtils.addDays(new Date(),14);
            companyResultNotice.setRectificationTime(date);
            companyResultNotice.setRectificationFinishTime(DateUtils.addMonths(date,3));
        }else if(companyResultNotice.getCompanyType().equals(CompanyTypeEnum.III.getCode())){
            Date date =DateUtils.addDays(new Date(),7);
            companyResultNotice.setRectificationTime(date);
            companyResultNotice.setRectificationFinishTime(DateUtils.addMonths(date,1));
        }else{

        }*/

        //发送状态
//        companyResultNotice.setSendStatus(Constant.NO_INT);
    }

    /**
     * 设置供应商基本信息
     * @param project
     * @param companyResultNotice
     */
    private void setSupCompanyInfo(CompanyResultNotice companyResultNotice) {
        if (StringUtils.isEmpty(companyResultNotice.getSupCompanySrmCode())) {
            throw new CommonException("供应商编码不能为空", "base_canot_be_null", "供应商SRM编码");
        }
        // 根据供应商srm编码查询供应商
        Company superCompany = this.companyService.queryCompanyByCode(companyResultNotice.getSupCompanySrmCode());
        Assert.isNotNull(superCompany, "根据供应商srm编码查询出的供应商信息为空");
        // 根据供应商ID查询供应商用户
        User user = this.companyUserRefService.queryMainUserOfCompany(superCompany.getId());
        Assert.isNotNull(user, "此供应商没有设置用户信息，新建失败");
        companyResultNotice.setSupCompanyId(superCompany.getId());
        companyResultNotice.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyResultNotice.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyResultNotice.setSupCompanyName(superCompany.getCompanyName());
        companyResultNotice.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyResultNotice.setSupCompanyAddress(superCompany.getAddress());
        companyResultNotice.setSupCompanyContacts(superCompany.getContacts());
        companyResultNotice.setSupUserId(user.getId());
    }

    /**
     * 设置采购商基本信息
     * @param company
     * @param companyResultNotice
     */
    private void setPurCompanyInfo(Company purCompany, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setPurCompanyId(purCompany.getId());
        companyResultNotice.setPurCompanyName(purCompany.getCompanyName());
        companyResultNotice.setPurCompanyFullName(purCompany.getCompanyFullName());
        companyResultNotice.setPurCompanySrmCode(purCompany.getCompanyCode());
        companyResultNotice.setPurCompanySapCode(purCompany.getCompanySapCode());
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
    public void addObj(CompanyResultNotice t) {
        this.companyResultNoticeMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyResultNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Override
    public void modifyObj(CompanyResultNotice t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyResultNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyResultNotice", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyResultNotice queryObjById(String id) {
        return this.companyResultNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyResultNotice", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyResultNotice> queryAllObjByExample(CompanyResultNoticeExample example) {
        return this.companyResultNoticeMapper.selectByExample(example);
    }

    @Cacheable(value="companyResultNotice", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyResultNotice> queryObjByPage(CompanyResultNoticeExample example) {
        PageView<CompanyResultNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyResultNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
	@Override
	public void sendToApprove(List<CompanyProcessVO> list) {
		Assert.isNotEmpty(list, "传输的供应商信息不能为空，发送失败");
		// 判断选择的供应商有没有指定准入流程，如果有，准入流程有没有通过
		list.forEach(companyProcess -> {
			Assert.isNotNull(companyProcess.getProcess(), "有供应商没有指定准入流程");
			// 判断是否发送过，准入流程是否通过审核
			this.judgeToExamine(companyProcess);
			// 发送审批
			ProcessStartVO vo=ProcessStartVO.newInstance("approvalsupplier",companyProcess.getCompanyCode(),
					companyProcess.getId(),"registerSupAdmittance?supCompanySrmCode="+companyProcess.getCompanyCode());
			vo.setListenerClass(this.getClass());
			ProcessInstance startProcess=this.workFlowService.startProcess(vo);
			if (null != startProcess) {
				// 成功加入审批流，修改发送状态为认证中
				companyProcess.getProcess().setIsSend(AuthenticationEnum.CERTIFICATION.getCode());
				this.processService.modifyObj(companyProcess.getProcess());
			}
		});
	}
    
    /**
     * 判断供应商是否通过认证
     * @param companyProcess
     */
	private void judgeToExamine(CompanyProcessVO companyProcess) {
		// 判断供应商是否已认证
		if (AuthenticationEnum.CERTIFICATION.getCode() == companyProcess.getProcess().getIsSend()) {
			throw new CommonException("供应商编码为：" + companyProcess.getCompanyCode() + "的供应商已在认证中，不能再发送审批");
		}
		if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(companyProcess.getProcess().getAccessProcess())) {
			if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getQualificationAudit())) {
				throw new CommonException("供应商编码为：" + companyProcess.getCompanyCode() + "的准入流程只资质审核没有通过审核，不能发送审批");
			}
		}
		if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(companyProcess.getProcess().getAccessProcess())) {
			if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getSceneInvestigate())) {
				throw new CommonException("供应商编码为：" + companyProcess.getCompanyCode() + "的准入流程只现场考察没有通过审核，不能发送审批");
			}
		}
		if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(companyProcess.getProcess().getAccessProcess())) {
			if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getQualificationAudit())) {
				throw new CommonException("供应商编码为：" + companyProcess.getCompanyCode() + "的准入流程资质审核没有通过审核，不能发送审批");
			}
			if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getSceneInvestigate())) {
				throw new CommonException("供应商编码为：" + companyProcess.getCompanyCode() + "的准入流程现场考察没有通过审核，不能发送审批");
			}
		}
	}
	
	@Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
	@Override
	public void listen(TaskOperateEvent event) {
		Assert.isNotBlank(event.getBusinessId(), "供应商ID不能为空");
		Process process = this.processService.queryObjByCompanyId(event.getBusinessId());
		Assert.isNotNull(process, "根据供应商ID查询出的准入流程信息为空");
		if (event.isFinished() && event.isPass()) {
			// 状态改为已认证
			process.setIsSend(AuthenticationEnum.CERTIFICATION_SUCCESS.getCode());
			// 流程完成而且通过，将供应商变为合格供应商并分配角色
			this.modifyCompanyQualified(event);
		} else if (event.isFinished() && !event.isPass()) {
			process.setIsSend(AuthenticationEnum.AUTHENTICATION_FAILURE.getCode());
		} 
		process.setUpdateTime(new Date());
		this.processService.modifyObj(process);
	}
	
	/**
	 * 将供应商变为合格供应商
	 * @param event
	 */
	private void modifyCompanyQualified(TaskOperateEvent event) {
		CompanyPartnerExample example = new CompanyPartnerExample();
		example.createCriteria().andPartnerCompanyIdEqualTo(event.getBusinessId());
		CompanyPartner companyPartner = new CompanyPartner();
		companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
		companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
		this.companyService.updatePartnerRole(companyPartner, example);
		// 变为合格供应商后，分配合格供应商角色
		RoleExample roleExample = new RoleExample();
		roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
		List<Role> list = roleService.queryAllObjByExample(roleExample);
		if (CollectionUtils.isNotEmpty(list)) {
			CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
			companyUserExample.createCriteria().andCompanyIdEqualTo(event.getBusinessId());
			List<CompanyUserRef> companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
			UserRoleExample userRoleExample = new UserRoleExample();
			userRoleExample.createCriteria().andUserIdEqualTo(companyUserRef.get(0).getUserId());
			List<UserRole> userRole = this.userRoleService.queryAllObjByExample(userRoleExample);
			for (UserRole ur : userRole) {
				for (Role role : list) {
					ur.setRoleId(role.getId());
					ur.setCreateTime(new Date());
					this.userRoleService.modifyObj(ur);
				}
			}
		}
		
	}

}