package com.els.base.certification.supplierchangesheet.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="供应商信息变更-专利/许可与代理数据")
public class ChangePatentsAndAgent implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("变更单号")
    private String changeBillNo;

    @ApiModelProperty("专利/许可名称")
    private String patentName;

    @ApiModelProperty("专利/许可授予机构")
    private String patentOrganization;

    @ApiModelProperty("专利/许可适用于")
    private String patentDesc;

    @ApiModelProperty("专利/许可有效期至")
    private Date endTime;

    @ApiModelProperty("专利/许可特点与价值")
    private String patentValue;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("专利/许可附件")
    private String patentFile;

    @ApiModelProperty("代理数据-产地")
    private String placeOrigin;

    @ApiModelProperty("代理产品")
    private String agentProduct;

    @ApiModelProperty("代理品牌")
    private String agentBrand;

    @ApiModelProperty("制造商名称")
    private String manufacturerName;

    @ApiModelProperty("代理证有效期")
    private Date agentTime;

    @ApiModelProperty("生产商质量体系证书有效期")
    private Date qualityCertificateTime;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("制造商简介")
    private String manufacturerIntroduce;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("制造商营业执照")
    private String manufacturerBusinessLicense;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("制造商质量证书")
    private String certificateQuality;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("制造商3C证书")
    private String manufacturer3cCertificate;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("制造商行业业绩资料")
    private String performanceData;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("生成设备清单")
    private String createDeviceList;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("检验设备清单")
    private String inspectionEquipmentList;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("财务信息")
    private String financialInformation;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("产品检测合格报告")
    private String testQualificationReport;

    @ApiModelProperty("是否可用（1可用，0不可用）")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getChangeBillNo() {
        return changeBillNo;
    }

    public void setChangeBillNo(String changeBillNo) {
        this.changeBillNo = changeBillNo == null ? null : changeBillNo.trim();
    }

    public String getPatentName() {
        return patentName;
    }

    public void setPatentName(String patentName) {
        this.patentName = patentName == null ? null : patentName.trim();
    }

    public String getPatentOrganization() {
        return patentOrganization;
    }

    public void setPatentOrganization(String patentOrganization) {
        this.patentOrganization = patentOrganization == null ? null : patentOrganization.trim();
    }

    public String getPatentDesc() {
        return patentDesc;
    }

    public void setPatentDesc(String patentDesc) {
        this.patentDesc = patentDesc == null ? null : patentDesc.trim();
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getPatentValue() {
        return patentValue;
    }

    public void setPatentValue(String patentValue) {
        this.patentValue = patentValue == null ? null : patentValue.trim();
    }

    public String getPatentFile() {
        return patentFile;
    }

    public void setPatentFile(String patentFile) {
        this.patentFile = patentFile == null ? null : patentFile.trim();
    }

    public String getPlaceOrigin() {
        return placeOrigin;
    }

    public void setPlaceOrigin(String placeOrigin) {
        this.placeOrigin = placeOrigin == null ? null : placeOrigin.trim();
    }

    public String getAgentProduct() {
        return agentProduct;
    }

    public void setAgentProduct(String agentProduct) {
        this.agentProduct = agentProduct == null ? null : agentProduct.trim();
    }

    public String getAgentBrand() {
        return agentBrand;
    }

    public void setAgentBrand(String agentBrand) {
        this.agentBrand = agentBrand == null ? null : agentBrand.trim();
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName == null ? null : manufacturerName.trim();
    }

    public Date getAgentTime() {
        return agentTime;
    }

    public void setAgentTime(Date agentTime) {
        this.agentTime = agentTime;
    }

    public Date getQualityCertificateTime() {
        return qualityCertificateTime;
    }

    public void setQualityCertificateTime(Date qualityCertificateTime) {
        this.qualityCertificateTime = qualityCertificateTime;
    }

    public String getManufacturerIntroduce() {
        return manufacturerIntroduce;
    }

    public void setManufacturerIntroduce(String manufacturerIntroduce) {
        this.manufacturerIntroduce = manufacturerIntroduce == null ? null : manufacturerIntroduce.trim();
    }

    public String getManufacturerBusinessLicense() {
        return manufacturerBusinessLicense;
    }

    public void setManufacturerBusinessLicense(String manufacturerBusinessLicense) {
        this.manufacturerBusinessLicense = manufacturerBusinessLicense == null ? null : manufacturerBusinessLicense.trim();
    }

    public String getCertificateQuality() {
        return certificateQuality;
    }

    public void setCertificateQuality(String certificateQuality) {
        this.certificateQuality = certificateQuality == null ? null : certificateQuality.trim();
    }

    public String getManufacturer3cCertificate() {
        return manufacturer3cCertificate;
    }

    public void setManufacturer3cCertificate(String manufacturer3cCertificate) {
        this.manufacturer3cCertificate = manufacturer3cCertificate == null ? null : manufacturer3cCertificate.trim();
    }

    public String getPerformanceData() {
        return performanceData;
    }

    public void setPerformanceData(String performanceData) {
        this.performanceData = performanceData == null ? null : performanceData.trim();
    }

    public String getCreateDeviceList() {
        return createDeviceList;
    }

    public void setCreateDeviceList(String createDeviceList) {
        this.createDeviceList = createDeviceList == null ? null : createDeviceList.trim();
    }

    public String getInspectionEquipmentList() {
        return inspectionEquipmentList;
    }

    public void setInspectionEquipmentList(String inspectionEquipmentList) {
        this.inspectionEquipmentList = inspectionEquipmentList == null ? null : inspectionEquipmentList.trim();
    }

    public String getFinancialInformation() {
        return financialInformation;
    }

    public void setFinancialInformation(String financialInformation) {
        this.financialInformation = financialInformation == null ? null : financialInformation.trim();
    }

    public String getTestQualificationReport() {
        return testQualificationReport;
    }

    public void setTestQualificationReport(String testQualificationReport) {
        this.testQualificationReport = testQualificationReport == null ? null : testQualificationReport.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}