package com.els.base.certification.supplierchangesheet.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="T_BASE_COMPANY_AUTHENTICATION")
public class SupAuthentication implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectid;

    @ApiModelProperty("变更单号")
    private String changbillno;

    @ApiModelProperty("证书名称")
    private String certificateName;

    @ApiModelProperty("认证机构")
    private String certificateBody;

    @ApiModelProperty("适用范围")
    private String applyScope;

    @ApiModelProperty("签发日期")
    private Date signDate;

    @ApiModelProperty("有效日期")
    private Date effectiveDate;

    @ApiModelProperty("上传日期")
    private Date updateDate;

    @ApiModelProperty("软删除")
    private Integer isEnable;

    @ApiModelProperty("备注")
    private String mark;
    
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件上传")
    private String attachment;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectid() {
        return projectid;
    }

    public void setProjectid(String projectid) {
        this.projectid = projectid == null ? null : projectid.trim();
    }

    public String getChangbillno() {
        return changbillno;
    }

    public void setChangbillno(String changbillno) {
        this.changbillno = changbillno == null ? null : changbillno.trim();
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName == null ? null : certificateName.trim();
    }

    public String getCertificateBody() {
        return certificateBody;
    }

    public void setCertificateBody(String certificateBody) {
        this.certificateBody = certificateBody == null ? null : certificateBody.trim();
    }

    public String getApplyScope() {
        return applyScope;
    }

    public void setApplyScope(String applyScope) {
        this.applyScope = applyScope == null ? null : applyScope.trim();
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark == null ? null : mark.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }
}