package com.els.base.certification.supplierchangesheet.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel(value="T_BASE_COMPANY_DATA_CHANGE")
public class SupplierChangeSheet implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("单据编号")
    private String changeBillNo;

    @ApiModelProperty("供应商编号")
    private String supCompanyId;

    @ApiModelProperty("供应商SAP码")
    private String supplierSapCode;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("制单时间")
    private Date createBillTime;

    @ApiModelProperty("确认时间")
    private Date confirmTime;

    @ApiModelProperty("制单人")
    private String confirmBillName;

    @ApiModelProperty("单据状态(0：未回签1：已回签2：已审核3：以驳回4：已作废)")
    private Integer billStatus;

    @ApiModelProperty("审批人")
    private String approveUserName;

    @ApiModelProperty("审批状态(0=审核中 1=待审核 2=已审核)")
    private Integer approveStatus;

    @ApiModelProperty("审批时间")
    private Date approveTime;

    @ApiModelProperty("审批结果")
    private String approveResult;

    @ApiModelProperty("审批状态(0=全部，1=基本信息 2=资质认证)")
    private Integer changType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("软删除")
    private Integer isEnable;

	private List<SupplierChangeSheetDETAILE> SupplierChangeSheetDetaileList;

	private List<SupAuthentication> supAuthenticationList;
	
	private List<ChangePatentsAndAgent> changePatentsAndAgentList;
	
	public List<ChangePatentsAndAgent> getChangePatentsAndAgentList() {
		return changePatentsAndAgentList;
	}

	public void setChangePatentsAndAgentList(List<ChangePatentsAndAgent> changePatentsAndAgentList) {
		this.changePatentsAndAgentList = changePatentsAndAgentList;
	}

	public List<SupAuthentication> getSupAuthenticationList() {
		return supAuthenticationList;
	}

	public void setSupAuthenticationList(
			List<SupAuthentication> supAuthenticationList) {
		this.supAuthenticationList = supAuthenticationList;
	}

	public List<SupplierChangeSheetDETAILE> getSupplierChangeSheetDetaileList() {
		return SupplierChangeSheetDetaileList;
	}

	public void setSupplierChangeSheetDetaileList(List<SupplierChangeSheetDETAILE> supplierChangeSheetDetaileList) {
		SupplierChangeSheetDetaileList = supplierChangeSheetDetaileList;
	}

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getChangeBillNo() {
        return changeBillNo;
    }

    public void setChangeBillNo(String changeBillNo) {
        this.changeBillNo = changeBillNo == null ? null : changeBillNo.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupplierSapCode() {
        return supplierSapCode;
    }

    public void setSupplierSapCode(String supplierSapCode) {
        this.supplierSapCode = supplierSapCode == null ? null : supplierSapCode.trim();
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName == null ? null : supplierName.trim();
    }

    public Date getCreateBillTime() {
        return createBillTime;
    }

    public void setCreateBillTime(Date createBillTime) {
        this.createBillTime = createBillTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getConfirmBillName() {
        return confirmBillName;
    }

    public void setConfirmBillName(String confirmBillName) {
        this.confirmBillName = confirmBillName == null ? null : confirmBillName.trim();
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName == null ? null : approveUserName.trim();
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult == null ? null : approveResult.trim();
    }

    public Integer getChangType() {
        return changType;
    }

    public void setChangType(Integer changType) {
        this.changType = changType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }
}