package com.els.base.certification.supplierchangesheet.service;


import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;

public interface SupplierChangeSheetService extends BaseService<SupplierChangeSheet, SupplierChangeSheetExample, String> {
	/**
	 * 创建供应商资质变更单
	 * @param supplierChangeSheet
	 * @param loginUser
	 * @param company
	 */
	public void addCertification(SupplierChangeSheet supplierChangeSheet, User loginUser, Company company);

	/**
	 * 创建供应商基础信息变更单
	 * @param supplierChangeSheet
	 * @param loginUser
	 * @param currentCompany
	 */
	public void insert(SupplierChangeSheet supplierChangeSheet, User loginUser, Company currentCompany);
	
	/**
	 * 发送审核
	 * @param id
	 */
	public void approve(String id);
	
	/**
	 * 创建专利/许可和代理数据变更单
	 * @param supplierChangeSheet
	 * @param loginUser
	 * @param company
	 */
	public void addPatentsAndAgent(SupplierChangeSheet supplierChangeSheet, User loginUser,Company company);

}