package com.els.base.certification.supplierchangesheet.web.controller;


import com.els.base.certification.supplierchangesheet.dao.SupAuthenticationMapper;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="T_BASE_COMPANY_AUTHENTICATION")
@Controller
@RequestMapping("supAuthentication")
public class SupAuthenticationController {
    @Resource
    protected SupAuthenticationService supAuthenticationService;
    @Resource
    protected SupAuthenticationMapper supAuthenticationMapper;
   
    
    @ApiOperation(httpMethod="POST", value="创建T_BASE_COMPANY_AUTHENTICATION")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupAuthentication supAuthentication) {
        this.supAuthenticationService.addObj(supAuthentication);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑T_BASE_COMPANY_AUTHENTICATION")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupAuthentication supAuthentication) {
        Assert.isNotBlank(supAuthentication.getId(), "id 为空，保存失败");
        this.supAuthenticationService.modifyObj(supAuthentication);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除T_BASE_COMPANY_AUTHENTICATION")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.supAuthenticationService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询T_BASE_COMPANY_AUTHENTICATION")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 SupAuthentication", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupAuthentication>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        SupAuthenticationExample example = new SupAuthenticationExample();
        example.setPageView(new PageView<SupAuthentication>(pageNo, pageSize));
        
        SupAuthenticationExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<SupAuthentication> pageData = this.supAuthenticationService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST", value = "上传附件")
   	@RequestMapping("service/attachment")
   	@ResponseBody
   	public ResponseResult<String> attachment( @RequestBody SupAuthentication supAuthentication) {
   		
   		if (StringUtils.isBlank(supAuthentication.getId())) {
   			throw new CommonException("id 为空，保存失败");
   		}
   		this.supAuthenticationService.addAttachment(supAuthentication);
   		return ResponseResult.success();
   	}
  
}