package com.els.base.certification.supplierchangesheet.web.controller;

import java.util.List;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetMapper;
import com.els.base.certification.supplierchangesheet.emum.ApproveStatus;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "供应商基础资料变更单")
@Controller
@RequestMapping("supplierChangeSheet")
public class SupplierChangeSheetController {
	@Resource
	protected SupplierChangeSheetService supplierChangeSheetService;
	
	@Resource
	protected SupplierChangeSheetMapper supplierChangeSheetMapper;
	
	@Resource
	protected SupplierChangeSheetDETAILEService SupplierChangeSheetDetaleService;
	
	@Resource
    protected SupAuthenticationService supAuthenticationService;

	@ApiOperation(httpMethod = "POST", value = "创建供应商基础资料变更单")
	@RequestMapping("service/create")
	@ResponseBody
	public ResponseResult<String> create(@RequestBody SupplierChangeSheet supplierChangeSheet) {
		this.supplierChangeSheetService.insert(supplierChangeSheet,SpringSecurityUtils.getLoginUser(),CompanyUtils.currentCompany());
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "创建供应商资质认证变更单")
	@RequestMapping("service/addCertification")
	@ResponseBody
	public ResponseResult<String> addCertification(@RequestBody SupplierChangeSheet supplierChangeSheet) {
		List<SupAuthentication> list = supplierChangeSheet.getSupAuthenticationList();
		for (SupAuthentication item : list) {
			Assert.isNotBlank(item.getCertificateName(), "证书名称不能为空");
			Assert.isNotBlank(item.getCertificateBody(), "认证机构不能为空");
			Assert.isNotBlank(item.getApplyScope(), "适用范围不能为空");
			Assert.isNotNull(item.getEffectiveDate(), "有效日期不能为空");
			Assert.isNotNull(item.getSignDate(), "签发日期不能为空");
			Assert.isNotBlank(item.getCertificateBody(), "认证机构不能为空");
		}
		this.supplierChangeSheetService.addCertification(supplierChangeSheet,SpringSecurityUtils.getLoginUser(),CompanyUtils.currentCompany());
		return ResponseResult.success();
	}
	
	@ApiOperation(httpMethod = "POST", value = "创建供应商专利/许可和代理数据变更单")
	@RequestMapping("service/insertPatentsAndAgent")
	@ResponseBody
	public ResponseResult<String> insertPatentsAndAgent(@RequestBody SupplierChangeSheet supplierChangeSheet) {
		Assert.isNotNull(supplierChangeSheet, "创建变更单的数据为空，创建失败");
		this.supplierChangeSheetService.addPatentsAndAgent(supplierChangeSheet,SpringSecurityUtils.getLoginUser(),CompanyUtils.currentCompany());
		return ResponseResult.success();
	}
	
	@ApiOperation(httpMethod = "POST", value = "编辑供应商变更单")
	@RequestMapping("service/edit")
	@ResponseBody
	public ResponseResult<String> edit(@RequestBody SupplierChangeSheet supplierChangeSheet) {
		Assert.isNotBlank(supplierChangeSheet.getId(), "id 为空，保存失败");
		this.supplierChangeSheetService.modifyObj(supplierChangeSheet);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "删除供应商变更单")
	@RequestMapping("service/deleteById")
	@ResponseBody
	public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
		Assert.isNotBlank(id, "删除失败,id不能为空");
		this.supplierChangeSheetService.deleteObjById(id);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "采购查询供应商变更单")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
			@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
			@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 SupplierChangeSheet", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<SupplierChangeSheet>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
			@RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
		SupplierChangeSheetExample example = new SupplierChangeSheetExample();
		example.setPageView(new PageView<SupplierChangeSheet>(pageNo, pageSize));

		SupplierChangeSheetExample.Criteria criteria = example.createCriteria();
		// 填写具体的查询条件，例如
		// criteria.andIdEqualTo("1");
//		criteria.andApproveStatusEqualTo(ApproveStatus.TOAUDIT.getCode());
		criteria.andApproveStatusNotEqualTo(ApproveStatus.UNAUDITED.getCode());
		example.setOrderByClause("UPDATE_TIME DESC");
		if (wapper != null) {
			CriteriaUtils.addExample(example, wapper);
		}

		PageView<SupplierChangeSheet> pageData = this.supplierChangeSheetService.queryObjByPage(example);
		return ResponseResult.success(pageData);
	}
	
	
	@ApiOperation(httpMethod = "POST", value = "供应商查询自己变更单")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
			@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
			@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 SupplierChangeSheet", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/queryByPage")
	@ResponseBody
	public ResponseResult<PageView<SupplierChangeSheet>> queryByPage(@RequestParam(defaultValue = "0") int pageNo,
		@RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
		SupplierChangeSheetExample example = new SupplierChangeSheetExample();
		example.setPageView(new PageView<SupplierChangeSheet>(pageNo, pageSize));
		example.setOrderByClause("UPDATE_TIME DESC");

		SupplierChangeSheetExample.Criteria criteria = example.createCriteria();
		// 填写具体的查询条件，例如
		// criteria.andIdEqualTo("1");
		  // 供应商只查询自己公司的记录
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getCompanyCode());
		if (wapper != null) {
			CriteriaUtils.addExample(example, wapper);
		}

		PageView<SupplierChangeSheet> pageData = this.supplierChangeSheetService.queryObjByPage(example);
		return ResponseResult.success(pageData);
	}

	@ApiOperation(httpMethod = "POST", value = "查询单挑变更单详细")
	@RequestMapping("service/findById")
	@ResponseBody
	public ResponseResult<SupplierChangeSheet> selectListAll(@RequestParam String id) {
		Assert.isNotBlank(id, "模版数据id不能为空");
		SupplierChangeSheet supplierChangeSheet=this.supplierChangeSheetService.queryObjById(id);
		return ResponseResult.success(supplierChangeSheet);
	}
	

	
	@ApiOperation(httpMethod = "POST", value = "送审")
	@RequestMapping("service/approve")
	@ResponseBody
	public ResponseResult<String> approve(@RequestParam String id) {
		Assert.isNotBlank(id, "模版数据id不能为空");
		this.supplierChangeSheetService.approve(id);
		return ResponseResult.success();
	}
}