
CREATE TABLE "T_BASE_COMPANY_FINANCE" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "ASSET_TYPE_CODE" NUMBER(7) NULL ,
  "ASSET_TYPE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "START_TIME" DATE NULL ,
  "ENT_TIME" DATE NULL ,
  "BUSINESS_VOLUME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SELLING_COST" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "TOTAL_ASSETS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "GROSS_LIABILITIES" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "ACCOUNT_RECEIVABLE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "ACCOUNT_PAYABLE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "GROSS_PROFIT_RATE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
  "REMARK" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL
);

COMMENT ON TABLE "T_BASE_COMPANY_FINANCE" IS '财务信息';

COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ID" IS 'ID主键';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ASSET_TYPE_CODE" IS '资产类型';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ASSET_TYPE_NAME" IS '资产类型名称';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."START_TIME" IS '开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ENT_TIME" IS '结束时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."BUSINESS_VOLUME" IS '营业额';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."SELLING_COST" IS '销售成本';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."TOTAL_ASSETS" IS '总资产';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."GROSS_LIABILITIES" IS '总负债';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ACCOUNT_RECEIVABLE" IS '应收账款';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."ACCOUNT_PAYABLE" IS '应付账款';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."GROSS_PROFIT_RATE" IS '同类产品毛利率';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FINANCE"."UPDATE_TIME" IS '更新时间';

ALTER TABLE "T_BASE_COMPANY_FINANCE" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_FINANCE" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_FINANCE" ADD PRIMARY KEY ("ID");
