
CREATE TABLE "T_BASE_COMPANY_RESULT_NOTICE" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_FULL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_CONTACTS" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "AUDIT_RESULT_NOTICE_NO" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SUP_MATERIAL_DESC" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "AUDIT_TIME" DATE NULL ,
  "AUDIT_STATUS" NUMBER(7) DEFAULT 0  NULL ,
  "SEND_STATUS" NUMBER(7) DEFAULT 0  NULL,
  "CONFIRM_TIME" DATE NULL,
  "CONFIRM_STATUS" VARCHAR(7)   NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL,

  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL,
  "CREATE_BILL_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "COMPANY_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "BILL_TYPE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,

  "RECTIFICATION_TIME" DATE NULL ,
  "RECTIFICATION_FINISH_TIME" DATE NULL,

  "SCORE" NUMBER(20,2) DEFAULT 0  NULL,
  "LEVEL" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "SCORE_CONCLUSION" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "REMARK" VARCHAR2(2048 BYTE) DEFAULT ''  NULL,
  "PROBLEM_FILE" VARCHAR2(2048 BYTE) DEFAULT ''  NULL,
  "RECTIFICATION_PLAN_FILE" VARCHAR2(2048 BYTE) DEFAULT ''  NULL,
  "RED" NUMBER(7) DEFAULT 0  NULL,
  "YELLOW"  NUMBER(7) DEFAULT 0  NULL,
  "GREEN"  NUMBER(7) DEFAULT 0  NULL,
  "COLOUR_CONCLUSION" VARCHAR2(255 BYTE) DEFAULT ''  NULL
);


COMMENT ON TABLE "T_BASE_COMPANY_RESULT_NOTICE" IS '供应商准入-审核结果通知单';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PUR_COMPANY_ID" IS '采购公司ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PUR_COMPANY_NAME" IS '采购商公司名称';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PUR_COMPANY_FULL_NAME" IS '采购商公司全称';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PUR_COMPANY_SAP_CODE" IS '采购商SAP编码';

COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_FULL_NAME" IS '供应商全称';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_SAP_CODE" IS '供应商SAP编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_ADDRESS" IS '供应商地址';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_COMPANY_CONTACTS" IS '供应商联系人';

COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."AUDIT_RESULT_NOTICE_NO" IS '审核结果通知单单号';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_MATERIAL_CODE" IS '供应商物料编码';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SUP_MATERIAL_DESC" IS '供应商物料描述';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."AUDIT_TIME" IS '审核时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."AUDIT_STATUS" IS '审核状态(0=未审核，1=待审核，2已审核)';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."CREATE_BILL_NAME" IS '制单人';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."COMPANY_TYPE" IS '供应商类型';

COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."BILL_TYPE" IS '单据类型';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."CONFIRM_STATUS" IS '单据状态';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SEND_STATUS" IS '发送状态（0=未发送，1=已发送）';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."RECTIFICATION_TIME" IS '整改时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."RECTIFICATION_FINISH_TIME" IS '整改完成时间';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."CONFIRM_TIME" IS '确认时间';


COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SCORE" IS '分数';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."LEVEL" IS '等级';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."SCORE_CONCLUSION" IS '评分结论';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."REMARK" IS '备注';

COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."PROBLEM_FILE" IS '问题清单文件';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."RECTIFICATION_PLAN_FILE" IS '整改计划文件';

COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."RED" IS '红灯个数';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."YELLOW" IS '黄灯个数';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."GREEN" IS '绿灯个数';
COMMENT ON COLUMN "T_BASE_COMPANY_RESULT_NOTICE"."COLOUR_CONCLUSION" IS '颜色综合评价';

ALTER TABLE "T_BASE_COMPANY_RESULT_NOTICE" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_RESULT_NOTICE" ADD PRIMARY KEY ("ID");
