create table "T_BASE_COMPANY_SUPPLIER_EXEMPT" 
(
   "ID"                   VARCHAR2(32 CHAR)    not null,
   "PROJECT_ID"           VARCHAR2(32 CHAR),
   "SUP_COMPANY_ID"       VARCHAR2(32 CHAR),
   "STATUS"               VARCHAR2(7 CHAR)     default '1',
   "SUP_COMPANY_SRM_CODE" VARCHAR2(255 CHAR),
   "DOCUMENT_NUMBER"      VARCHAR2(255 CHAR),
   "SUP_COMPANY_NAME"     VARCHAR2(255 CHAR),
   "SUPPLIER_TYPE"        VARCHAR2(255 CHAR),
   "PRODUCT_CHARACTERIZATION" VARCHAR2(1000 CHAR),
   "DEMAND_SOURCES"       VARCHAR2(255 CHAR),
   "INTRODUCE_REASON"     VARCHAR2(255 CHAR),
   "REQUIREMENT_ANALYSIS" VARCHAR2(1000 CHAR),
   "CURRENT_STATUS"       VARCHAR2(1000 CHAR),
   "NECESSITY_ANALYSIS"   VARCHAR2(1000 CHAR),
   "CONCLUSION"           VARCHAR2(1000 CHAR),
   "SUP_COMPANY_ENGLISH_NAME" VARCHAR2(255 CHAR),
   "REMARKS"              VARCHAR2(1000 CHAR),
   "OVERVIEW_AND_RISK"    VARCHAR2(1000 CHAR),
   "EXEMPTION_REASON"     VARCHAR2(1000 CHAR),
   "SINGLE_PERSON"        VARCHAR2(255 CHAR),
   "CREATE_TIME"          DATE                 default SYSDATE,
   "PENDING_APPROVAL_PEOPLE" VARCHAR2(50 CHAR),
   "AUDIT_TIME"           DATE,
   "IS_ENABLE"            NUMBER(7)            default 1,
   "IS_INVALID"           NUMBER(7)            default 0,
   constraint PK_T_BASE_COMPANY_SUPPLIER_EXE primary key (ID)
);

comment on table "T_BASE_COMPANY_SUPPLIER_EXEMPT" is '供应商豁免单';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."ID" is '主键ID';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."PROJECT_ID" is '项目ID';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SUP_COMPANY_ID" is '供应商ID';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."STATUS" is '单据状态(1为已保存,2为正在审核,3为已审核,4为已驳回)';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SUP_COMPANY_SRM_CODE" is '供应商编码';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."DOCUMENT_NUMBER" is '单据号';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SUP_COMPANY_NAME" is '供应商名称';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SUPPLIER_TYPE" is '供应商类型';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."PRODUCT_CHARACTERIZATION" is '产品特性描述';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."DEMAND_SOURCES" is '需求来源';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."INTRODUCE_REASON" is '引入原因';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."REQUIREMENT_ANALYSIS" is '需求分析';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."CURRENT_STATUS" is '目前状况';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."NECESSITY_ANALYSIS" is '必要性分析';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."CONCLUSION" is '结论';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SUP_COMPANY_ENGLISH_NAME" is '供应商英文名称';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."REMARKS" is '备注';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."OVERVIEW_AND_RISK" is '综合评价及风险点';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."EXEMPTION_REASON" is '豁免理由';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."SINGLE_PERSON" is '制单人';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."CREATE_TIME" is '创建时间';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."PENDING_APPROVAL_PEOPLE" is '当前待审批人';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."AUDIT_TIME" is '审核时间';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."IS_ENABLE" is '记录是否可用(0=不可用，1=可用)';

comment on column "T_BASE_COMPANY_SUPPLIER_EXEMPT"."IS_INVALID" is '单据是否作废(0=不作废，1=作废)';