CREATE TABLE T_BASE_COMPANY_TECHNOLOGY (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PIVOTAL_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"CENTRAL_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"ENGINEER_QUANTITY" NUMBER(7,0) NULL ,
"MAJOR_PRODUCTIVE_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"MAJOR_DEVELOP_SOFTWARE" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(7,0) DEFAULT 1 NULL,
"FINISH_FLAG" NUMBER(7,0) DEFAULT 0 NULL,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;

COMMENT ON TABLE T_BASE_COMPANY_TECHNOLOGY IS '供应商准入-主要技术';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."PIVOTAL_TECHNOLOGY" IS '关键技术';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."CENTRAL_TECHNOLOGY" IS '核心技术';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."ENGINEER_QUANTITY" IS '研发工程师数量';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."MAJOR_PRODUCTIVE_TECHNOLOGY" IS '主要生产技术';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."MAJOR_DEVELOP_SOFTWARE" IS '主要开发软件';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_TECHNOLOGY."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_TECHNOLOGY ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_TECHNOLOGY ADD PRIMARY KEY ("ID");
