/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.company.util;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(CompanyInfoUtils.class);

    public static FileData generatePdf(String projectId, String companyId, Map<String, Object> params, String printType) throws Exception {
        log.debug("\u3010\u4f9b\u5e94\u5546\u57fa\u672c\u8d44\u6599\u6253\u5370\u3011");
        FileData pdfFile = null;
        String html = null;
        String fileName = null;
        switch (printType) {
            case "A4": {
                Assert.isNotNull((Object)params.get("company"), (String)"\u5728Map\u96c6\u5408\u4e2d\u6839\u636ecompany\u952e\u53d6\u7684\u503c\u4e3a\u7a7a");
                Company com = (Company)params.get("company");
                html = com.getFirstCompanyType().equals("2") ? BeetlTemplateUtils.renderFromFile((String)"agent.html", params) : (com.getFirstCompanyType().equals("1") ? BeetlTemplateUtils.renderFromFile((String)"manufacturer.html", params) : BeetlTemplateUtils.renderFromFile((String)"customized.html", params));
                fileName = "\u4f9b\u5e94\u5546\u57fa\u672c\u8d44\u6599_A4_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = CompanyInfoUtils.createEmptyPDF(projectId, companyId, fileName);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)fileName);
                break;
            }
            default: {
                throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u7c7b\u578b[" + printType + "]");
            }
        }
        return pdfFile;
    }

    private static FileData createEmptyPDF(String projectId, String companyId, String fileName) throws IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(fileName + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        pdfFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), pdfFile);
        return pdfFile;
    }
}

