/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.company.entity.Supplier;
import com.els.base.certification.company.service.SupplierService;
import com.els.base.certification.company.util.ClassificationThreeEnum;
import com.els.base.certification.company.util.ExcelFileData;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import jxl.write.WriteException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f")
@Controller(value="defaultSupplierCompanyController")
@RequestMapping(value={"supplier"})
public class SupplierController {
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyPatentsService companyPatentsService;
    @Resource
    private CompanyFinanceService companyFinanceService;
    @Resource
    private CompanySupplyRelationService companySupplyRelationService;
    @Resource
    private CompanyFileService companyFileService;
    @Resource
    private CompanyEquipmentService companyEquipmentService;
    @Resource
    private CompanyProductDeviceService companyProductDeviceService;
    @Resource
    private CompanyTechnologyService companyTechnologyService;
    @Resource
    private CompanyRawMaterialService companyRawMaterialService;
    @Resource
    private CompanyCustomerService companyCustomerService;
    @Resource
    private CompanyProductServiceService companyProductServiceService;
    @Resource
    private ContactsService contactsService;
    @Resource
    private SupplierService supplierService;
    @Resource
    private CompanyPurRefService companyPurRefService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private ProcessService processService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u63d0\u4ea4\u5ba1\u6838\u8d44\u6599")
    @RequestMapping(value={"service/audit"})
    @ResponseBody
    public ResponseResult<String> audit() {
        this.supplierService.audit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u67e5\u8be2\u5404\u4e2a\u4f9b\u5e94\u5546\u8d44\u6599\u662f\u5426\u586b\u5199\u5b8c\u6210")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findIsFinish"})
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> findIsFinish(@RequestParam(required=false) String supCompanySrmCode) {
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        Project project = ProjectUtils.getProject();
        Company company = null;
        company = StringUtils.isBlank((String)supCompanySrmCode) ? CompanyUtils.currentCompany() : this.companyService.queryCompanyByCode(supCompanySrmCode);
        companyFinishFlag.setEnterpriseBaseInfo(this.companyService.isFinish(company));
        companyFinishFlag.setContactInfo(this.contactsService.isFinish(project, company));
        companyFinishFlag.setProductOrService(this.companyProductServiceService.isFinish(project, company));
        companyFinishFlag.setMainCustomer(this.companyCustomerService.isFinish(project, company));
        companyFinishFlag.setMainSupOrMaterials(this.companyRawMaterialService.isFinish(project, company));
        companyFinishFlag.setMainTechnology(this.companyTechnologyService.isFinish(project, company));
        companyFinishFlag.setMainProductDevice(this.companyProductDeviceService.isFinish(project, company));
        companyFinishFlag.setMainTestEquipment(this.companyEquipmentService.isFinish(project, company));
        companyFinishFlag.setThroughAuthentication(this.companyAuthService.isFinish(project, company));
        companyFinishFlag.setProprietaryTechnology(this.companyPatentsService.isFinish(project, company));
        companyFinishFlag.setFinanceInfo(this.companyFinanceService.isFinish(project, company));
        companyFinishFlag.setEmployeeSupplyRelationship(this.companySupplyRelationService.isFinish(project, company));
        companyFinishFlag.setEnclosureList(this.companyFileService.isFinish(project, company));
        return ResponseResult.success((Object)companyFinishFlag);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleEnum", required=false, value="\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\uff08stranger/potenial/qualified\uff09", paramType="query", dataType="String", defaultValue="stranger"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Supplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Supplier>> findByPage(@RequestParam(defaultValue="stranger") String roleEnum, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws Exception {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        ArrayList<String> roleEnumList = new ArrayList<String>();
        roleEnumList.add(PartnerRoleEnum.STRANGER.getCode());
        roleEnumList.add(PartnerRoleEnum.QUALIFIED.getCode());
        roleEnumList.add(PartnerRoleEnum.POTENIAL.getCode());
        roleEnumList.add(PartnerRoleEnum.ELIMINATE.getCode());
        if (!roleEnumList.contains(roleEnum)) {
            throw new CommonException("\u4e0d\u652f\u6301\u8be5\u89d2\u8272\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5!");
        }
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        PageView companyPageView = this.companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
        List result = companyPageView.getQueryResult();
        PageView supplierPageView = new PageView(pageNo, pageSize);
        supplierPageView.setRowCount(companyPageView.getRowCount());
        if (CollectionUtils.isEmpty((Collection)result)) {
            return ResponseResult.success((Object)supplierPageView);
        }
        List<Supplier> list = this.getSuppliers(result);
        supplierPageView.setQueryResult(list);
        return ResponseResult.success((Object)supplierPageView);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleEnum", required=false, value="\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u6f5c\u5728\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\uff08stranger/potenial/qualified\uff09", paramType="query", dataType="String", defaultValue="stranger"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Supplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForApply"})
    @ResponseBody
    public ResponseResult<PageView<Supplier>> findByPageForApply(@RequestParam(defaultValue="stranger") String roleEnum, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws Exception {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        ArrayList<String> roleEnumList = new ArrayList<String>();
        roleEnumList.add(PartnerRoleEnum.STRANGER.getCode());
        roleEnumList.add(PartnerRoleEnum.QUALIFIED.getCode());
        roleEnumList.add(PartnerRoleEnum.POTENIAL.getCode());
        roleEnumList.add(PartnerRoleEnum.ELIMINATE.getCode());
        if (!roleEnumList.contains(roleEnum)) {
            throw new CommonException("\u4e0d\u652f\u6301\u8be5\u89d2\u8272\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5!");
        }
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        PageView companyPageView = this.companyService.querySupplerCompaniesForApply(purCompanyId, companyExample, roleEnum);
        List result = companyPageView.getQueryResult();
        PageView supplierPageView = new PageView(pageNo, pageSize);
        supplierPageView.setRowCount(companyPageView.getRowCount());
        if (CollectionUtils.isEmpty((Collection)result)) {
            return ResponseResult.success((Object)supplierPageView);
        }
        List<Supplier> list = this.getSuppliers(result);
        supplierPageView.setQueryResult(list);
        return ResponseResult.success((Object)supplierPageView);
    }

    private List<Supplier> getSuppliers(List<Company> result) throws Exception {
        ArrayList<Supplier> list = new ArrayList<Supplier>();
        for (Company company : result) {
            Supplier supplier = new Supplier();
            BeanUtils.copyProperties((Object)company, (Object)((Object)supplier));
            this.setFirstCompanyType(company, supplier);
            this.setSecondCompanyType(company, supplier);
            this.setSupplierCertification(ProjectUtils.getProject(), supplier);
            ProcessExample processExample = new ProcessExample();
            processExample.createCriteria().andCompanyIdEqualTo(company.getId());
            List processList = this.processService.queryAllObjByExample((IExample)processExample);
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                supplier.setProcess((Process)processList.get(0));
            }
            list.add(supplier);
        }
        return list;
    }

    private void setSecondCompanyType(Company company, Supplier supplier) {
        Object[] secondCompanyTypeStr;
        String secondCompanyType = company.getSecondCompanyType();
        if (StringUtils.isNotBlank((String)secondCompanyType) && ArrayUtils.isNotEmpty((Object[])(secondCompanyTypeStr = secondCompanyType.split(",")))) {
            if (secondCompanyTypeStr.length > 5) {
                supplier.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                if (dicItem1 != null) {
                    supplier.setSecondCompanyTypeDesc1(dicItem1.getName());
                } else {
                    supplier.setSecondCompanyTypeDesc1("");
                }
                supplier.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                if (dicItem2 != null) {
                    supplier.setSecondCompanyTypeDesc2(dicItem2.getName());
                } else {
                    supplier.setSecondCompanyTypeDesc2("");
                }
                supplier.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                if (dicItem3 != null) {
                    supplier.setSecondCompanyTypeDesc3(dicItem3.getName());
                } else {
                    supplier.setSecondCompanyTypeDesc3("");
                }
                supplier.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                if (dicItem4 != null) {
                    supplier.setSecondCompanyTypeDesc4(dicItem4.getName());
                } else {
                    supplier.setSecondCompanyTypeDesc4("");
                }
                supplier.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                if (dicItem5 != null) {
                    supplier.setSecondCompanyTypeDesc5(dicItem5.getName());
                } else {
                    supplier.setSecondCompanyTypeDesc5("");
                }
            } else {
                for (int i = 1; i <= secondCompanyTypeStr.length; ++i) {
                    if (i == 1) {
                        supplier.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                        DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                        if (dicItem1 != null) {
                            supplier.setSecondCompanyTypeDesc1(dicItem1.getName());
                            continue;
                        }
                        supplier.setSecondCompanyTypeDesc1("");
                        continue;
                    }
                    if (i == 2) {
                        supplier.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                        DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                        if (dicItem2 != null) {
                            supplier.setSecondCompanyTypeDesc2(dicItem2.getName());
                            continue;
                        }
                        supplier.setSecondCompanyTypeDesc2("");
                        continue;
                    }
                    if (i == 3) {
                        supplier.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                        DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                        if (dicItem3 != null) {
                            supplier.setSecondCompanyTypeDesc3(dicItem3.getName());
                            continue;
                        }
                        supplier.setSecondCompanyTypeDesc3("");
                        continue;
                    }
                    if (i == 4) {
                        supplier.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                        DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                        if (dicItem4 != null) {
                            supplier.setSecondCompanyTypeDesc4(dicItem4.getName());
                            continue;
                        }
                        supplier.setSecondCompanyTypeDesc4("");
                        continue;
                    }
                    if (i != 5) continue;
                    supplier.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                    DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                    if (dicItem5 != null) {
                        supplier.setSecondCompanyTypeDesc5(dicItem5.getName());
                        continue;
                    }
                    supplier.setSecondCompanyTypeDesc5("");
                }
            }
        }
    }

    private void setFirstCompanyType(Company company, Supplier supplier) {
        DicGroupItem dicItem;
        supplier.setFirstCompanyType2(company.getBusinessType());
        supplier.setFirstCompanyType3(company.getClassificationThree());
        if (StringUtils.isNotBlank((String)company.getFirstCompanyType())) {
            dicItem = this.dicGroupItemService.queryItems("zr_gongsizhuyingyilei", company.getFirstCompanyType());
            supplier.setFirstCompanyTypeDesc(dicItem.getName());
            supplier.setFirstCompanyType1(company.getFirstCompanyType());
            supplier.setFirstCompanyType4(company.getFirstCompanyType());
        }
        if (StringUtils.isNotEmpty((String)company.getBusinessType())) {
            dicItem = this.dicGroupItemService.queryItems("sap_business_type", company.getBusinessType());
            if (dicItem != null) {
                supplier.setBusinessTypeDesc(dicItem.getName());
            } else {
                supplier.setBusinessTypeDesc("");
            }
        }
        if (StringUtils.isNotEmpty((String)company.getClassificationThree())) {
            if (company.getClassificationThree().equals(ClassificationThreeEnum.ONE.getCode())) {
                supplier.setClassificationThreeDesc(ClassificationThreeEnum.ONE.getValue());
            } else if (company.getClassificationThree().equals(ClassificationThreeEnum.TWO.getCode())) {
                supplier.setClassificationThreeDesc(ClassificationThreeEnum.TWO.getValue());
            } else if (company.getClassificationThree().equals(ClassificationThreeEnum.THREE.getCode())) {
                supplier.setClassificationThreeDesc(ClassificationThreeEnum.THREE.getValue());
            } else if (company.getClassificationThree().equals(ClassificationThreeEnum.FOUR.getCode())) {
                supplier.setClassificationThreeDesc(ClassificationThreeEnum.FOUR.getValue());
            } else {
                supplier.setClassificationThreeDesc("");
            }
        }
    }

    private void setSupplierCertification(Project project, Supplier supplier) throws ParseException {
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
        List companyAuthList = this.companyAuthService.queryAllObjByExample((IExample)companyAuthExample);
        if (CollectionUtils.isNotEmpty((Collection)companyAuthList)) {
            JSONArray json;
            CompanyAuth companyAuth1 = (CompanyAuth)companyAuthList.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth1.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth1.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            supplier.setIATF16949FileName(str);
            supplier.setIATF16949Name(companyAuth1.getCertificateFile());
            supplier.setIATF16949EndTime(companyAuth1.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
        List companyAuthList2 = this.companyAuthService.queryAllObjByExample((IExample)companyAuthExample);
        if (CollectionUtils.isNotEmpty((Collection)companyAuthList2)) {
            JSONArray json;
            CompanyAuth companyAuth2 = (CompanyAuth)companyAuthList2.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth2.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth2.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            supplier.setISO9001FileName(str);
            supplier.setISO9001Name(companyAuth2.getCertificateFile());
            supplier.setISO9001EndTime(companyAuth2.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
        List companyAuthList3 = this.companyAuthService.queryAllObjByExample((IExample)companyAuthExample);
        if (CollectionUtils.isNotEmpty((Collection)companyAuthList3)) {
            JSONArray json;
            CompanyAuth companyAuth3 = (CompanyAuth)companyAuthList3.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth3.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth3.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            supplier.setISO14000FileName(str);
            supplier.setISO14000Name(companyAuth3.getCertificateFile());
            supplier.setISO14000EndTime(companyAuth3.getEndTime());
        }
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<Company> companyList) {
        Assert.isNotEmpty(companyList, (String)"\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a");
        FileData fileData = this.supplierService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), companyList);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355,\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForPur(@RequestBody(required=true) List<Company> companyList) throws IOException, ParseException, WriteException, Exception {
        Assert.isNotEmpty(companyList, (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a");
        ArrayList<String> srmCompanyList = new ArrayList<String>();
        for (Company company : companyList) {
            srmCompanyList.add(company.getCompanyCode());
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andCompanyCodeIn(srmCompanyList).andIsEnableEqualTo(Constant.YES_INT).andProjectIdEqualTo(ProjectUtils.getProjectId());
        List companys = this.companyService.queryAllObjByExample((IExample)companyExample);
        List<Supplier> supplierList = this.getSuppliers(companys);
        List<TitleAndModelKey> titleAndModelKeys = this.supplierService.createExcelHeaderForPur();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, supplierList, "\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355", "\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355", 0);
        return ResponseResult.success((Object)fileData);
    }
}

