/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.certificate.util;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;

@Service
public class ExpirationRemindingJob {
    @Resource
    private CertificateExpiryService certificateExpiryService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyService companyService;
    @Resource
    private RemindInfoService remindInfoService;

    public void remindInformation() {
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIsEnableRemindersEqualTo(Constant.YES_INT);
        List certificateList = this.certificateExpiryService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)certificateList)) {
            return;
        }
        for (CertificateExpiry certificate : certificateList) {
            CompanyAuthExample authExample = new CompanyAuthExample();
            authExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(certificate.getClassificationName()).andEndTimeIsNotNull();
            List authList = this.companyAuthService.queryAllObjByExample((IExample)authExample);
            if (CollectionUtils.isEmpty((Collection)authList)) continue;
            for (CompanyAuth auth : authList) {
                Company company;
                if (!DateUtils.isSameDay((Date)auth.getEndTime(), (Date)DateUtils.addDays((Date)new Date(), (int)certificate.getAdvanceReminderDays())) || null == (company = (Company)this.companyService.queryObjById((Object)auth.getSupCompanyId()))) continue;
                RemindInfo remindInfo = new RemindInfo();
                remindInfo.setSupCompanyId(company.getId());
                remindInfo.setSupCompanyName(company.getCompanyFullName());
                remindInfo.setSupCompanySrmCode(company.getCompanyCode());
                remindInfo.setCertificateTypeCode(auth.getCertificateTypeCode());
                remindInfo.setCertificateName(CertificateTypeCodeEnum.getDesc(auth.getCertificateTypeCode()));
                remindInfo.setEndTime(auth.getEndTime());
                remindInfo.setIsEnable(Constant.YES_INT);
                remindInfo.setCreateTime(new Date());
                remindInfo.setStatus(Constant.NO_INT);
                this.remindInfoService.addObj(remindInfo);
            }
        }
    }
}

