/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetMapper;
import com.els.base.certification.supplierchangesheet.emum.ApproveStatus;
import com.els.base.certification.supplierchangesheet.emum.ChangType;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILE;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupplierChangeSheetService")
public class SupplierChangeSheetServiceImpl
implements SupplierChangeSheetService,
ITaskListener {
    private Logger logger = LoggerFactory.getLogger(SupplierChangeSheetServiceImpl.class);
    @Resource
    protected SupplierChangeSheetMapper supplierChangeSheetMapper;
    @Resource
    protected GenerateCodeService generatecodeservice;
    @Resource
    protected SupplierChangeSheetDETAILEService SupplierChangeSheetDetaleService;
    @Resource
    protected SupAuthenticationService supAuthenticationService;
    @Resource
    protected WorkFlowService workFlowService;
    private final String CHANGE_BILL_NO = "CHANGE_BILL_NO";

    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addObj(SupplierChangeSheet t) {
        Assert.isNotNull((Object)t, (String)"\u53d8\u66f4\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(t.getSupplierChangeSheetDetaileList(), (String)"\u53d8\u66f4\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u5426\u5219\u65e0\u6cd5\u751f\u6210\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5355");
        Company purCompanyOfCurrcntConparry = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getLoginName());
        t.setSupplierSapCode(purCompanyOfCurrcntConparry.getCompanySapCode());
        t.setSupCompanyId(purCompanyOfCurrcntConparry.getCompanyCode());
        t.setSupplierName(purCompanyOfCurrcntConparry.getCompanyName());
        t.setChangType(ChangType.INFORMATION.getCode());
        t.setUpdateTime(new Date());
        if (t.getSupplierChangeSheetDetaileList().size() > 0 && !t.getSupplierChangeSheetDetaileList().isEmpty()) {
            List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
            for (int i = 0; i < list.size(); ++i) {
                SupplierChangeSheetDETAILE supplierChangeSheetDETAILE = list.get(i);
                supplierChangeSheetDETAILE.setChangeBillNo(ChangeBillNos);
                supplierChangeSheetDETAILE.setCreateTime(new Date());
                String content = supplierChangeSheetDETAILE.getContent();
                String changeContent = supplierChangeSheetDETAILE.getChangeContent();
                if (!content.equals(changeContent)) continue;
                throw new CommonException("\u539f\u5185\u5bb9\u4e0e\u66f4\u6539\u5185\u5bb9\u4e0d\u80fd\u76f8\u540c");
            }
            this.SupplierChangeSheetDetaleService.addAll(list);
            this.supplierChangeSheetMapper.insertSelective(t);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addCertification(SupplierChangeSheet t) {
        Assert.isNotNull((Object)t, (String)"\u53d8\u66f4\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Company purCompanyOfCurrcntConparry = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getLoginName());
        t.setSupplierSapCode(purCompanyOfCurrcntConparry.getCompanySapCode());
        t.setSupCompanyId(purCompanyOfCurrcntConparry.getCompanyCode());
        t.setSupplierName(purCompanyOfCurrcntConparry.getCompanyName());
        t.setChangType(ChangType.QUALIFICATION.getCode());
        t.setUpdateTime(new Date());
        if (t.getSupAuthenticationList() != null && !t.getSupAuthenticationList().isEmpty()) {
            List<SupAuthentication> list = t.getSupAuthenticationList();
            for (int i = 0; i < list.size(); ++i) {
                SupAuthentication supAuthentication = list.get(i);
                if (supAuthentication.getAttachment() == null) {
                    throw new CommonException("\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e0a\u4f20\u9644\u4ef6");
                }
                supAuthentication.setChangbillno(ChangeBillNos);
                supAuthentication.setIsEnable(1);
                supAuthentication.setUpdateDate(new Date());
            }
            this.supAuthenticationService.addAll(list);
            this.supplierChangeSheetMapper.insertSelective(t);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addCertifications(List<SupAuthentication> list) {
        Company purCompanyOfCurrcntConparry = CompanyUtils.currentCompany();
        User loginUser = SpringSecurityUtils.getLoginUser();
        SupplierChangeSheet t = new SupplierChangeSheet();
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getLoginName());
        t.setSupplierSapCode(purCompanyOfCurrcntConparry.getCompanySapCode());
        t.setSupCompanyId(purCompanyOfCurrcntConparry.getCompanyCode());
        t.setSupplierName(purCompanyOfCurrcntConparry.getCompanyName());
        t.setChangType(ChangType.QUALIFICATION.getCode());
        t.setCreateBillTime(new Date());
        t.setUpdateTime(new Date());
        for (SupAuthentication supAuthentication : list) {
            supAuthentication.setChangbillno(ChangeBillNos);
            supAuthentication.setIsEnable(1);
            supAuthentication.setUpdateDate(new Date());
        }
        this.supAuthenticationService.addAll(list);
        this.supplierChangeSheetMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void deleteObjById(String id) {
        SupplierChangeSheet sc = this.supplierChangeSheetMapper.selectByPrimaryKey(id);
        if (sc.getApproveStatus() != 1) {
            throw new CommonException("\u53ea\u6709\u65b0\u5efa\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664");
        }
        String changeBillNo = sc.getChangeBillNo();
        List<SupplierChangeSheetDETAILE> selectBill2 = this.SupplierChangeSheetDetaleService.selectBill(changeBillNo);
        for (SupplierChangeSheetDETAILE supplierChangeSheetDETAILE : selectBill2) {
            if (!StringUtils.isBlank((String)supplierChangeSheetDETAILE.getChangeBillNo())) continue;
            this.SupplierChangeSheetDetaleService.deleteByChangeBillNo(changeBillNo);
        }
        List<SupAuthentication> selectBill = this.supAuthenticationService.selectBill(changeBillNo);
        for (SupAuthentication supAuthentication : selectBill) {
            if (!StringUtils.isBlank((String)supAuthentication.getChangbillno())) continue;
            this.supAuthenticationService.deleteByChangeBillNo(changeBillNo);
        }
        this.supplierChangeSheetMapper.deleteByPrimaryKey(id);
    }

    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void modifyObj(SupplierChangeSheet t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        String changeBillNo = t.getChangeBillNo();
        if (t.getSupplierChangeSheetDetaileList() != null && !t.getSupplierChangeSheetDetaileList().isEmpty()) {
            this.SupplierChangeSheetDetaleService.deleteByChangeBillNo(changeBillNo);
            List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
            for (SupplierChangeSheetDETAILE sc : list) {
                String changeContent;
                sc.setChangeBillNo(changeBillNo);
                sc.setCreateTime(new Date());
                String content = sc.getContent();
                if (!content.equals(changeContent = sc.getChangeContent())) continue;
                throw new CommonException("\u539f\u5185\u5bb9\u4e0e\u66f4\u6539\u5185\u5bb9\u4e0d\u80fd\u76f8\u540c");
            }
            this.SupplierChangeSheetDetaleService.addAll(list);
        }
        if (t.getSupAuthenticationList() != null && !t.getSupAuthenticationList().isEmpty()) {
            this.supAuthenticationService.deleteByChangeBillNo(changeBillNo);
            List<SupAuthentication> supAuthenticationList = t.getSupAuthenticationList();
            for (SupAuthentication supAuthentication : supAuthenticationList) {
                supAuthentication.setChangbillno(changeBillNo);
                supAuthentication.setIsEnable(1);
                supAuthentication.setUpdateDate(new Date());
            }
            t.setUpdateTime(new Date());
            this.supAuthenticationService.addAll(supAuthenticationList);
        }
        this.supplierChangeSheetMapper.updateByPrimaryKeySelective(t);
    }

    @Transactional
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public SupplierChangeSheet queryObjById(String id) {
        SupplierChangeSheet sc = this.supplierChangeSheetMapper.selectByPrimaryKey(id);
        sc.setSupplierChangeSheetDetaileList(this.SupplierChangeSheetDetaleService.selectBill(sc.getChangeBillNo()));
        List<SupAuthentication> selectBill = this.supAuthenticationService.selectBill(sc.getChangeBillNo());
        sc.setSupAuthenticationList(selectBill);
        return sc;
    }

    @Transactional
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public List<SupplierChangeSheet> queryAllObjByExample(SupplierChangeSheetExample example) {
        return this.supplierChangeSheetMapper.selectByExample(example);
    }

    @Transactional
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierChangeSheet> queryObjByPage(SupplierChangeSheetExample example) {
        PageView<SupplierChangeSheet> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierChangeSheetMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void approve(String id) {
        Assert.isNotBlank((String)id, (String)"\u6a21\u7248\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        SupplierChangeSheet supplierChangeSheet = this.queryObjById(id);
        ProcessStartVO vo = ProcessStartVO.newInstance((String)"cgb", (String)supplierChangeSheet.getChangeBillNo(), (String)supplierChangeSheet.getId(), (String)("informationChangeRequest?id=" + supplierChangeSheet.getId()));
        vo.setListenerClass(this.getClass());
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess != null) {
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.TOAUDIT.getCode());
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
        }
    }

    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            this.logger.info("\u76d1\u542c\u4efb\u52a1\u4e3a\u7a7a-----");
            return;
        }
        String businessId = event.getBusinessId();
        this.logger.info("\u83b7\u53d6\u4e1a\u52a1ID-----");
        if (StringUtils.isBlank((String)businessId)) {
            this.logger.info("\u83b7\u53d6\u4e1a\u52a1ID\u4e3a\u7a7a-----");
            return;
        }
        SupplierChangeSheet supplierChangeSheet = this.queryObjById(businessId);
        String assignee = StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u4eba\u548c\u5ba1\u6279\u610f\u89c1-----");
        if (event.isFinished() && event.isPass()) {
            this.logger.info("\u8fdb\u5165\u5230\u5ba1\u6279\u6d41\u5b8c\u6210\u800c\u4e14\u901a\u8fc7-----");
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.AUDITED.getCode());
            supplierChangeSheet.setApproveResult(result);
            this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u548c\u5ba1\u6279\u7ed3\u679c\u5b8c\u6210-----");
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
            this.logger.info("\u8ddf\u65b0\u53d8\u66f4\u5355-----");
        } else if (event.isFinished() && !event.isPass()) {
            this.logger.info("\u8fdb\u5165\u5230\u5ba1\u6279\u6d41\u5b8c\u6210\u4f46\u672a\u901a\u8fc7-----");
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.REFUSED.getCode());
            supplierChangeSheet.setApproveResult(result);
            this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u548c\u5ba1\u6279\u7ed3\u679c\u5b8c\u6210-----");
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
            this.logger.info("\u8ddf\u65b0\u53d8\u66f4\u5355-----");
        }
    }

    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void deleteByExample(SupplierChangeSheetExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supplierChangeSheetMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    @Transactional
    public void addAll(List<SupplierChangeSheet> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.supplierChangeSheetMapper.insertSelective((SupplierChangeSheet)record));
    }
}

