/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.SupAuthenticationMapper;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupAuthenticationService")
public class SupAuthenticationServiceImpl
implements SupAuthenticationService {
    @Resource
    protected SupAuthenticationMapper supAuthenticationMapper;

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    public void addObj(SupAuthentication t) {
        this.supAuthenticationMapper.insertSelective(t);
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supAuthenticationMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    public void deleteObjBychangeBillNo(String changeBillNo) {
        this.supAuthenticationMapper.deleteByChangeBillNo(changeBillNo);
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    public void modifyObj(SupAuthentication t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supAuthenticationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public SupAuthentication queryObjById(String id) {
        return this.supAuthenticationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public List<SupAuthentication> queryAllObjByExample(SupAuthenticationExample example) {
        return this.supAuthenticationMapper.selectByExample(example);
    }

    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public PageView<SupAuthentication> queryObjByPage(SupAuthenticationExample example) {
        PageView<SupAuthentication> pageView = example.getPageView();
        pageView.setQueryResult(this.supAuthenticationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public void deleteByChangeBillNo(String changeBillNo) {
        this.supAuthenticationMapper.deleteByChangeBillNo(changeBillNo);
    }

    @Override
    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public List<SupAuthentication> selectBill(String changeBillNo) {
        List<SupAuthentication> selectBill = this.supAuthenticationMapper.selectBill(changeBillNo);
        return selectBill;
    }

    @Override
    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public void addAttachment(SupAuthentication supAuthentication) {
        String id = supAuthentication.getId();
        if (org.springframework.util.StringUtils.isEmpty((Object)id)) {
            throw new CommonException("\u5408\u540c\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.supAuthenticationMapper.updateByPrimaryKeySelective(supAuthentication);
    }

    @Override
    @Cacheable(value={"supAuthentication"}, keyGenerator="redisKeyGenerator")
    public List<SupAuthentication> selectEffective() {
        return this.supAuthenticationMapper.selectEffective();
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    public void deleteByExample(SupAuthenticationExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supAuthenticationMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supAuthentication"}, allEntries=true)
    @Transactional
    public void addAll(List<SupAuthentication> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.supAuthenticationMapper.insertSelective((SupAuthentication)record));
    }
}

