/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.device.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.device.entity.CompanyProductDevice;
import com.els.base.certification.device.entity.CompanyProductDeviceExample;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5173\u952e\u751f\u4ea7\u8bbe\u5907")
@Controller
@RequestMapping(value={"companyProductDevice"})
public class CompanyProductDeviceController {
    @Resource
    protected CompanyProductDeviceService companyProductDeviceService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5173\u952e\u751f\u4ea7\u8bbe\u5907")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> create(@RequestBody List<CompanyProductDevice> productDeviceList) {
        if (CollectionUtils.isEmpty(productDeviceList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CompanyProductDevice companyProductDevice : productDeviceList) {
            if (StringUtils.isBlank((String)companyProductDevice.getDeviceName())) {
                throw new CommonException("\u8bbe\u5907\u540d\u79f0/\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (companyProductDevice.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
                throw new CommonException("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (companyProductDevice.getOperationType() == null) {
                throw new CommonException("\u8bbe\u5907\u76ee\u524d\u662f\u5426\u8fd0\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (companyProductDevice.getDeviceProduceTime() != null) continue;
            throw new CommonException("\u8bbe\u5907\u751f\u4ea7\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        Integer productDevice = this.companyProductDeviceService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), productDeviceList);
        companyFinishFlag.setMainProductDevice(productDevice);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("mainProductDevice", productDevice);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u5173\u952e\u751f\u4ea7\u8bbe\u5907")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyProductDevice companyProductDevice) {
        if (StringUtils.isBlank((String)companyProductDevice.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.companyProductDeviceService.modifyObj(companyProductDevice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u5173\u952e\u751f\u4ea7\u8bbe\u5907")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u5217\u8868\u4e3a\u7a7a!");
        }
        this.companyProductDeviceService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5173\u952e\u751f\u4ea7\u8bbe\u5907")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyProductDevice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProductDevice>> findByPage(@RequestParam(required=false) String supCompanySrmCode, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyProductDeviceExample example = new CompanyProductDeviceExample();
        example.setPageView((PageView<CompanyProductDevice>)new PageView(pageNo, pageSize));
        CompanyProductDeviceExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyProductDeviceService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyProductDevice>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyProductDeviceExample example = new CompanyProductDeviceExample();
        CompanyProductDeviceExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId());
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List list = this.companyProductDeviceService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)list);
    }
}

