/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.suppliercategory.web.controller;

import com.els.base.certification.suppliercategory.dao.SupplierCategoryMapper;
import com.els.base.certification.suppliercategory.entity.SupplierCategory;
import com.els.base.certification.suppliercategory.entity.SupplierCategoryExample;
import com.els.base.certification.suppliercategory.service.SupplierCategoryService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u5206\u7c7b\u7ba1\u7406")
@Controller
@RequestMapping(value={"supplierCategory"})
public class SupplierCategoryController {
    private static final Integer YES_INABLED = 1;
    @Resource
    protected SupplierCategoryService supplierCategoryService;
    @Resource
    protected SupplierCategoryMapper supplierCategoryMapper;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u628a\u4f9b\u5e94\u5546\u4fe1\u606f\u6dfb\u52a0\u5230\u5206\u7c7b\u4e2d\u53bb")
    @RequestMapping(value={"service/addSupCategory"})
    @ResponseBody
    public ResponseResult<String> addSupCategory(@RequestParam String supplierCategoryId, @RequestParam String companyId) {
        Company company = (Company)this.companyService.queryObjById((Object)companyId);
        if (company == null) {
            throw new CommonException("\u6ca1\u6709\u627e\u5230\u6b64\u4f9b\u5e94\u5546");
        }
        company.setCategoryId(supplierCategoryId);
        this.supplierCategoryService.addSupCategory(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u5206\u7c7b\u7ba1\u7406")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupplierCategory supplierCategory) {
        if (StringUtils.isEmpty((String)supplierCategory.getCompanyCategory())) {
            throw new CommonException("\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)supplierCategory.getCategoryCode())) {
            throw new CommonException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (supplierCategory.getCategoryCode().length() > 255) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801", 255});
        }
        if (supplierCategory.getCompanyCategory().length() > 255) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0", 255});
        }
        supplierCategory.setCreateTime(new Date());
        this.supplierCategoryService.addObj(supplierCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u5206\u7c7b\u7ba1\u7406")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupplierCategory supplierCategory) {
        if (StringUtils.isBlank((String)supplierCategory.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isEmpty((String)supplierCategory.getCompanyCategory())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)supplierCategory.getCategoryCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (supplierCategory.getCategoryCode().length() > 255) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801", 255});
        }
        if (supplierCategory.getCompanyCategory().length() > 255) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", new Object[]{"\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u79f0", 255});
        }
        boolean flag = false;
        SupplierCategory obj = (SupplierCategory)this.supplierCategoryService.queryObjById(supplierCategory.getId());
        if (null == obj) {
            throw new CommonException("\u8be5id\u67e5\u4e0d\u5230\u6570\u636e");
        }
        String categoryCode = obj.getCategoryCode();
        if (StringUtils.isNotBlank((String)categoryCode) && !categoryCode.equals(supplierCategory.getCategoryCode())) {
            flag = true;
        }
        if (flag) {
            SupplierCategoryExample materialCategoryExample = new SupplierCategoryExample();
            materialCategoryExample.createCriteria().andCategoryCodeEqualTo(supplierCategory.getCategoryCode()).andIsEnableEqualTo(YES_INABLED);
            if (this.supplierCategoryMapper.countByExample(materialCategoryExample) > 0) {
                throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728!");
            }
        }
        supplierCategory.setUpdateTime(new Date());
        this.supplierCategoryService.modifyObj(supplierCategory);
        return ResponseResult.success();
    }

    @Transactional
    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u5206\u7c7b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@ApiParam(value="\u5206\u7c7bID") @RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.supplierCategoryService.deleteObjById(id);
        SupplierCategoryExample example = new SupplierCategoryExample();
        example.createCriteria().andIdEqualTo(id);
        if (this.supplierCategoryMapper.countByExample(example) > 0) {
            List list = this.supplierCategoryService.queryAllObjByExample((IExample)example);
            for (SupplierCategory supplierCategory : list) {
                this.supplierCategoryService.deleteCascadedMaterialCategoryInfo(supplierCategory.getId());
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7684\u4f9b\u5e94\u5546\u5206\u7c7b\u4fe1\u606f\u53ca\u5173\u8054\u7684\u5b50\u4f9b\u5e94\u5546\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/findAllSupplierCategoryInfo"})
    @ResponseBody
    public ResponseResult<List<SupplierCategory>> findAllMaterialCategoryInfo() {
        SupplierCategoryExample example = new SupplierCategoryExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.createCriteria().andIsEnableEqualTo(YES_INABLED).andParentIdIsNull();
        List supplierCategoryList = this.supplierCategoryService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)supplierCategoryList)) {
            throw new CommonException("\u4e00\u7ea7\u5206\u7c7b\u4e3a\u7a7a");
        }
        for (SupplierCategory supplierCategory : supplierCategoryList) {
            supplierCategory.setSupplierCategoryList(this.supplierCategoryService.queryByParentId(supplierCategory.getId()));
        }
        return ResponseResult.success((Object)supplierCategoryList);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupAuthentication", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierCategory>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierCategoryExample example = new SupplierCategoryExample();
        example.setPageView((PageView<SupplierCategory>)new PageView(pageNo, pageSize));
        SupplierCategoryExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supplierCategoryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u8be2\u5e94\u5546\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<List<SupplierCategory>> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        List<SupplierCategory> supplierCategoryList = this.supplierCategoryService.queryByParentId(id);
        return ResponseResult.success(supplierCategoryList);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u8be2\u5e94\u5546\u5206\u7c7b\u4fe1\u606f")
    @RequestMapping(value={"service/queryById"})
    @ResponseBody
    public ResponseResult<SupplierCategory> queryById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SupplierCategory supplierCategory = (SupplierCategory)this.supplierCategoryService.queryObjById(id);
        return ResponseResult.success((Object)supplierCategory);
    }
}

