/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.notice.service.impl;

import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.notice.dao.CompanyAuditNoticeMapper;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.qualification.util.QualificationImTemplet;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyAuditNoticeService")
public class CompanyAuditNoticeServiceImpl
implements CompanyAuditNoticeService {
    private static final String IM_CODE = "COMPANY_FIELD_INVESTIGATION_NOTICE";
    @Resource
    private CompanyAuditNoticeMapper companyAuditNoticeMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private UserService userService;
    @Resource
    private ProcessService processService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void confirm(CompanyAuditNotice data) {
        if (null == data) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        Assert.isNotBlank((String)data.getSupReplyInformation(), (String)"\u4f9b\u5e94\u5546\u56de\u590d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdEqualTo(data.getId()).andConfirmStatusEqualTo(Constant.YES_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u662f\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdEqualTo(data.getId()).andSendStatusEqualTo(Constant.NO_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u662f\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        final CompanyAuditNotice companyAuditNotice = this.queryObjById(data.getId());
        if (null == companyAuditNotice) {
            return;
        }
        companyAuditNotice.setConfirmStatus(Constant.YES_INT);
        companyAuditNotice.setSupReplyInformation(data.getSupReplyInformation());
        this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                QualificationImTemplet templet = CompanyAuditNoticeServiceImpl.this.constructImInfo(2, "\u5df2\u786e\u8ba4", companyAuditNotice);
                CompanyAuditNoticeServiceImpl.this.sendMessagesToPur(templet, companyAuditNotice);
            }
        });
    }

    private void sendMessagesToPur(QualificationImTemplet templet, CompanyAuditNotice companyAuditNotice) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(companyAuditNotice.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(companyAuditNotice.getSupUserId()).addReceiverId(companyAuditNotice.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void abolish(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.NO_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> theseElements = new ArrayList<Integer>();
        theseElements.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        theseElements.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andConfirmStatusIn(theseElements);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u8005\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void send(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids);
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setSendStatus(Constant.YES_INT);
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);
        final List<CompanyAuditNotice> companyAuditNoticeList = this.companyAuditNoticeMapper.selectByExample(companyAuditNoticeExample);
        if (CollectionUtils.isEmpty(companyAuditNoticeList)) {
            return;
        }
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                companyAuditNoticeList.forEach(auditNotice -> {
                    QualificationImTemplet templet = CompanyAuditNoticeServiceImpl.this.constructImInfo(1, "\u5df2\u53d1\u9001", auditNotice);
                    CompanyAuditNoticeServiceImpl.this.sendMessagesToSup(templet, auditNotice);
                });
            }
        });
    }

    private QualificationImTemplet constructImInfo(int role, String operate, CompanyAuditNotice companyAuditNotice) {
        Assert.isNotNull((Object)companyAuditNotice, (String)"\u53d1\u9001\u7684\u6570\u636e\u4e3a\u7a7a");
        QualificationImTemplet qualificationImTemplet = new QualificationImTemplet();
        if (1 == role) {
            qualificationImTemplet.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotBlank((String)companyAuditNotice.getPurCompanyName())) {
                qualificationImTemplet.setCompanyName(companyAuditNotice.getPurCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        } else {
            qualificationImTemplet.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotBlank((String)companyAuditNotice.getSupCompanyName())) {
                qualificationImTemplet.setCompanyName(companyAuditNotice.getSupCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        }
        Assert.isNotBlank((String)operate, (String)"\u64cd\u4f5c\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u53d1\u9001\u6d88\u606f");
        qualificationImTemplet.setOperate(operate);
        qualificationImTemplet.setOtherInfo("\u4e86\u73b0\u573a\u8003\u5bdf\u901a\u77e5\u5355\uff0c\u5355\u636e\u53f7\u4e3a\uff1a");
        qualificationImTemplet.setBillList(companyAuditNotice.getAuditNoticeNo());
        return qualificationImTemplet;
    }

    private void sendMessagesToSup(QualificationImTemplet templet, CompanyAuditNotice companyAuditNotice) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(companyAuditNotice.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(companyAuditNotice.getPurUserId()).addReceiverId(companyAuditNotice.getSupUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        if (this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample) > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setIsEnable(Constant.NO_INT);
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.NO_INT);
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);
        List<CompanyAuditNotice> companyAuditNoticeList = this.queryAllObjByExample(companyAuditNoticeExample);
        Assert.isNotEmpty(companyAuditNoticeList, (String)"\u67e5\u8be2\u51fa\u7684\u901a\u77e5\u5355\u4fe1\u606f\u4e3a\u7a7a");
        companyAuditNoticeList.forEach(auditNotice -> {
            Process process = this.processService.queryObjByCompanyId(auditNotice.getSupCompanyId());
            Assert.isNotNull((Object)process, (String)"\u6839\u636e\u4f9b\u5e94\u5546ID\u67e5\u51fa\u7684\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f\u4e3a\u7a7a");
            process.setSceneInvestigate(null);
            this.processService.updateById(process);
        });
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void insert(Company purCompany, User purUser, CompanyAuditNotice companyAuditNotice) {
        if (companyAuditNotice == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        this.setSupCompanyInfo(companyAuditNotice);
        this.setPurCompanyInfo(purCompany, companyAuditNotice);
        this.setCompanyAuditNoticeInfo(purUser, companyAuditNotice);
        if (StringUtils.isEmpty((String)companyAuditNotice.getId())) {
            String auditNoticeNo = this.generateCodeService.getNextCode("AUDIT_NOTICE_NO");
            companyAuditNotice.setAuditNoticeNo(auditNoticeNo);
            this.companyAuditNoticeMapper.insertSelective(companyAuditNotice);
            Process process = this.processService.queryObjByCompanyId(companyAuditNotice.getSupCompanyId());
            process.setSceneInvestigate(ReviewResultEnum.AUDIT.getCode());
            this.processService.modifyObj(process);
        } else {
            companyAuditNotice.setUpdateTime(new Date());
            this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);
        }
    }

    private void setCompanyAuditNoticeInfo(User purUser, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setCreateBillName(purUser.getNickName());
        companyAuditNotice.setCreateTime(new Date());
        companyAuditNotice.setPurUserId(purUser.getId());
        companyAuditNotice.setIsEnable(Constant.YES_INT);
        companyAuditNotice.setSendStatus(Constant.NO_INT);
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_UNCONFIRM.getStatus());
    }

    private void setPurCompanyInfo(Company company, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setPurCompanyId(company.getId());
        companyAuditNotice.setPurCompanyName(company.getCompanyName());
        companyAuditNotice.setPurCompanyFullName(company.getCompanyFullName());
        companyAuditNotice.setPurCompanySrmCode(company.getCompanyCode());
        companyAuditNotice.setPurCompanySapCode(company.getCompanySapCode());
    }

    private void setSupCompanyInfo(CompanyAuditNotice companyAuditNotice) {
        Company company = this.companyService.queryCompanyByCode(companyAuditNotice.getSupCompanySrmCode());
        Assert.isNotNull((Object)company, (String)"\u6839\u636e\u4f9b\u5e94\u5546srm\u7f16\u7801\u67e5\u8be2\u51fa\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a");
        User supUser = this.companyUserRefService.queryMainUserOfCompany(company.getId());
        Assert.isNotNull((Object)supUser, (String)"\u6b64\u4f9b\u5e94\u5546\u6ca1\u6709\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\uff0c\u65b0\u5efa\u5931\u8d25");
        companyAuditNotice.setSupCompanyId(company.getId());
        companyAuditNotice.setSupCompanySrmCode(company.getCompanyCode());
        companyAuditNotice.setSupCompanySapCode(company.getCompanySapCode());
        companyAuditNotice.setSupCompanyName(company.getCompanyName());
        companyAuditNotice.setSupCompanyFullName(company.getCompanyFullName());
        companyAuditNotice.setSupCompanyContacts(company.getContacts());
        companyAuditNotice.setSupCompanyAddress(company.getAddress());
        companyAuditNotice.setSupUserId(supUser.getId());
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void addObj(CompanyAuditNotice t) {
        this.companyAuditNoticeMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyAuditNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void modifyObj(CompanyAuditNotice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyAuditNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public CompanyAuditNotice queryObjById(String id) {
        return this.companyAuditNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public List<CompanyAuditNotice> queryAllObjByExample(CompanyAuditNoticeExample example) {
        return this.companyAuditNoticeMapper.selectByExample(example);
    }

    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyAuditNotice> queryObjByPage(CompanyAuditNoticeExample example) {
        PageView<CompanyAuditNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAuditNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void deleteByExample(CompanyAuditNoticeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyAuditNoticeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyAuditNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyAuditNoticeMapper.insertSelective((CompanyAuditNotice)record));
    }
}

