/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.result.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.qualification.util.QualificationImTemplet;
import com.els.base.certification.result.dao.CompanyResultNoticeMapper;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.certification.result.util.ResultNoticeEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyResultNoticeService")
public class CompanyResultNoticeServiceImpl
implements CompanyResultNoticeService,
ITaskListener {
    private static final String IM_CODE = "COMPANY_FIELD_INVESTIGATION_RESULT";
    @Resource
    private CompanyResultNoticeMapper companyResultNoticeMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProcessService processService;
    @Resource
    private ThreadPoolTaskExecutor defaultPoolTask;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void send(Project project, Company company, User loginUser, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId());
        int count = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andProjectIdEqualTo(project.getId());
        List<CompanyResultNotice> companyResultNotices = this.companyResultNoticeMapper.selectByExample(companyResultNoticeExample);
        if (CollectionUtils.isEmpty(companyResultNotices)) {
            return;
        }
        for (CompanyResultNotice companyResultNotice : companyResultNotices) {
            companyResultNotice.setSendStatus(Constant.YES_INT);
            this.companyResultNoticeMapper.updateByPrimaryKeySelective(companyResultNotice);
        }
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u5168\u662f\u672a\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u5220\u9664\u64cd\u4f5c!");
        }
        CompanyResultNotice companyResultNotice = new CompanyResultNotice();
        companyResultNotice.setIsEnable(Constant.NO_INT);
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        this.companyResultNoticeMapper.updateByExampleSelective(companyResultNotice, companyResultNoticeExample);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void adopt(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u4f20\u5165\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u901a\u8fc7\u5ba1\u6838\u6216\u7ec8\u6b62\u5ba1\u6838\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        final List<CompanyResultNotice> noticeList = this.queryAllObjByExample(companyResultNoticeExample);
        Assert.isNotEmpty(noticeList, (String)"\u6839\u636e\u4f20\u5165\u7684ID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        noticeList.forEach(notice -> {
            if (ResultNoticeEnum.RECTIFICATION.getCode().equals(notice.getConfirmStatus()) && Constant.NO_INT == notice.getSendStatus()) {
                throw new CommonException("\u4f9b\u5e94\u5546\uff1a" + notice.getSupCompanySrmCode() + "\u7684\u5355\u636e\u5728\u6574\u6539\u72b6\u6001\u4e0b\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u901a\u8fc7\u5ba1\u6838");
            }
            notice.setConfirmStatus(ResultNoticeEnum.THROUGH_AUDIT.getCode());
            notice.setSendStatus(Constant.NO_INT);
            this.companyResultNoticeMapper.updateByPrimaryKeySelective((CompanyResultNotice)notice);
            Process process = this.processService.queryObjByCompanyId(notice.getSupCompanyId());
            Assert.isNotNull((Object)process, (String)"\u6839\u636e\u4f9b\u5e94\u5546ID\u67e5\u8be2\u7684\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f\u4e3a\u7a7a");
            process.setSceneInvestigate(ReviewResultEnum.ADOPT.getCode());
            process.setUpdateTime(new Date());
            this.processService.modifyObj(process);
        });
        this.defaultPoolTask.execute(new Runnable(){

            @Override
            public void run() {
                noticeList.forEach(notice -> {
                    QualificationImTemplet templet = CompanyResultNoticeServiceImpl.this.constructImInfo(1, "\u53d1\u9001\u4e86\u901a\u8fc7\u5ba1\u6838", notice);
                    CompanyResultNoticeServiceImpl.this.sendMessagesToSup(templet, notice);
                });
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void rectification(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u4f20\u5165\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u901a\u8fc7\u5ba1\u6838\u6216\u7ec8\u6b62\u5ba1\u6838\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u6574\u6539\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        final List<CompanyResultNotice> noticeList = this.companyResultNoticeMapper.selectByExample(companyResultNoticeExample);
        noticeList.forEach(result -> {
            if (ResultNoticeEnum.RECTIFICATION.getCode().equals(result.getConfirmStatus()) && Constant.NO_INT == result.getSendStatus()) {
                throw new CommonException("\u6574\u6539\u72b6\u6001\u4e0b\u7684\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a:" + result.getSupCompanySrmCode() + "\u7684\u4f9b\u5e94\u5546\u5355\u636e\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u8fdb\u884c\u6574\u6539\u64cd\u4f5c");
            }
            result.setConfirmStatus(ResultNoticeEnum.RECTIFICATION.getCode());
            result.setSendStatus(Constant.NO_INT);
            this.companyResultNoticeMapper.updateByPrimaryKeySelective((CompanyResultNotice)result);
        });
        this.defaultPoolTask.execute(new Runnable(){

            @Override
            public void run() {
                noticeList.forEach(notice -> {
                    QualificationImTemplet templet = CompanyResultNoticeServiceImpl.this.constructImInfo(1, "\u53d1\u9001\u4e86\u9700\u8981\u6574\u6539", notice);
                    CompanyResultNoticeServiceImpl.this.sendMessagesToSup(templet, notice);
                });
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void termination(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u4f20\u5165\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u901a\u8fc7\u5ba1\u6838\u6216\u7ec8\u6b62\u5ba1\u6838\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        final List<CompanyResultNotice> noticeList = this.queryAllObjByExample(companyResultNoticeExample);
        Assert.isNotEmpty(noticeList, (String)"\u6839\u636e\u4f20\u5165\u7684\u5355\u636eID\u67e5\u8be2\u51fa\u5355\u636e\u6570\u636e\u4e3a\u7a7a");
        noticeList.forEach(notice -> {
            if (ResultNoticeEnum.RECTIFICATION.getCode().equals(notice.getConfirmStatus()) && Constant.NO_INT == notice.getSendStatus()) {
                throw new CommonException("\u4f9b\u5e94\u5546\uff1a" + notice.getSupCompanySrmCode() + "\u7684\u5355\u636e\u5728\u6574\u6539\u72b6\u6001\u4e0b\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u6267\u884c\u7ec8\u6b62\u5ba1\u6838\u64cd\u4f5c");
            }
            notice.setConfirmStatus(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
            notice.setSendStatus(Constant.NO_INT);
            this.companyResultNoticeMapper.updateByPrimaryKeySelective((CompanyResultNotice)notice);
            Process process = this.processService.queryObjByCompanyId(notice.getSupCompanyId());
            Assert.isNotNull((Object)process, (String)"\u6839\u636e\u4f9b\u5e94\u5546ID\u67e5\u8be2\u7684\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f\u4e3a\u7a7a");
            process.setSceneInvestigate(ReviewResultEnum.TERMINATION.getCode());
            process.setUpdateTime(new Date());
            this.processService.modifyObj(process);
        });
        this.defaultPoolTask.execute(new Runnable(){

            @Override
            public void run() {
                noticeList.forEach(notice -> {
                    QualificationImTemplet templet = CompanyResultNoticeServiceImpl.this.constructImInfo(1, "\u53d1\u9001\u4e86\u7ec8\u6b62\u5ba1\u6838", notice);
                    CompanyResultNoticeServiceImpl.this.sendMessagesToSup(templet, notice);
                });
            }
        });
    }

    private QualificationImTemplet constructImInfo(int role, String operate, CompanyResultNotice companyResultNotice) {
        Assert.isNotNull((Object)companyResultNotice, (String)"\u53d1\u9001\u7684\u6570\u636e\u4e3a\u7a7a");
        QualificationImTemplet qualificationImTemplet = new QualificationImTemplet();
        if (1 == role) {
            qualificationImTemplet.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotBlank((String)companyResultNotice.getPurCompanyName())) {
                qualificationImTemplet.setCompanyName(companyResultNotice.getPurCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        } else {
            qualificationImTemplet.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotBlank((String)companyResultNotice.getSupCompanyName())) {
                qualificationImTemplet.setCompanyName(companyResultNotice.getSupCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        }
        Assert.isNotBlank((String)operate, (String)"\u64cd\u4f5c\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u53d1\u9001\u6d88\u606f");
        qualificationImTemplet.setOperate(operate);
        qualificationImTemplet.setOtherInfo("\u7684\u73b0\u573a\u8003\u5bdf\u7ed3\u679c\u901a\u77e5\u5355\uff0c\u5355\u636e\u53f7\u4e3a\uff1a");
        qualificationImTemplet.setBillList(companyResultNotice.getAuditResultNoticeNo());
        return qualificationImTemplet;
    }

    private void sendMessagesToSup(QualificationImTemplet templet, CompanyResultNotice companyResultNotice) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(companyResultNotice.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(companyResultNotice.getPurUserId()).addReceiverId(companyResultNotice.getSupUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void sendMessagesToPur(QualificationImTemplet templet, CompanyResultNotice companyResultNotice) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(companyResultNotice.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(companyResultNotice.getSupUserId()).addReceiverId(companyResultNotice.getPurUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void supConfirmBill(CompanyResultNotice data) {
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.createCriteria().andIdEqualTo(data.getId()).andSendStatusEqualTo(Constant.YES_INT);
        if (this.companyResultNoticeMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u662f\u5df2\u786e\u8ba4\u5355\u636e\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        final CompanyResultNotice resultNotice = this.queryObjById(data.getId());
        if (null == resultNotice) {
            return;
        }
        resultNotice.setSupReplyInformation(data.getSupReplyInformation());
        resultNotice.setSendStatus(Constant.YES_INT);
        this.companyResultNoticeMapper.updateByPrimaryKeySelective(resultNotice);
        this.defaultPoolTask.execute(new Runnable(){

            @Override
            public void run() {
                QualificationImTemplet templet = CompanyResultNoticeServiceImpl.this.constructImInfo(2, "\u5df2\u786e\u8ba4", resultNotice);
                CompanyResultNoticeServiceImpl.this.sendMessagesToPur(templet, resultNotice);
            }
        });
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void insert(Company purCompany, User user, CompanyResultNotice companyResultNotice) {
        if (companyResultNotice == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        if (StringUtils.isEmpty((String)companyResultNotice.getId())) {
            this.judgeRepetition(companyResultNotice);
            this.setPurCompanyInfo(purCompany, companyResultNotice);
            this.setSupCompanyInfo(companyResultNotice);
            this.setCompanyResultNotice(user, companyResultNotice);
            String auditResultNoticeNo = this.generateCodeService.getNextCode("AUDIT_RESULT_NOTICE_NO");
            companyResultNotice.setAuditResultNoticeNo(auditResultNoticeNo);
            this.companyResultNoticeMapper.insertSelective(companyResultNotice);
        } else {
            CompanyResultNotice notice = this.queryObjById(companyResultNotice.getId());
            if (!notice.getSupCompanySrmCode().equals(companyResultNotice.getSupCompanySrmCode())) {
                this.judgeRepetition(companyResultNotice);
            }
            companyResultNotice.setUpdateTime(new Date());
            this.companyResultNoticeMapper.updateByPrimaryKeySelective(companyResultNotice);
        }
    }

    private void judgeRepetition(CompanyResultNotice companyResultNotice) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.NOT_AUDITED.getCode());
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andSupCompanySrmCodeEqualTo(companyResultNotice.getSupCompanySrmCode()).andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list);
        if (this.companyResultNoticeMapper.countByExample(companyResultNoticeExample) > 0) {
            throw new CommonException("\u6b64\u4f9b\u5e94\u5546\u5df2\u6709\u672a\u5ba1\u6838\u3001\u901a\u8fc7\u5ba1\u6838\u6216\u6574\u6539\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6dfb\u52a0\u4f9b\u5e94\u5546\u7f16\u7801\uff1a" + companyResultNotice.getSupCompanySrmCode());
        }
    }

    private void setCompanyResultNotice(User user, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setCreateBillName(user.getNickName());
        companyResultNotice.setCreateTime(new Date());
        companyResultNotice.setPurUserId(user.getId());
        companyResultNotice.setIsEnable(Constant.YES_INT);
        companyResultNotice.setConfirmStatus(ResultNoticeEnum.NOT_AUDITED.getCode());
        companyResultNotice.setSendStatus(Constant.NO_INT);
    }

    private void setSupCompanyInfo(CompanyResultNotice companyResultNotice) {
        if (StringUtils.isEmpty((String)companyResultNotice.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f9b\u5e94\u5546SRM\u7f16\u7801"});
        }
        Company superCompany = this.companyService.queryCompanyByCode(companyResultNotice.getSupCompanySrmCode());
        Assert.isNotNull((Object)superCompany, (String)"\u6839\u636e\u4f9b\u5e94\u5546srm\u7f16\u7801\u67e5\u8be2\u51fa\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a");
        User user = this.companyUserRefService.queryMainUserOfCompany(superCompany.getId());
        Assert.isNotNull((Object)user, (String)"\u6b64\u4f9b\u5e94\u5546\u6ca1\u6709\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f\uff0c\u65b0\u5efa\u5931\u8d25");
        companyResultNotice.setSupCompanyId(superCompany.getId());
        companyResultNotice.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyResultNotice.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyResultNotice.setSupCompanyName(superCompany.getCompanyName());
        companyResultNotice.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyResultNotice.setSupCompanyAddress(superCompany.getAddress());
        companyResultNotice.setSupCompanyContacts(superCompany.getContacts());
        companyResultNotice.setSupUserId(user.getId());
    }

    private void setPurCompanyInfo(Company purCompany, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setPurCompanyId(purCompany.getId());
        companyResultNotice.setPurCompanyName(purCompany.getCompanyName());
        companyResultNotice.setPurCompanyFullName(purCompany.getCompanyFullName());
        companyResultNotice.setPurCompanySrmCode(purCompany.getCompanyCode());
        companyResultNotice.setPurCompanySapCode(purCompany.getCompanySapCode());
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void addObj(CompanyResultNotice t) {
        this.companyResultNoticeMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyResultNoticeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void modifyObj(CompanyResultNotice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyResultNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public CompanyResultNotice queryObjById(String id) {
        return this.companyResultNoticeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public List<CompanyResultNotice> queryAllObjByExample(CompanyResultNoticeExample example) {
        return this.companyResultNoticeMapper.selectByExample(example);
    }

    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyResultNotice> queryObjByPage(CompanyResultNoticeExample example) {
        PageView<CompanyResultNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyResultNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void sendToApprove(List<CompanyProcessVO> list) {
        Assert.isNotEmpty(list, (String)"\u4f20\u8f93\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53d1\u9001\u5931\u8d25");
        list.forEach(companyProcess -> {
            Assert.isNotNull((Object)companyProcess.getProcess(), (String)"\u6709\u4f9b\u5e94\u5546\u6ca1\u6709\u6307\u5b9a\u51c6\u5165\u6d41\u7a0b");
            this.judgeToExamine((CompanyProcessVO)((Object)companyProcess));
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"approvalsupplier", (String)companyProcess.getCompanyCode(), (String)companyProcess.getId(), (String)("registerSupAdmittance?supCompanySrmCode=" + companyProcess.getCompanyCode()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (null != startProcess) {
                companyProcess.getProcess().setIsSend(AuthenticationEnum.CERTIFICATION.getCode());
                this.processService.modifyObj(companyProcess.getProcess());
            }
        });
    }

    private void judgeToExamine(CompanyProcessVO companyProcess) {
        if (AuthenticationEnum.CERTIFICATION.getCode() == companyProcess.getProcess().getIsSend()) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + companyProcess.getCompanyCode() + "\u7684\u4f9b\u5e94\u5546\u5df2\u5728\u8ba4\u8bc1\u4e2d\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u5ba1\u6279");
        }
        if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(companyProcess.getProcess().getAccessProcess()) && !ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getQualificationAudit())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + companyProcess.getCompanyCode() + "\u7684\u51c6\u5165\u6d41\u7a0b\u53ea\u8d44\u8d28\u5ba1\u6838\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
        }
        if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(companyProcess.getProcess().getAccessProcess()) && !ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getSceneInvestigate())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + companyProcess.getCompanyCode() + "\u7684\u51c6\u5165\u6d41\u7a0b\u53ea\u73b0\u573a\u8003\u5bdf\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
        }
        if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(companyProcess.getProcess().getAccessProcess())) {
            if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getQualificationAudit())) {
                throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + companyProcess.getCompanyCode() + "\u7684\u51c6\u5165\u6d41\u7a0b\u8d44\u8d28\u5ba1\u6838\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
            }
            if (!ReviewResultEnum.ADOPT.getCode().equals(companyProcess.getProcess().getSceneInvestigate())) {
                throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + companyProcess.getCompanyCode() + "\u7684\u51c6\u5165\u6d41\u7a0b\u73b0\u573a\u8003\u5bdf\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
            }
        }
    }

    @Transactional
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank((String)event.getBusinessId(), (String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Process process = this.processService.queryObjByCompanyId(event.getBusinessId());
        Assert.isNotNull((Object)process, (String)"\u6839\u636e\u4f9b\u5e94\u5546ID\u67e5\u8be2\u51fa\u7684\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f\u4e3a\u7a7a");
        if (event.isFinished() && event.isPass()) {
            process.setIsSend(AuthenticationEnum.CERTIFICATION_SUCCESS.getCode());
            this.modifyCompanyQualified(event);
        } else if (event.isFinished() && !event.isPass()) {
            process.setIsSend(AuthenticationEnum.AUTHENTICATION_FAILURE.getCode());
        }
        process.setUpdateTime(new Date());
        this.processService.modifyObj(process);
    }

    private void modifyCompanyQualified(TaskOperateEvent event) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdEqualTo(event.getBusinessId());
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyService.updatePartnerRole(companyPartner, example);
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(event.getBusinessId());
            List companyUserRef = this.companyUserRefService.queryAllObjByExample((IExample)companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void deleteByExample(CompanyResultNoticeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyResultNoticeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyResultNotice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyResultNoticeMapper.insertSelective((CompanyResultNotice)record));
    }
}

