/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.business.service.impl;

import com.els.base.certification.business.dao.CompanyBusinessMapper;
import com.els.base.certification.business.entity.CompanyBusiness;
import com.els.base.certification.business.entity.CompanyBusinessExample;
import com.els.base.certification.business.service.CompanyBusinessService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyBusinessService")
public class CompanyBusinessServiceImpl
implements CompanyBusinessService {
    @Resource
    protected CompanyBusinessMapper companyBusinessMapper;

    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public void addObj(CompanyBusiness t) {
        this.companyBusinessMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public void addAll(List<CompanyBusiness> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyBusinessMapper.insertBatch(list);
    }

    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyBusinessMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public void deleteByExample(CompanyBusinessExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyBusinessMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public void modifyObj(CompanyBusiness t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyBusinessMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyBusiness"}, keyGenerator="redisKeyGenerator")
    public CompanyBusiness queryObjById(String id) {
        return this.companyBusinessMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyBusiness"}, keyGenerator="redisKeyGenerator")
    public List<CompanyBusiness> queryAllObjByExample(CompanyBusinessExample example) {
        return this.companyBusinessMapper.selectByExample(example);
    }

    @Cacheable(value={"companyBusiness"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyBusiness> queryObjByPage(CompanyBusinessExample example) {
        PageView<CompanyBusiness> pageView = example.getPageView();
        pageView.setQueryResult(this.companyBusinessMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyBusiness"}, allEntries=true)
    public Integer batchInsert(String projectId, Company company, List<CompanyBusiness> companyBusinessList) {
        if (CollectionUtils.isEmpty(companyBusinessList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyBusinessExample BusinessExample = new CompanyBusinessExample();
        BusinessExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId());
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.companyBusinessMapper.deleteByExample(BusinessExample);
        for (CompanyBusiness companyBusiness : companyBusinessList) {
            companyBusiness.setId(null);
            companyBusiness.setProjectId(projectId);
            companyBusiness.setSupCompanyId(company.getId());
            companyBusiness.setIsEnable(Constant.YES_INT);
            companyBusiness.setUpdateTime(new Date());
            if (companyBusiness.getCreateTime() == null) {
                companyBusiness.setCreateTime(new Date());
            }
            Integer finishFlag = companyBusiness.getFinishFlag();
            companyBusiness.setFinishFlag(finishFlag);
            this.companyBusinessMapper.insertSelective(companyBusiness);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }
}

