/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.certificate.util;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ExpirationRemindingJob {
    @Resource
    private CertificateExpiryService certificateExpiryService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyService companyService;
    @Resource
    private RemindInfoService remindInfoService;
    private static final ThreadLocal<DateFormat> DATE_FORMAT_HOLDER = new ThreadLocal();
    private static final String YYYY_MM_DD = "yyyy-MM-dd";

    public void remindInformation() throws ParseException {
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIsEnableRemindersEqualTo(Constant.YES_INT);
        List certificateList = this.certificateExpiryService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)certificateList)) {
            return;
        }
        DateFormat formatter = Optional.ofNullable(DATE_FORMAT_HOLDER.get()).orElseGet(() -> {
            SimpleDateFormat tmp = new SimpleDateFormat(YYYY_MM_DD);
            DATE_FORMAT_HOLDER.set(tmp);
            return tmp;
        });
        long now = formatter.parse(formatter.format(new Date())).getTime();
        for (CertificateExpiry certificate : certificateList) {
            CompanyAuthExample authExample = new CompanyAuthExample();
            authExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(certificate.getClassificationName()).andEndTimeIsNotNull();
            List authList = this.companyAuthService.queryAllObjByExample((IExample)authExample);
            if (CollectionUtils.isEmpty((Collection)authList)) continue;
            long reminderTime = certificate.getAdvanceReminderDays() * 86400000;
            for (CompanyAuth auth : authList) {
                Company company;
                long endTime = formatter.parse(formatter.format(auth.getEndTime())).getTime();
                if (endTime - now >= reminderTime || null == (company = (Company)this.companyService.queryObjById((Object)auth.getSupCompanyId()))) continue;
                RemindInfoExample remindInfoExample = new RemindInfoExample();
                remindInfoExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andCertificateTypeCodeEqualTo(auth.getCertificateTypeCode()).andEndTimeEqualTo(auth.getEndTime()).andIsEnableEqualTo(Constant.YES_INT);
                List remindInfoList = this.remindInfoService.queryAllObjByExample((IExample)remindInfoExample);
                if (!CollectionUtils.isEmpty((Collection)remindInfoList)) continue;
                RemindInfo remindInfo = new RemindInfo();
                remindInfo.setSupCompanyId(company.getId());
                remindInfo.setSupCompanyName(company.getCompanyFullName());
                remindInfo.setSupCompanySrmCode(company.getCompanyCode());
                remindInfo.setCertificateTypeCode(auth.getCertificateTypeCode());
                remindInfo.setCertificateName(CertificateTypeCodeEnum.getDesc(auth.getCertificateTypeCode()));
                remindInfo.setEndTime(auth.getEndTime());
                remindInfo.setIsEnable(Constant.YES_INT);
                remindInfo.setCreateTime(new Date());
                remindInfo.setStatus(Constant.NO_INT);
                this.remindInfoService.addObj(remindInfo);
            }
        }
    }
}

