/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.common;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompany {
    Logger logger = LoggerFactory.getLogger(AbstractCompany.class);

    public Integer getFinishFlag() {
        return this.isFinished() ? Constant.YES_INT : Constant.NO_INT;
    }

    @JsonIgnore
    public boolean isFinished() {
        try {
            Class<?> objectClass = this.getClass();
            Object[] fields = objectClass.getDeclaredFields();
            if (ArrayUtils.isEmpty((Object[])fields)) {
                this.logger.info("\u5c5e\u6027\u6570\u7ec4\u4e3anull\uff0c\u8fd4\u56defalse");
                return false;
            }
            for (Object field : fields) {
                if (this.exculdeFieldNames().contains(((Field)field).getName())) continue;
                ((Field)field).setAccessible(true);
                if (((Field)field).get(this) == null) {
                    this.logger.info("\u5c5e\u6027\u503c\u4e3anull\uff0c\u8fd4\u56defalse");
                    return false;
                }
                if (!((Field)field).getType().equals(String.class)) continue;
                String val = (String)ReflectUtils.getValue((Object)this, (String)((Field)field).getName());
                this.logger.debug("\u5c5e\u6027[{}]\u7684\u503c\u662f[{}]", (Object)((Field)field).getName(), (Object)val);
                if (!StringUtils.isBlank((String)val)) continue;
                this.logger.debug("\u5b57\u7b26\u4e32\u7684\u503c\u4e3a\u7a7a\uff0c\u8fd4\u56defalse");
                return false;
            }
        }
        catch (IllegalAccessException e) {
            throw new CommonException("\u68c0\u67e5\u662f\u5426\u586b\u5b8c\u8d44\u6599\u5931\u8d25");
        }
        catch (Exception e) {
            throw new CommonException("\u68c0\u67e5\u662f\u5426\u586b\u5b8c\u8d44\u6599\u5931\u8d25");
        }
        return true;
    }

    protected List<String> exculdeFieldNames() {
        ArrayList<String> filedNameList = new ArrayList<String>();
        filedNameList.add("id");
        return filedNameList;
    }
}

